/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.source;

import java.util.List;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.util.Version;
import org.eclipse.statet.r.core.source.RSourceConstants;

@NonNullByDefault
public enum RTerminal {
    EOF(""),
    BLANK(" "),
    LINEBREAK("\n"),
    COMMENT("#"),
    ROXYGEN_COMMENT("#'"),
    UNKNOWN(""),
    OTHER(""),
    BLOCK_OPEN("{"),
    BLOCK_CLOSE("}"),
    GROUP_OPEN("("),
    GROUP_CLOSE(")"),
    SUB_INDEXED_S_OPEN("["),
    SUB_INDEXED_D_OPEN("[["),
    SUB_INDEXED_CLOSE("]"),
    SUB_NAMED_PART("$"),
    SUB_NAMED_SLOT("@"),
    NS_GET("::"),
    NS_GET_INT(":::"),
    PLUS("+"),
    MINUS("-"),
    MULT("*"),
    DIV("/"),
    OR("|"),
    OR_D("||"),
    AND("&"),
    AND_D("&&"),
    NOT("!"),
    POWER("^"),
    SEQ(":"),
    SPECIAL("%"),
    QUESTIONMARK("?"),
    COMMA(","),
    SEMICOLON(";"),
    ARROW_LEFT_S("<-"),
    ARROW_LEFT_D("<<-"),
    ARROW_RIGHT_S("->"),
    ARROW_RIGHT_D("->>"),
    EQUAL("="),
    PIPE_RIGHT("|>", RSourceConstants.LANG_VERSION_4_1),
    COLON_EQUAL(":="),
    TILDE("~"),
    REL_NE("!="),
    REL_EQ("=="),
    REL_LT("<"),
    REL_LE("<="),
    REL_GT(">"),
    REL_GE(">="),
    IF("if"),
    ELSE("else"),
    FOR("for"),
    IN("in"),
    WHILE("while"),
    REPEAT("repeat"),
    NEXT("next"),
    BREAK("break"),
    FUNCTION("function"),
    FUNCTION_B("\\", RSourceConstants.LANG_VERSION_4_1),
    SYMBOL(""),
    SYMBOL_G("`"),
    NUM_INT(""),
    NUM_NUM(""),
    NUM_CPLX(""),
    STRING_D("\""),
    STRING_S("'"),
    STRING_R("r\"("),
    NULL("NULL"),
    TRUE("TRUE"),
    FALSE("FALSE"),
    NA("NA"),
    NA_INT("NA_integer_"),
    NA_REAL("NA_real_"),
    NA_CPLX("NA_complex_"),
    NA_CHAR("NA_character_"),
    NAN("NaN"),
    INF("Inf");

    public static final String S_WHITESPACE = " ";
    public static final String S_TAB = "\t";
    public static final String S_LINEBREAK_CRLF = "\r\n";
    public static final String S_LINEBREAK_LF = "\r";
    public static final String S_LINEBREAK_CR = "\n";
    public static final String S_COMMENT = "#";
    public static final String S_BLOCK_OPEN = "{";
    public static final String S_BLOCK_CLOSE = "}";
    public static final String S_GROUP_OPEN = "(";
    public static final String S_GROUP_CLOSE = ")";
    public static final String S_SUB_INDEXED_OPEN = "[";
    public static final String S_SUB_INDEXED_D_OPEN = "[[";
    public static final String S_SUB_INDEXED_CLOSE = "]";
    public static final String S_SUB_NAMED = "$";
    public static final String S_SUB_AT = "@";
    public static final String S_NS_GET = "::";
    public static final String S_NS_GET_INT = ":::";
    public static final String S_PLUS = "+";
    public static final String S_MINUS = "-";
    public static final String S_MULT = "*";
    public static final String S_DIV = "/";
    public static final String S_OR = "|";
    public static final String S_OR_D = "||";
    public static final String S_AND = "&";
    public static final String S_AND_D = "&&";
    public static final String S_NOT = "!";
    public static final String S_POWER = "^";
    public static final String S_COLON = ":";
    public static final String S_SPECIAL = "%";
    public static final String S_QUESTIONMARK = "?";
    public static final String S_COMMA = ",";
    public static final String S_SEMICOLON = ";";
    public static final String S_ARROW_LEFT = "<-";
    public static final String S_ARROW_LEFT_D = "<<-";
    public static final String S_ARROW_RIGHT = "->";
    public static final String S_ARROW_RIGHT_D = "->>";
    public static final String S_EQUAL = "=";
    public static final String S_PIPE_RIGHT = "|>";
    public static final String S_TILDE = "~";
    public static final String S_REL_NE = "!=";
    public static final String S_REL_EQ = "==";
    public static final String S_REL_LT = "<";
    public static final String S_REL_LE = "<=";
    public static final String S_REL_GT = ">";
    public static final String S_REL_GE = ">=";
    public static final String S_IF = "if";
    public static final String S_ELSE = "else";
    public static final String S_FOR = "for";
    public static final String S_IN = "in";
    public static final String S_WHILE = "while";
    public static final String S_REPEAT = "repeat";
    public static final String S_NEXT = "next";
    public static final String S_BREAK = "break";
    public static final String S_FUNCTION = "function";
    public static final String S_BACKSLASH = "\\";
    public static final String S_ELLIPSIS = "...";
    public static final String S_QUOT_S = "'";
    public static final String S_QUOT_D = "\"";
    public static final String S_TRUE = "TRUE";
    public static final String S_FALSE = "FALSE";
    public static final String S_NA = "NA";
    public static final String S_NA_INT = "NA_integer_";
    public static final String S_NA_REAL = "NA_real_";
    public static final String S_NA_CPLX = "NA_complex_";
    public static final String S_NA_CHAR = "NA_character_";
    public static final String S_NULL = "NULL";
    public static final String S_NAN = "NaN";
    public static final String S_INF = "Inf";
    public final String text;
    private final Version minRLangVersion;

    public static final boolean isHWhitespace(char c) {
        switch (c) {
            case '\t': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static final boolean isAnyWhitespace(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    public static @NonNull String[] textArray(List<RTerminal> list) {
        String[] texts = new String[list.size()];
        int i = 0;
        while (i < texts.length) {
            texts[i] = list.get((int)i).text;
            ++i;
        }
        return texts;
    }

    private RTerminal(String text, Version minRLangVersion) {
        this.text = text;
        this.minRLangVersion = minRLangVersion;
    }

    private RTerminal(String text) {
        this(text, RSourceConstants.LANG_VERSION_4_0);
    }

    public Version getMinRLangVersion() {
        return this.minRLangVersion;
    }
}

