/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.PageRegistry;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.console.NIConsole;
import org.eclipse.ui.IPageListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;

@NonNullByDefault
public class ToolRegistry
implements WorkbenchToolRegistry,
IPageListener {
    static boolean DEBUG = false;
    private final Map<IWorkbenchPage, PageRegistry> pageRegistries = new HashMap<IWorkbenchPage, PageRegistry>();
    private boolean isDisposed = false;
    private @Nullable LaunchesListener launchesListener;
    private @Nullable JobListener jobListener;
    private final CopyOnWriteIdentityListSet<WorkbenchToolRegistryListener> listenersWorkbench = new CopyOnWriteIdentityListSet();

    public ToolRegistry() {
        Object listener = new LaunchesListener();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchesListener)listener);
        this.launchesListener = listener;
        this.jobListener = listener = new JobListener();
        Job.getJobManager().addJobChangeListener((IJobChangeListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object listener = this.launchesListener;
        if (listener != null) {
            DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchesListener)listener);
        }
        listener = this.pageRegistries;
        synchronized (listener) {
            this.launchesListener = null;
            for (IWorkbenchPage page : this.pageRegistries.keySet()) {
                page.getWorkbenchWindow().removePageListener((IPageListener)this);
                PageRegistry reg = this.pageRegistries.get(page);
                if (reg == null) continue;
                reg.dispose();
            }
            this.pageRegistries.clear();
            this.isDisposed = true;
        }
        listener = this.jobListener;
        if (listener != null) {
            this.jobListener = null;
            Job.getJobManager().removeJobChangeListener((IJobChangeListener)listener);
        }
        if (DEBUG) {
            System.out.println("[tool registry] registry closed.");
        }
    }

    public void pageOpened(IWorkbenchPage page) {
    }

    public void pageActivated(IWorkbenchPage page) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pageClosed(IWorkbenchPage page) {
        PageRegistry reg;
        Map<IWorkbenchPage, PageRegistry> map = this.pageRegistries;
        synchronized (map) {
            page.getWorkbenchWindow().removePageListener((IPageListener)this);
            reg = this.pageRegistries.remove(page);
        }
        if (reg != null) {
            reg.dispose();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private @Nullable PageRegistry getPageRegistry(@Nullable IWorkbenchPage page) {
        if (page == null) {
            return null;
        }
        Map<IWorkbenchPage, PageRegistry> map = this.pageRegistries;
        synchronized (map) {
            PageRegistry reg = this.pageRegistries.get(page);
            if (reg == null) {
                if (this.isDisposed) {
                    return null;
                }
                IWorkbenchWindow window = page.getWorkbenchWindow();
                if (window == null) {
                    return null;
                }
                window.addPageListener((IPageListener)this);
                reg = new PageRegistry(page, (Set<WorkbenchToolRegistryListener>)this.listenersWorkbench);
                this.pageRegistries.put(page, reg);
            }
            return reg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImList<PageRegistry> getPageRegistries() {
        Map<IWorkbenchPage, PageRegistry> map = this.pageRegistries;
        synchronized (map) {
            return ImCollections.toList(this.pageRegistries.values());
        }
    }

    public void addListener(WorkbenchToolRegistryListener listener, @Nullable IWorkbenchPage page) {
        if (page != null) {
            PageRegistry reg = this.getPageRegistry(page);
            if (reg != null) {
                reg.addListener(listener);
            }
            return;
        }
        this.listenersWorkbench.add((Object)listener);
        ImList<PageRegistry> pageRegistries = this.getPageRegistries();
        for (PageRegistry reg : pageRegistries) {
            reg.addListener(listener);
        }
    }

    public void removeListener(WorkbenchToolRegistryListener listener) {
        this.listenersWorkbench.remove((Object)listener);
        ImList<PageRegistry> pageRegistries = this.getPageRegistries();
        for (PageRegistry reg : pageRegistries) {
            reg.removeListener(listener);
        }
    }

    public void consoleActivated(IConsoleView consoleView, NIConsole console) {
        IWorkbenchPage page = consoleView.getViewSite().getPage();
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.handleActiveConsoleChanged(console, (IViewPart)consoleView);
        }
    }

    public WorkbenchToolSessionData getActiveToolSession(IWorkbenchPage page) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            return reg.createSessionInfo();
        }
        return new WorkbenchToolSessionData(null, null, page, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbenchPage findWorkbenchPage(Tool process) {
        IWorkbenchPage activePage = UIAccess.getActiveWorkbenchPage((boolean)false);
        IWorkbenchPage page = null;
        Map<IWorkbenchPage, PageRegistry> map = this.pageRegistries;
        synchronized (map) {
            for (PageRegistry reg : this.pageRegistries.values()) {
                if (reg.getActiveProcess() != process || (page = reg.getPage()) != activePage) continue;
                return page;
            }
        }
        if (page != null) {
            return page;
        }
        return activePage;
    }

    public @Nullable IConsoleView getConsoleView(NIConsole console, IWorkbenchPage page) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            return reg.getConsoleView(console);
        }
        return null;
    }

    public void showConsole(NIConsole console, IWorkbenchPage page, boolean activate) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.showConsole(console, activate);
        }
    }

    public void showConsoleExplicitly(NIConsole console, IWorkbenchPage page, boolean pin) {
        PageRegistry reg = this.getPageRegistry(page);
        if (reg != null) {
            reg.showConsoleExplicitly(console, pin);
        }
    }

    public @Nullable ToolProvider getToolProvider(IWorkbenchPage page) {
        ObjectUtils.nonNullAssert((Object)page);
        return this.getPageRegistry(page);
    }

    private static class JobListener
    implements IJobChangeListener {
        private static final String OWN_SHOWCONSOLE_NAME = "Show NIConsole";
        private static final String OTHER_SHOWCONSOLE_NAME = "Show Console View";
        private final AtomicInteger ownJobs = new AtomicInteger(0);

        private JobListener() {
        }

        public void scheduled(IJobChangeEvent event) {
            if (event.getJob().getName() == OWN_SHOWCONSOLE_NAME) {
                this.ownJobs.incrementAndGet();
            } else {
                this.checkJob(event.getJob());
            }
        }

        public void aboutToRun(IJobChangeEvent event) {
            this.checkJob(event.getJob());
        }

        public void done(IJobChangeEvent event) {
            if (event.getJob().getName() == OWN_SHOWCONSOLE_NAME) {
                this.ownJobs.decrementAndGet();
            }
        }

        private void checkJob(Job eventJob) {
            if (this.ownJobs.get() > 0 && eventJob.getName() == OTHER_SHOWCONSOLE_NAME) {
                eventJob.cancel();
                if (DEBUG) {
                    System.out.println("[tool registry] show job canceled");
                }
            }
        }

        public void sleeping(IJobChangeEvent event) {
        }

        public void awake(IJobChangeEvent event) {
        }

        public void running(IJobChangeEvent event) {
        }
    }

    private class LaunchesListener
    implements ILaunchesListener {
        private LaunchesListener() {
        }

        public void launchesAdded(@NonNull ILaunch[] launches) {
        }

        public void launchesChanged(@NonNull ILaunch[] launches) {
        }

        public void launchesRemoved(@NonNull ILaunch[] launches) {
            ArrayList<ToolProcess> list = new ArrayList<ToolProcess>();
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                IProcess[] processes;
                ILaunch launch = iLaunchArray[n2];
                IProcess[] iProcessArray = processes = launch.getProcesses();
                int n3 = processes.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    if (process instanceof ToolProcess) {
                        list.add((ToolProcess)process);
                    }
                    ++n4;
                }
                ++n2;
            }
            if (list.isEmpty()) {
                return;
            }
            ImList<PageRegistry> registries = ToolRegistry.this.getPageRegistries();
            for (PageRegistry reg : registries) {
                reg.handleConsolesRemoved(list);
            }
            this.removeConsoles(list);
        }

        private void removeConsoles(List<ToolProcess> processes) {
            IConsole[] consoles;
            ArrayList<IConsole> toRemove = new ArrayList<IConsole>();
            IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
            IConsole[] iConsoleArray = consoles = manager.getConsoles();
            int n = consoles.length;
            int n2 = 0;
            while (n2 < n) {
                IConsole console = iConsoleArray[n2];
                if (console instanceof NIConsole && processes.contains(((NIConsole)console).getProcess())) {
                    toRemove.add(console);
                }
                ++n2;
            }
            manager.removeConsoles(toRemove.toArray(new IConsole[toRemove.size()]));
        }
    }
}

