/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.yaml.ui.sourceediting;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IAutoEditStrategy;
import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.information.IInformationProvider;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.statet.ecommons.preferences.core.util.PreferenceUtils;
import org.eclipse.statet.ecommons.text.ICharPairMatcher;
import org.eclipse.statet.ecommons.text.IIndentSettings;
import org.eclipse.statet.ecommons.text.core.sections.DocContentSections;
import org.eclipse.statet.ecommons.text.ui.presentation.SingleTokenScanner;
import org.eclipse.statet.ecommons.text.ui.settings.TextStyleManager;
import org.eclipse.statet.internal.yaml.ui.YamlUIPlugin;
import org.eclipse.statet.internal.yaml.ui.sourceediting.YamlAutoEditStrategy;
import org.eclipse.statet.internal.yaml.ui.sourceediting.YamlQuickOutlineInformationProvider;
import org.eclipse.statet.ltk.ui.LtkUIPreferences;
import org.eclipse.statet.ltk.ui.sourceediting.EcoReconciler2;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditorViewerConfiguration;
import org.eclipse.statet.ltk.ui.sourceediting.SourceUnitReconcilingStrategy;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistComputerRegistry;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssistProcessor;
import org.eclipse.statet.yaml.core.YamlCore;
import org.eclipse.statet.yaml.core.YamlCoreAccess;
import org.eclipse.statet.yaml.core.source.YamlBracketPairMatcher;
import org.eclipse.statet.yaml.core.source.YamlDocumentConstants;
import org.eclipse.statet.yaml.core.source.YamlDocumentContentInfo;
import org.eclipse.statet.yaml.core.source.YamlHeuristicTokenScanner;
import org.eclipse.statet.yaml.ui.sourceediting.YamlEditingSettings;
import org.eclipse.statet.yaml.ui.text.YamlDefaultTextStyleScanner;
import org.eclipse.statet.yaml.ui.text.YamlDoubleClickStrategy;

public class YamlSourceViewerConfiguration
extends SourceEditorViewerConfiguration {
    private static final String[] CONTENT_TYPES = (String[])YamlDocumentConstants.YAML_CONTENT_TYPES.toArray((Object[])new String[YamlDocumentConstants.YAML_CONTENT_TYPES.size()]);
    protected ITextDoubleClickStrategy doubleClickStrategy;
    private YamlAutoEditStrategy autoEditStrategy;
    private YamlCoreAccess coreAccess;

    public YamlSourceViewerConfiguration(int flags) {
        this((DocContentSections)YamlDocumentContentInfo.INSTANCE, flags, null, null, null, null);
    }

    public YamlSourceViewerConfiguration(DocContentSections documentContentInfo, int flags, SourceEditor editor, YamlCoreAccess access, IPreferenceStore preferenceStore, TextStyleManager textStyles) {
        super(documentContentInfo, flags, editor);
        this.setCoreAccess(access);
        this.setup(preferenceStore != null ? preferenceStore : YamlUIPlugin.getInstance().getEditorPreferenceStore(), LtkUIPreferences.getEditorDecorationPreferences(), YamlEditingSettings.getAssistPrefences());
        this.setTextStyles(textStyles);
    }

    protected void setCoreAccess(YamlCoreAccess access) {
        this.coreAccess = access != null ? access : YamlCore.getWorkbenchAccess();
    }

    protected void initTextStyles() {
        this.setTextStyles(YamlUIPlugin.getInstance().getYamlTextStyles());
    }

    protected void initScanners() {
        TextStyleManager textStyles = this.getTextStyles();
        this.addScanner("Yaml.Default", new YamlDefaultTextStyleScanner(textStyles));
        this.addScanner("Yaml.Directive", (ITokenScanner)new SingleTokenScanner(textStyles, "yaml_ts_Directive"));
        this.addScanner("Yaml.Comment", (ITokenScanner)new SingleTokenScanner(textStyles, "yaml_ts_Comment"));
        this.addScanner("Yaml.Key", (ITokenScanner)new SingleTokenScanner(textStyles, "yaml_ts_Key"));
        this.addScanner("Yaml.Tag", (ITokenScanner)new SingleTokenScanner(textStyles, "yaml_ts_Tag"));
        this.addScanner("Yaml.Value", (ITokenScanner)new SingleTokenScanner(textStyles, "yaml_ts_Default"));
    }

    public List<SourceEditorAddon> getAddOns() {
        List addons = super.getAddOns();
        if (this.autoEditStrategy != null) {
            addons.add(this.autoEditStrategy);
        }
        return addons;
    }

    public void handleSettingsChanged(Set<String> groupIds, Map<String, Object> options) {
        super.handleSettingsChanged(groupIds, options);
        if (this.autoEditStrategy != null) {
            this.autoEditStrategy.getSettings().handleSettingsChanged(groupIds, options);
        }
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return CONTENT_TYPES;
    }

    public ICharPairMatcher createPairMatcher() {
        return new YamlBracketPairMatcher(this.getDocumentContentInfo());
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new YamlDoubleClickStrategy(YamlHeuristicTokenScanner.create((DocContentSections)this.getDocumentContentInfo()));
        }
        return this.doubleClickStrategy;
    }

    protected IIndentSettings getIndentSettings() {
        return this.coreAccess.getYamlCodeStyle();
    }

    public String[] getDefaultPrefixes(ISourceViewer sourceViewer, String contentType) {
        return new String[]{"#", ""};
    }

    public boolean isSmartInsertSupported() {
        return true;
    }

    public boolean isSmartInsertByDefault() {
        return (Boolean)PreferenceUtils.getInstancePrefs().getPreferenceValue(YamlEditingSettings.SMARTINSERT_BYDEFAULT_ENABLED_PREF);
    }

    public IAutoEditStrategy[] getAutoEditStrategies(ISourceViewer sourceViewer, String contentType) {
        if (this.getSourceEditor() == null) {
            return super.getAutoEditStrategies(sourceViewer, contentType);
        }
        if (this.autoEditStrategy == null) {
            this.autoEditStrategy = this.createYamlAutoEditStrategy();
        }
        return new IAutoEditStrategy[]{this.autoEditStrategy};
    }

    protected YamlAutoEditStrategy createYamlAutoEditStrategy() {
        return new YamlAutoEditStrategy(this.coreAccess, this.getSourceEditor());
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        SourceEditor editor = this.getSourceEditor();
        if (!(editor instanceof SourceEditor1)) {
            return null;
        }
        EcoReconciler2 reconciler = new EcoReconciler2(editor);
        reconciler.setDelay(500);
        reconciler.addReconcilingStrategy((IReconcilingStrategy)new SourceUnitReconcilingStrategy());
        return reconciler;
    }

    public void initContentAssist(ContentAssist assistant) {
        ContentAssistComputerRegistry registry = YamlUIPlugin.getInstance().getYamlEditorContentAssistRegistry();
        ContentAssistProcessor processor = new ContentAssistProcessor(assistant, "Yaml.Default", registry, this.getSourceEditor());
        assistant.setContentAssistProcessor((IContentAssistProcessor)processor, "Yaml.Default");
    }

    protected void collectHyperlinkDetectorTargets(Map<String, IAdaptable> targets, ISourceViewer sourceViewer) {
        targets.put("org.eclipse.statet.yaml.editorHyperlinks.YamlEditorTarget", (IAdaptable)this.getSourceEditor());
    }

    protected IInformationProvider getQuickInformationProvider(ISourceViewer sourceViewer, int operation) {
        SourceEditor editor = this.getSourceEditor();
        if (editor == null) {
            return null;
        }
        switch (operation) {
            case 51: {
                return new YamlQuickOutlineInformationProvider(editor, operation);
            }
        }
        return null;
    }
}

