/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.views;

import com.ibm.icu.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.commands.IHandler2;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.window.DefaultToolTip;
import org.eclipse.statet.ecommons.collections.FastList;
import org.eclipse.statet.ecommons.preferences.core.Preference;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistry;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolRegistryListener;
import org.eclipse.statet.ecommons.ts.ui.workbench.WorkbenchToolSessionData;
import org.eclipse.statet.ecommons.ui.SharedMessages;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SearchContributionItem;
import org.eclipse.statet.ecommons.ui.actions.SimpleContributionItem;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.actions.HistoryCopyAction;
import org.eclipse.statet.internal.nico.ui.actions.HistoryDragAdapter;
import org.eclipse.statet.internal.nico.ui.actions.HistorySubmitAction;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.ts.core.ActiveToolListener;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolProvider;
import org.eclipse.statet.nico.core.runtime.History;
import org.eclipse.statet.nico.core.runtime.IHistoryListener;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.NicoUI;
import org.eclipse.statet.nico.ui.actions.LoadHistoryAction;
import org.eclipse.statet.nico.ui.actions.SaveHistoryAction;
import org.eclipse.statet.nico.ui.console.ScrollLockAction;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.SearchPattern;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

public class HistoryView
extends ViewPart
implements ToolProvider {
    private static final EntryFilter EMPTY_FILTER = new EntryFilter(){

        @Override
        public boolean select(History.Entry e) {
            return e.getCommandMarker() >= 0;
        }
    };
    private static final Preference.EnumSetPref<SubmitType> SOURCE_ENCODER = new Preference.EnumSetPref(null, null, SubmitType.class);
    private volatile ToolProcess fProcess;
    private WorkbenchToolRegistryListener fToolRegistryListener;
    private final ViewContentProvider fContentProvider;
    private Table fTable;
    private Clipboard fClipboard;
    private static final String M_FILTER_EMPTY = "FilterEmpty.enabled";
    private boolean fDoFilterEmpty;
    private Action fFilterEmptyAction;
    private final FastList<EntryFilter> fFilter = new FastList(EntryFilter.class, 1);
    private static final String M_AUTOSCROLL = "Autoscroll.enabled";
    private boolean fDoAutoscroll;
    private Action fScrollLockAction;
    private static final String M_FILTER_BY_SOURCE = "FilterBySource.include";
    private SubmitTypeFilter fFilterBySource;
    private final CopyOnWriteIdentityListSet<ActiveToolListener> fToolListeners = new CopyOnWriteIdentityListSet();
    private Action fSelectAllAction;
    private Action fCopyAction;
    private Action fSubmitAction;
    private IHandler2 fSearchStartHandler;
    private IHandler2 fSearchNextHandler;
    private IHandler2 fSearchPrevHandler;
    private SearchContributionItem fSearchTextItem;
    private final SearchPattern fSearchPattern = new SearchPattern(163);
    private LoadHistoryAction fLoadHistoryAction;
    private SaveHistoryAction fSaveHistoryAction;
    private final ViewReloadJob fReloadJob = new ViewReloadJob();

    public static String createTextBlock(History.Entry[] selection) {
        StringBuilder text = new StringBuilder(selection.length * 8);
        int i = 0;
        while (i < selection.length) {
            text.append(selection[i].getCommand());
            text.append('\n');
            ++i;
        }
        return text.toString();
    }

    public static List<String> createCommandList(History.Entry[] selection) {
        Object[] array = new String[selection.length];
        int i = 0;
        while (i < selection.length) {
            array[i] = selection[i].getCommand();
            ++i;
        }
        return ImCollections.newList((Object[])array);
    }

    public HistoryView() {
        this.fContentProvider = new ViewContentProvider();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        String filterEmpty;
        super.init(site, memento);
        String autoscroll = memento != null ? memento.getString(M_AUTOSCROLL) : null;
        this.fDoAutoscroll = autoscroll == null || autoscroll.equals("on");
        String filterBySource = memento != null ? memento.getString(M_FILTER_BY_SOURCE) : null;
        this.fFilterBySource = filterBySource == null ? new SubmitTypeFilter(EnumSet.range(SubmitType.CONSOLE, SubmitType.TOOLS)) : new SubmitTypeFilter(SOURCE_ENCODER.store2Usage(filterBySource));
        this.fFilter.add((Object)this.fFilterBySource);
        String string = filterEmpty = memento != null ? memento.getString(M_FILTER_EMPTY) : null;
        if (filterEmpty == null || filterEmpty.equals("off")) {
            this.fDoFilterEmpty = false;
        } else {
            this.fDoFilterEmpty = true;
            this.fFilter.add((Object)EMPTY_FILTER);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(M_AUTOSCROLL, this.fDoAutoscroll ? "on" : "off");
        memento.putString(M_FILTER_BY_SOURCE, SOURCE_ENCODER.usage2Store(this.fFilterBySource.fSubmitTypes));
        memento.putString(M_FILTER_EMPTY, this.fDoFilterEmpty ? "on" : "off");
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)LayoutUtils.newSashGrid());
        this.fTable = new Table(parent, 66050);
        this.fTable.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fTable.setLinesVisible(false);
        this.fTable.setHeaderVisible(false);
        new DefaultToolTip((Control)this.fTable){
            private final DateFormat fFormat;
            {
                this.fFormat = DateFormat.getDateTimeInstance();
            }

            protected boolean shouldCreateToolTip(Event event) {
                return super.shouldCreateToolTip(event) && HistoryView.this.fTable.getItem(new Point(event.x, event.y)) != null;
            }

            protected String getText(Event event) {
                TableItem item = HistoryView.this.fTable.getItem(new Point(event.x, event.y));
                if (item != null) {
                    History.Entry e = (History.Entry)item.getData();
                    if (e.getTimeStamp() < 0L) {
                        return "[-]\n" + e.getCommand();
                    }
                    return "[" + this.fFormat.format(new Date(e.getTimeStamp())) + "]\n" + e.getCommand();
                }
                return null;
            }
        };
        final TableColumn column = new TableColumn(this.fTable, -1);
        this.fTable.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                int tableWidth = HistoryView.this.fTable.getClientArea().width;
                if (tableWidth == 0) {
                    return;
                }
                column.setWidth(tableWidth);
            }
        });
        this.fTable.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000001 && HistoryView.this.fTable.getSelectionCount() == 1 && HistoryView.this.fTable.getSelectionIndex() == 0) {
                    HistoryView.this.fSearchTextItem.show();
                    HistoryView.this.fTable.deselectAll();
                    e.doit = false;
                }
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.createActions();
        this.hookContextMenu();
        this.contributeToActionBars();
        DragSource dragSource = new DragSource((Control)this.fTable, 1);
        dragSource.setTransfer(new Transfer[]{TextTransfer.getInstance()});
        dragSource.addDragListener((DragSourceListener)new HistoryDragAdapter(this));
        WorkbenchToolRegistry toolRegistry = NicoUI.getToolRegistry();
        this.fToolRegistryListener = new WorkbenchToolRegistryListener(){

            public void toolSessionActivated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        HistoryView.this.connect(tool);
                    }
                });
            }

            public void toolTerminated(WorkbenchToolSessionData sessionData) {
                final Tool tool = sessionData.getTool();
                UIAccess.getDisplay().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        if ((this).HistoryView.this.fProcess != null && (this).HistoryView.this.fProcess == tool) {
                            HistoryView.this.connect(null);
                        }
                    }
                });
            }
        };
        toolRegistry.addListener(this.fToolRegistryListener, this.getViewSite().getPage());
        this.connect(toolRegistry.getActiveToolSession(this.getViewSite().getPage()).getTool());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.statet.nico.ui.cmd_history_view");
    }

    private void updateItem(TableItem item) {
        History.Entry e = (History.Entry)item.getData();
        item.setImage(NicoUI.getUIResources().getImage("org.eclipse.statet.nico/image/obj/consolecommand"));
        item.setText(e.getCommand());
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.fFilterEmptyAction = new FilterEmptyAction();
        this.fScrollLockAction = new ScrollLockAction(new ScrollLockAction.Receiver(){

            @Override
            public void setAutoScroll(boolean enabled) {
                HistoryView.this.fDoAutoscroll = enabled;
            }
        }, !this.fDoAutoscroll);
        this.fSelectAllAction = new Action(){

            public void run() {
                HistoryView.this.fTable.selectAll();
            }
        };
        this.fCopyAction = new HistoryCopyAction(this);
        this.fSubmitAction = new HistorySubmitAction(this);
        this.enabledSelectionActions(false);
        this.fTable.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (HistoryView.this.fTable.getSelectionCount() > 0) {
                    HistoryView.this.enabledSelectionActions(true);
                } else {
                    HistoryView.this.enabledSelectionActions(false);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                HistoryView.this.fSubmitAction.run();
            }
        });
        this.fLoadHistoryAction = new LoadHistoryAction(this);
        this.fSaveHistoryAction = new SaveHistoryAction(this);
        this.fSearchStartHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) {
                HistoryView.this.fSearchTextItem.show();
                return null;
            }
        };
        handlerService.activateHandler("org.eclipse.ui.edit.findReplace", (IHandler)this.fSearchStartHandler);
        this.fSearchNextHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) {
                HistoryView.this.search(true, -1);
                return null;
            }
        };
        handlerService.activateHandler("org.eclipse.ui.edit.findNext", (IHandler)this.fSearchNextHandler);
        handlerService.activateHandler("org.eclipse.ui.navigate.next", (IHandler)this.fSearchNextHandler);
        this.fSearchPrevHandler = new AbstractHandler(){

            public Object execute(ExecutionEvent arg0) {
                HistoryView.this.search(false, -1);
                return null;
            }
        };
        handlerService.activateHandler("org.eclipse.ui.edit.findPrevious", (IHandler)this.fSearchPrevHandler);
        handlerService.activateHandler("org.eclipse.ui.navigate.previous", (IHandler)this.fSearchPrevHandler);
    }

    protected void enabledSelectionActions(boolean enable) {
        this.fCopyAction.setEnabled(enable);
        this.fSubmitAction.setEnabled(enable);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("ContextMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                HistoryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.fTable);
        this.fTable.setMenu(menu);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        bars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        bars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.fLoadHistoryAction);
        manager.add((IAction)this.fSaveHistoryAction);
        manager.add((IContributionItem)new Separator());
        MenuManager filterBySourceMenu = new MenuManager("Include Commands &From", SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/filter_view"), null);
        EnumSet types = SubmitType.getDefaultSet();
        for (SubmitType submitType : types) {
            filterBySourceMenu.add((IContributionItem)new FilterBySourceAction(submitType));
        }
        manager.add((IContributionItem)filterBySourceMenu);
        manager.add((IAction)this.fFilterEmptyAction);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fScrollLockAction);
        manager.add((IContributionItem)new Separator());
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.fCopyAction);
        manager.add((IAction)this.fSubmitAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        this.fSearchTextItem = new SearchContributionItem("search.text", 0x10000000){

            protected void search() {
                HistoryView.this.search(true, -1);
            }
        };
        this.fSearchTextItem.setToolTip(Messages.HistorySearch_Pattern_tooltip);
        this.fSearchTextItem.setSizeControl(this.fTable.getParent());
        this.fSearchTextItem.setResultControl((Control)this.fTable);
        manager.add((IContributionItem)this.fSearchTextItem);
        ImageRegistry ecommonsImages = SharedUIResources.getImages();
        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), "org.eclipse.ui.edit.findNext", "org.eclipse.ui.edit.findNext", null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/down"), null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctoolh/down"), SharedMessages.FindNextMatchAction_tooltip, null, null, 8, null, false), this.fSearchNextHandler));
        manager.add((IContributionItem)new HandlerContributionItem(new CommandContributionItemParameter((IServiceLocator)this.getSite(), "org.eclipse.ui.edit.findPrevious", "org.eclipse.ui.edit.findPrevious", null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/up"), null, ecommonsImages.getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctoolh/up"), SharedMessages.FindPreviousMatchAction_tooltip, null, null, 8, null, false), this.fSearchPrevHandler));
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.fScrollLockAction);
    }

    private void connect(Tool tool) {
        ToolProcess process;
        ToolProcess toolProcess = process = tool instanceof ToolProcess ? (ToolProcess)tool : null;
        if (this.fProcess == process) {
            return;
        }
        if (this.fProcess != null) {
            this.fProcess.getHistory().removeListener((IHistoryListener)this.fContentProvider);
        }
        this.fProcess = process;
        if (this.fProcess != null) {
            this.fProcess.getHistory().addListener((IHistoryListener)this.fContentProvider);
        }
        this.scheduleRefresh(true);
        ActiveToolListener.ActiveToolEvent event = new ActiveToolListener.ActiveToolEvent(1, (Tool)this.fProcess);
        for (ActiveToolListener listener : this.fToolListeners) {
            listener.onToolChanged(event);
        }
    }

    private void scheduleRefresh(boolean change) {
        IWorkbenchSiteProgressService context = (IWorkbenchSiteProgressService)this.getSite().getAdapter(IWorkbenchSiteProgressService.class);
        if (change) {
            this.fReloadJob.cancel();
            context.schedule((Job)this.fReloadJob, 200L);
        } else {
            context.schedule((Job)this.fReloadJob, 0L);
        }
    }

    public void addToolListener(ActiveToolListener action) {
        this.fToolListeners.add((Object)action);
    }

    public void removeToolListener(ActiveToolListener action) {
        this.fToolListeners.remove((Object)action);
    }

    public void addFilter(EntryFilter filter) {
        this.fFilter.add((Object)filter);
        this.scheduleRefresh(false);
    }

    public void removeFilter(EntryFilter filter) {
        this.fFilter.remove((Object)filter);
        this.scheduleRefresh(false);
    }

    public void replaceFilter(EntryFilter oldFilter, EntryFilter newFilter) {
        this.fFilter.replace((Object)oldFilter, (Object)newFilter);
        this.scheduleRefresh(false);
    }

    public void search(String pattern, boolean forward) {
        this.fSearchTextItem.getSearchText().setText(pattern);
        this.search(forward, forward ? 0 : this.fTable.getItemCount() - 1);
    }

    public ToolProcess getTool() {
        return this.fProcess;
    }

    public Clipboard getClipboard() {
        if (this.fClipboard == null) {
            this.fClipboard = new Clipboard(Display.getCurrent());
        }
        return this.fClipboard;
    }

    public History.Entry[] getSelection() {
        TableItem[] items = this.fTable.getSelection();
        int n = items.length;
        History.Entry[] selection = new History.Entry[n];
        int i = 0;
        while (i < n) {
            selection[i] = (History.Entry)items[i].getData();
            ++i;
        }
        return selection;
    }

    public void setFocus() {
        this.fTable.setFocus();
    }

    private void search(boolean forward, int startIdx) {
        int idx;
        char c;
        if (!UIAccess.isOkToUse((Control)this.fTable)) {
            return;
        }
        int itemCount = this.fTable.getItemCount();
        String text = this.fSearchTextItem.getText();
        if (itemCount == 0 || text.isEmpty()) {
            return;
        }
        int start = 0;
        while (((c = text.charAt(start)) == ' ' || c == '\t') && ++start < text.length()) {
        }
        this.fSearchPattern.setPattern(text.substring(start));
        if (startIdx < 0) {
            idx = this.fTable.getSelectionIndex();
        } else {
            int n = idx = forward ? startIdx - 1 : startIdx + 1;
        }
        if (forward) {
            ++idx;
            while (idx < itemCount) {
                History.Entry e = (History.Entry)this.fTable.getItem(idx).getData();
                int offset = e.getCommandMarker();
                if (this.fSearchPattern.matches(e.getCommand().substring(offset >= 0 ? offset : -1 - offset))) {
                    this.fTable.setSelection(idx);
                    return;
                }
                ++idx;
            }
        } else {
            --idx;
            while (idx >= 0) {
                History.Entry e = (History.Entry)this.fTable.getItem(idx).getData();
                int offset = e.getCommandMarker();
                if (this.fSearchPattern.matches(e.getCommand().substring(offset >= 0 ? offset : -1 - offset))) {
                    this.fTable.setSelection(idx);
                    return;
                }
                --idx;
            }
        }
        Display.getCurrent().beep();
    }

    public void dispose() {
        if (this.fToolRegistryListener != null) {
            NicoUI.getToolRegistry().removeListener(this.fToolRegistryListener);
            this.fToolRegistryListener = null;
        }
        this.fReloadJob.cancel();
        ToolProcess process = this.fProcess;
        if (process != null) {
            process.getHistory().removeListener((IHistoryListener)this.fContentProvider);
        }
        this.fToolListeners.clear();
        this.fProcess = null;
        this.fCopyAction = null;
        this.fSubmitAction = null;
        this.fLoadHistoryAction = null;
        this.fSaveHistoryAction = null;
        if (this.fSearchStartHandler != null) {
            this.fSearchStartHandler.dispose();
            this.fSearchStartHandler = null;
        }
        if (this.fSearchPrevHandler != null) {
            this.fSearchPrevHandler.dispose();
            this.fSearchPrevHandler = null;
        }
        if (this.fSearchNextHandler != null) {
            this.fSearchNextHandler.dispose();
            this.fSearchNextHandler = null;
        }
        super.dispose();
        if (this.fClipboard != null) {
            this.fClipboard.dispose();
            this.fClipboard = null;
        }
        this.fTable = null;
    }

    public static interface EntryFilter {
        public boolean select(History.Entry var1);
    }

    private class FilterBySourceAction
    extends SimpleContributionItem {
        private final SubmitType fType;

        public FilterBySourceAction(SubmitType type) {
            super(type.getLabel(), null, 32);
            this.fType = type;
            this.setChecked(HistoryView.this.fFilterBySource.fSubmitTypes.contains(type));
        }

        protected void execute() throws ExecutionException {
            SubmitTypeFilter newFilter;
            SubmitTypeFilter currentFilter = HistoryView.this.fFilterBySource;
            EnumSet<SubmitType> types = EnumSet.copyOf(currentFilter.fSubmitTypes);
            if (types.contains(this.fType)) {
                types.remove(this.fType);
                this.setChecked(false);
            } else {
                types.add(this.fType);
                this.setChecked(true);
            }
            HistoryView.this.fFilterBySource = newFilter = new SubmitTypeFilter(types);
            HistoryView.this.replaceFilter(currentFilter, newFilter);
        }
    }

    private class FilterEmptyAction
    extends Action {
        FilterEmptyAction() {
            this.setText(Messages.FilterEmptyAction_name);
            this.setToolTipText(Messages.FilterEmptyAction_tooltip);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/filter_view"));
            this.setChecked(HistoryView.this.fDoFilterEmpty);
        }

        public void run() {
            boolean switchOn;
            HistoryView.this.fDoFilterEmpty = switchOn = this.isChecked();
            if (switchOn) {
                HistoryView.this.addFilter(EMPTY_FILTER);
            } else {
                HistoryView.this.removeFilter(EMPTY_FILTER);
            }
        }
    }

    private static final class SubmitTypeFilter
    implements EntryFilter {
        private final EnumSet<SubmitType> fSubmitTypes;

        public SubmitTypeFilter(EnumSet<SubmitType> types) {
            this.fSubmitTypes = types;
        }

        @Override
        public boolean select(History.Entry e) {
            SubmitType type = e.getSubmitType();
            return type == null || this.fSubmitTypes.contains(type);
        }
    }

    private class ViewContentProvider
    implements IHistoryListener,
    Runnable {
        private static final int REMOVE_THRESHOLD = 25;
        private History fCurrentSource;
        private boolean fIsScheduled;
        private final List<History.Entry> fToAdd = new ArrayList<History.Entry>(16);
        private final List<History.Entry> fToRemove = new ArrayList<History.Entry>(16);
        private History.Entry[] fNewEntrys;

        private ViewContentProvider() {
        }

        public synchronized void setNewSource(History source, History.Entry[] es) {
            this.fCurrentSource = source;
            this.fNewEntrys = es;
            this.fToAdd.clear();
            this.fToRemove.clear();
            if (!this.fIsScheduled) {
                this.fIsScheduled = true;
                UIAccess.getDisplay().asyncExec((Runnable)this);
            }
        }

        public synchronized void completeChange(History source, History.Entry[] es) {
            if (this.fCurrentSource != source) {
                return;
            }
            this.fNewEntrys = es;
            this.fToAdd.clear();
            this.fToRemove.clear();
            if (!this.fIsScheduled) {
                this.fIsScheduled = true;
                UIAccess.getDisplay().asyncExec((Runnable)this);
            }
        }

        public synchronized void entryAdded(History source, History.Entry e) {
            if (this.fCurrentSource != source) {
                return;
            }
            this.fToAdd.add(e);
            if (!this.fIsScheduled) {
                this.fIsScheduled = true;
                UIAccess.getDisplay().asyncExec((Runnable)this);
            }
        }

        public synchronized void entryRemoved(History source, History.Entry e) {
            if (this.fCurrentSource != source) {
                return;
            }
            this.fToRemove.add(e);
            if (!this.fIsScheduled) {
                this.fIsScheduled = true;
                UIAccess.getDisplay().asyncExec((Runnable)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int i;
            EntryFilter[] filter;
            ImList toRemoveEntries;
            int toRemove;
            ImList toAddEntries;
            int toAdd;
            History.Entry[] newEntries;
            ViewContentProvider viewContentProvider = this;
            synchronized (viewContentProvider) {
                this.fIsScheduled = false;
                if (!UIAccess.isOkToUse((Control)HistoryView.this.fTable)) {
                    return;
                }
                if (HistoryView.this.fProcess != null && this.fCurrentSource != HistoryView.this.fProcess.getHistory() || HistoryView.this.fProcess == null && this.fCurrentSource != null) {
                    return;
                }
                newEntries = this.fNewEntrys;
                this.fNewEntrys = null;
                toAdd = this.fToAdd.size();
                toAddEntries = toAdd > 0 ? ImCollections.clearToList(this.fToAdd) : null;
                toRemove = this.fToRemove.size();
                toRemoveEntries = toRemove > 25 ? ImCollections.clearToList(this.fToRemove) : null;
                filter = (EntryFilter[])HistoryView.this.fFilter.toArray();
            }
            HistoryView.this.fTable.setRedraw(false);
            TableItem addedItem = null;
            if (newEntries != null) {
                HistoryView.this.fTable.deselectAll();
                int reusableItemCount = HistoryView.this.fTable.getItemCount();
                int reuseItemIdx = 0;
                int n = newEntries.length;
                i = 0;
                while (i < n) {
                    block22: {
                        History.Entry e = newEntries[i];
                        int f = 0;
                        while (f < filter.length) {
                            if (filter[f].select(e)) {
                                ++f;
                                continue;
                            }
                            break block22;
                        }
                        addedItem = reuseItemIdx < reusableItemCount ? HistoryView.this.fTable.getItem(reuseItemIdx++) : new TableItem(HistoryView.this.fTable, 0);
                        addedItem.setData((Object)e);
                        HistoryView.this.updateItem(addedItem);
                    }
                    ++i;
                }
                if (reuseItemIdx < reusableItemCount) {
                    HistoryView.this.fTable.remove(reuseItemIdx, reusableItemCount - 1);
                }
                if (addedItem != null) {
                    HistoryView.this.fTable.showItem(addedItem);
                }
            }
            if (toAdd > 0) {
                int i2 = 0;
                while (i2 < toAdd) {
                    block23: {
                        History.Entry e = (History.Entry)toAddEntries.get(i2);
                        int f = 0;
                        while (f < filter.length) {
                            if (filter[f].select(e)) {
                                ++f;
                                continue;
                            }
                            break block23;
                        }
                        addedItem = new TableItem(HistoryView.this.fTable, 0);
                        addedItem.setData((Object)e);
                        HistoryView.this.updateItem(addedItem);
                    }
                    ++i2;
                }
            }
            if (toRemove > 25) {
                int itemCount = HistoryView.this.fTable.getItemCount();
                int[] removeIdxs = new int[toRemove];
                int count = 0;
                i = 0;
                while (i < toRemove) {
                    int j = 0;
                    while (j < itemCount) {
                        TableItem removedItem = HistoryView.this.fTable.getItem(j);
                        if (removedItem.getData() == toRemoveEntries.get(i)) {
                            removedItem.setData(null);
                            removeIdxs[count++] = j;
                        }
                        ++j;
                    }
                    ++i;
                }
                if (count > 0) {
                    if (count < removeIdxs.length) {
                        int[] nArray = removeIdxs;
                        removeIdxs = new int[count];
                        System.arraycopy(nArray, 0, removeIdxs, 0, count);
                    }
                    HistoryView.this.fTable.remove(removeIdxs);
                }
            }
            if (HistoryView.this.fDoAutoscroll && addedItem != null) {
                HistoryView.this.fTable.showItem(addedItem);
            }
            HistoryView.this.fTable.setRedraw(true);
        }
    }

    private class ViewReloadJob
    extends Job {
        ViewReloadJob() {
            super("Update History View");
            this.setPriority(20);
            this.setUser(false);
        }

        protected IStatus run(IProgressMonitor monitor) {
            History.Entry[] entries;
            ToolProcess process = HistoryView.this.fProcess;
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            if (process == null) {
                HistoryView.this.fContentProvider.setNewSource(null, new History.Entry[0]);
                return Status.OK_STATUS;
            }
            History history = process.getHistory();
            history.getReadLock().lock();
            try {
                entries = history.toArray();
            }
            finally {
                history.getReadLock().unlock();
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            HistoryView.this.fContentProvider.setNewSource(history, entries);
            return Status.OK_STATUS;
        }
    }
}

