/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.ui.util;

import java.net.URI;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.dialogs.DialogUtils;
import org.eclipse.statet.ecommons.ui.dialogs.TitleAreaStatusUpdater;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.nico.ui.AbstractConsoleCommandHandler;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.NicoUIPlugin;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.ts.core.util.ToolCommandHandlerUtils;
import org.eclipse.statet.nico.core.runtime.ConsoleService;
import org.eclipse.statet.nico.core.runtime.IProgressInfo;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.ToolDialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ChooseFileHandler
extends AbstractConsoleCommandHandler {
    public static final String CHOOSE_FILE_ID = "common/chooseFile";

    @Override
    public Status execute(String id, final ConsoleService service, Map<String, Object> data, ProgressMonitor m) {
        String s = (String)ToolCommandHandlerUtils.getCheckedData(data, (String)"message", String.class, (boolean)false);
        if (s == null) {
            IProgressInfo progressInfo = service.getController().getProgressInfo();
            s = NLS.bind((String)"Choose file (asked by {0}):", (Object)progressInfo.getLabel());
        }
        final String message = s;
        final Boolean newFile = (Boolean)ToolCommandHandlerUtils.getCheckedData(data, (String)"newResource", Boolean.class, (boolean)true);
        final AtomicReference file = new AtomicReference();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                ChooseFileDialog dialog = new ChooseFileDialog(UIAccess.getActiveWorkbenchShell((boolean)true), service.getTool(), message, newFile);
                dialog.setBlockOnOpen(true);
                if (dialog.open() == 0) {
                    file.set(dialog.getResource());
                }
            }
        };
        UIAccess.getDisplay().syncExec(runnable);
        if (file.get() == null) {
            return Status.CANCEL_STATUS;
        }
        String fileName = ((IFileStore)file.get()).toString();
        data.put("filename", fileName);
        data.put("fileName", fileName);
        return Status.OK_STATUS;
    }

    private static class ChooseFileDialog
    extends ToolDialog {
        private final int fMode;
        private final String fMessage;
        private ResourceInputComposite fLocationGroup;
        private WritableValue fNewLocationString;
        private final String fHistoryId;

        public ChooseFileDialog(Shell shell, ToolProcess tool, String message, boolean newFile) {
            super(tool, shell, null, Messages.Util_ChooseFile_Dialog_title);
            this.fMode = newFile ? 5 : 9;
            this.fMessage = message;
            this.fHistoryId = "statet:" + this.getTool().getMainType() + ":location.commonfile";
        }

        @Override
        protected IDialogSettings getDialogSettings() {
            return DialogUtils.getDialogSettings((Plugin)NicoUIPlugin.getInstance(), (String)"tools/ChooseFileDialog");
        }

        @Override
        protected Control createDialogContent(Composite parent) {
            this.setTitle(this.fMessage);
            Composite composite = new Composite(parent, 0);
            composite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)1));
            Composite inputComposite = new Composite(composite, 0);
            inputComposite.setLayoutData((Object)new GridData(4, 4, true, false));
            inputComposite.setLayout((Layout)LayoutUtils.newCompositeGrid((int)2));
            this.fLocationGroup = new ResourceInputComposite(inputComposite, 1, this.fMode, Messages.Util_ChooseFile_File_label);
            this.fLocationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
            String[] history = this.getDialogSettings().getArray(this.fHistoryId);
            this.fLocationGroup.setHistory(history);
            DataBindingSupport databinding = new DataBindingSupport((Control)composite);
            this.addBindings(databinding);
            this.fNewLocationString.setValue((Object)(history != null && history.length > 0 ? history[0] : ""));
            databinding.installStatusListener((StatusChangeListener)new TitleAreaStatusUpdater((TitleAreaDialog)this, this.fMessage));
            return composite;
        }

        protected void addBindings(DataBindingSupport db) {
            IPath path;
            IFileStore current = this.getTool().getWorkspaceData().getWorkspaceDir();
            String dir = "";
            if (current != null && (path = URIUtil.toPath((URI)current.toURI())) != null) {
                dir = path.toOSString();
            }
            this.fNewLocationString = new WritableValue((Object)dir, String.class);
            db.getContext().bindValue(this.fLocationGroup.getObservable(), (IObservableValue)this.fNewLocationString, new UpdateValueStrategy().setAfterGetValidator((IValidator)this.fLocationGroup.getValidator()), null);
        }

        protected void okPressed() {
            this.saveSettings();
            super.okPressed();
        }

        public void saveSettings() {
            IDialogSettings settings = this.getDialogSettings();
            DialogUtils.saveHistorySettings((IDialogSettings)settings, (String)this.fHistoryId, (String)((String)this.fNewLocationString.getValue()));
        }

        public IFileStore getResource() {
            return this.fLocationGroup.getResourceAsFileStore();
        }
    }
}

