/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui.console;

import java.util.regex.Pattern;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DefaultLineTracker;
import org.eclipse.jface.text.GapTextStore;
import org.eclipse.jface.text.ILineTracker;
import org.eclipse.jface.text.ITextStore;
import org.eclipse.statet.ecommons.text.core.util.AbstractFragmentDocument;
import org.eclipse.statet.ecommons.text.core.util.AbstractSynchronizableDocument;

public class InputDocument
extends AbstractFragmentDocument {
    private static Pattern gLineSeparatorPattern = Pattern.compile("\\r[\\n]?|\\n");

    public InputDocument() {
        this.setTextStore((ITextStore)new GapTextStore(128, 512, 0.1f));
        this.setLineTracker((ILineTracker)new DefaultLineTracker());
        this.completeInitialization();
    }

    protected AbstractDocument createMasterDocument() {
        return new MasterDocument(this.getLockObject());
    }

    public void setPrefix(String text) {
        super.setPrefix(text);
    }

    protected String checkText(String text) {
        return gLineSeparatorPattern.matcher(text).replaceAll("");
    }

    public void set(String text) {
        super.set(this.checkText(text));
    }

    public void set(String text, long modificationStamp) {
        super.set(this.checkText(text), modificationStamp);
    }

    public void replace(int offset, int length, String text, long modificationStamp) throws BadLocationException {
        super.replace(offset, length, this.checkText(text), modificationStamp);
    }

    private static class MasterDocument
    extends AbstractSynchronizableDocument {
        public MasterDocument(Object lockObject) {
            super(lockObject);
            this.setTextStore((ITextStore)new GapTextStore(128, 512, 0.1f));
            this.setLineTracker((ILineTracker)new DefaultLineTracker());
            this.completeInitialization();
        }
    }
}

