/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.nico.ui;

import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.ecommons.ui.workbench.ResourceInputComposite;
import org.eclipse.statet.internal.nico.ui.Messages;
import org.eclipse.statet.internal.nico.ui.actions.AbstractHistoryPage;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.ui.util.SubmitTypeSelectionComposite;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class SaveHistoryPage
extends AbstractHistoryPage {
    private static final String SETTINGS_APPEND = "save.append";
    private static final String SETTINGS_OVERWRITE = "save.overwrite";
    private static final String SETTINGS_SOURCE = "source.include";
    public boolean fAppendToFile;
    public boolean fOverwriteFile;
    private Button fAppendControl;
    private Button fOverwriteControl;
    private SubmitTypeSelectionComposite fSourceControl;

    public SaveHistoryPage(ToolProcess tool) {
        super("SaveHistoryPage", Messages.SaveHistoryPage_title, tool);
        this.setDescription(NLS.bind((String)Messages.SaveHistoryPage_description, (Object)this.fTool.getLabel(0)));
    }

    @Override
    protected ResourceInputComposite createResourceInputComposite(Composite composite) {
        return new ResourceInputComposite(composite, 1, 5, Messages.LoadSaveHistoryPage_File_label);
    }

    @Override
    protected Composite createContentOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        composite.setText("Content:");
        Label label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData(4, 4, true, false));
        label.setText("Include &commands from:");
        this.fSourceControl = new SubmitTypeSelectionComposite((Composite)composite);
        this.fSourceControl.setLayoutData(new GridData(4, 4, true, false));
        return composite;
    }

    @Override
    protected Composite createSaveOptions(Composite parent) {
        Group composite = new Group(parent, 0);
        composite.setLayout((Layout)LayoutUtils.newGroupGrid((int)1));
        composite.setText(Messages.SaveHistoryPage_Options_label);
        this.fAppendControl = new Button((Composite)composite, 32);
        this.fAppendControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fAppendControl.setText(Messages.SaveHistoryPage_AppendToFile_label);
        this.fAppendControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveHistoryPage.this.fAppendToFile = SaveHistoryPage.this.fAppendControl.getSelection();
                if (SaveHistoryPage.this.fAppendToFile) {
                    SaveHistoryPage.this.fOverwriteFile = false;
                    SaveHistoryPage.this.fOverwriteControl.setSelection(false);
                }
                SaveHistoryPage.this.updateMode();
            }
        });
        this.fOverwriteControl = new Button((Composite)composite, 32);
        this.fOverwriteControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fOverwriteControl.setText(Messages.SaveHistoryPage_OverwriteExisting_label);
        this.fOverwriteControl.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SaveHistoryPage.this.fOverwriteFile = SaveHistoryPage.this.fOverwriteControl.getSelection();
                if (SaveHistoryPage.this.fOverwriteFile) {
                    SaveHistoryPage.this.fAppendToFile = false;
                    SaveHistoryPage.this.fAppendControl.setSelection(false);
                }
                SaveHistoryPage.this.updateMode();
            }
        });
        return composite;
    }

    protected void updateMode() {
        int severity = this.fAppendToFile ? 1 : (this.fOverwriteFile ? 2 : 4);
        this.fLocationGroup.getValidator().setOnExisting(severity);
        this.validate();
    }

    @Override
    protected void initFields() {
        super.initFields();
        IDialogSettings settings = this.getDialogSettings();
        this.fAppendToFile = settings.getBoolean(SETTINGS_APPEND);
        this.fAppendControl.setSelection(this.fAppendToFile);
        this.fOverwriteFile = settings.getBoolean(SETTINGS_OVERWRITE);
        this.fOverwriteControl.setSelection(this.fOverwriteFile);
        String sourceSetting = settings.get(SETTINGS_SOURCE);
        if (sourceSetting != null) {
            this.fSourceControl.setSelection(SubmitTypeSelectionComposite.SOURCE_ENCODER.store2Usage(sourceSetting));
        } else {
            this.fSourceControl.setSelection(EnumSet.range(SubmitType.CONSOLE, SubmitType.TOOLS));
        }
        this.updateMode();
    }

    @Override
    public void saveSettings() {
        super.saveSettings();
        IDialogSettings settings = this.getDialogSettings();
        settings.put(SETTINGS_APPEND, this.fAppendToFile);
        settings.put(SETTINGS_OVERWRITE, this.fOverwriteFile);
        settings.put(SETTINGS_SOURCE, SubmitTypeSelectionComposite.SOURCE_ENCODER.usage2Store(this.fSourceControl.getSelection()));
    }

    public Set<SubmitType> getContentSubmitTypes() {
        return this.fSourceControl.getSelection();
    }
}

