/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.IOException;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.server.MainCmdItem;
import org.eclipse.statet.rj.server.RjsStatus;

public final class ConsoleReadCmdItem
extends MainCmdItem {
    public static final int O_ADD_TO_HISTORY = 0;
    private static final int OV_WITHTEXT = 0x1000000;
    private String text;

    public ConsoleReadCmdItem(int options, String text) {
        assert (text != null);
        this.options = options | 0x81000000;
        this.text = text;
    }

    public ConsoleReadCmdItem(RJIO in) throws IOException {
        this.requestId = in.readInt();
        this.options = in.readInt();
        if ((this.options & 0x1000000) != 0) {
            this.text = in.readString();
        }
    }

    @Override
    public void writeExternal(RJIO out) throws IOException {
        out.writeInt(this.requestId);
        out.writeInt(this.options);
        if ((this.options & 0x1000000) != 0) {
            out.writeString(this.text);
        }
    }

    @Override
    public byte getCmdType() {
        return 1;
    }

    @Override
    public byte getOp() {
        return 0;
    }

    @Override
    public void setAnswer(RjsStatus status) {
        this.options = this.options & 0xF00FFFFF | status.getSeverity() << 20;
    }

    public void setAnswer(String text) {
        assert (text != null);
        this.options = this.options & 0xF00FFFFF | 0x41000000;
        this.text = text;
    }

    @Override
    public boolean isOK() {
        return (this.options & 0xF00000) == 0;
    }

    @Override
    public RjsStatus getStatus() {
        return null;
    }

    @Override
    public String getDataText() {
        return this.text;
    }

    @Override
    public boolean testEquals(MainCmdItem other) {
        if (!(other instanceof ConsoleReadCmdItem)) {
            return false;
        }
        ConsoleReadCmdItem otherItem = (ConsoleReadCmdItem)other;
        if (this.options != otherItem.options) {
            return false;
        }
        return (this.options & 0x1000000) == 0 || this.text.equals(otherItem.getDataText());
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        sb.append("ConsoleReadCmdItem");
        sb.append("\n\t").append("options= 0x").append(Integer.toHexString(this.options));
        if ((this.options & 0x1000000) != 0) {
            sb.append("\n<TEXT>\n");
            sb.append(this.text);
            sb.append("\n</TEXT>");
        } else {
            sb.append("\n<TEXT/>");
        }
        return sb.toString();
    }
}

