/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.ui.sourceediting;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.r.console.core.RProcess;
import org.eclipse.statet.r.console.core.RProcessREnvironment;
import org.eclipse.statet.r.console.core.RWorkspace;
import org.eclipse.statet.r.core.RProject;
import org.eclipse.statet.r.core.RProjects;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.core.model.RSourceFrame;
import org.eclipse.statet.r.core.model.RSourceUnit;
import org.eclipse.statet.r.core.model.RSourceUnitModelInfo;
import org.eclipse.statet.r.core.model.RWorkspaceSourceUnit;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;
import org.eclipse.statet.r.ui.sourceediting.RAssistInvocationContext;
import org.eclipse.ui.statushandlers.StatusManager;

public final class RFrameSearchPath
implements Iterable<RFrame> {
    public static final int WORKSPACE_MODE = 1;
    public static final int CONSOLE_MODE = 2;
    public static final int ENGINE_MODE = 3;
    private static final int LOCAL_ID = 0;
    private static final int WORKSPACE_ID = 1;
    private static final int RUNTIME_ID = 2;
    private final List<RFrame>[] frames = new List[3];
    private RElementName expliciteScope;
    private boolean packageMode;
    private Set<String> importedPackages;
    private final Set<String> workspacePackages = new HashSet<String>();
    private RWorkspace runtimeWorkspace;

    public RFrameSearchPath() {
        this.frames[2] = new ArrayList<RFrame>();
    }

    public void init(RAssistInvocationContext context, RAstNode node, int mode, RElementName expliciteScope) {
        RSourceUnit su;
        this.expliciteScope = expliciteScope != null && RElementName.isPackageFacetScopeType((int)expliciteScope.getType()) ? expliciteScope : null;
        RSourceFrame envir = RModel.searchFrame((RAstNode)node);
        this.frames[0] = envir != null && mode <= 2 ? RModel.createDirectFrameList((RFrame)envir, (RElementName)this.expliciteScope) : new ArrayList<RFrame>();
        if (mode == 1 && (su = context.getSourceUnit()) != null) {
            if (this.expliciteScope == null && su instanceof RWorkspaceSourceUnit) {
                RProject rProject = RProjects.getRProject((IProject)((RWorkspaceSourceUnit)su).getResource().getProject());
                this.packageMode = rProject != null && rProject.getPkgName() != null;
            }
            this.importedPackages = this.expliciteScope != null ? ImCollections.newSet((Object)this.expliciteScope.getSegmentName()) : RModel.createImportedPackageList((RSourceUnitModelInfo)((RSourceUnitModelInfo)context.getModelInfo()));
            try {
                this.frames[1] = RModel.createProjectFrameList(null, (RSourceUnit)su, (boolean)true, (this.expliciteScope == null ? 1 : 0) != 0, this.importedPackages, this.workspacePackages);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            if (this.frames[1] != null && !this.frames[1].isEmpty()) {
                this.frames[0].add(this.frames[1].remove(0));
            }
        }
        if (this.frames[1] == null) {
            this.frames[1] = new ArrayList<RFrame>();
        }
        this.runtimeWorkspace = this.getRuntimeWorkspace(context);
        this.addRuntimeFrames(context, mode >= 2);
    }

    private RWorkspace getRuntimeWorkspace(RAssistInvocationContext context) {
        RProcess tool = context.getTool();
        return tool != null ? tool.getWorkspaceData() : null;
    }

    private void addRuntimeFrames(RAssistInvocationContext context, boolean complete) {
        block9: {
            block11: {
                block10: {
                    if (this.runtimeWorkspace == null || !this.runtimeWorkspace.hasRObjectDB()) break block9;
                    if (!complete) break block10;
                    if (this.expliciteScope != null) {
                        RFrame frame = this.resolve(this.expliciteScope, context);
                        this.frames[1].add(frame);
                        return;
                    }
                    this.addDebugFrame(context);
                    List searchEnvs = this.runtimeWorkspace.getRSearchEnvironments();
                    if (searchEnvs == null || searchEnvs.isEmpty()) break block9;
                    for (RProcessREnvironment env : searchEnvs) {
                        RFrame frame = (RFrame)env;
                        if (frame.getFrameType() == 1) {
                            this.frames[0].add(frame);
                            continue;
                        }
                        this.frames[1].add(frame);
                    }
                    break block9;
                }
                if (this.importedPackages == null) break block9;
                if (this.expliciteScope == null || this.workspacePackages.contains(this.expliciteScope.getSegmentName())) break block11;
                RFrame frame = this.resolve(this.expliciteScope, context);
                if (frame == null) break block9;
                this.frames[2].add(frame);
                break block9;
            }
            if (this.packageMode) {
                List searchEnvs = this.runtimeWorkspace.getRSearchEnvironments();
                for (String pkgName : this.importedPackages) {
                    if (this.workspacePackages.contains(pkgName)) continue;
                    RFrame frame = this.resolve(RElementName.create((int)33, (String)pkgName), context);
                    if (frame == null) {
                        frame = this.searchPackage(searchEnvs, pkgName);
                    }
                    if (frame == null) continue;
                    this.frames[2].add(frame);
                }
            } else {
                List searchEnvs = this.runtimeWorkspace.getRSearchEnvironments();
                for (String pkgName : this.importedPackages) {
                    if (this.workspacePackages.contains(pkgName)) continue;
                    RFrame frame = this.searchPackage(searchEnvs, pkgName);
                    if (frame == null) {
                        frame = this.resolve(RElementName.create((int)33, (String)pkgName), context);
                    }
                    if (frame == null) continue;
                    this.frames[2].add(frame);
                }
            }
        }
    }

    private RFrame searchPackage(List<? extends RProcessREnvironment> searchEnvs, String pkgName) {
        if (searchEnvs != null) {
            for (RProcessREnvironment rProcessREnvironment : searchEnvs) {
                RFrame frame = (RFrame)rProcessREnvironment;
                if (frame.getFrameType() != 2 || !frame.getElementName().getSegmentName().equals(pkgName)) continue;
                return frame;
            }
        }
        return null;
    }

    private RFrame resolve(RElementName name, RAssistInvocationContext context) {
        CombinedRElement element = this.runtimeWorkspace.resolve(name, 32);
        if (element != null) {
            return !this.runtimeWorkspace.isNA(element) && element instanceof RFrame ? (RFrame)element : null;
        }
        element = context.getToolReferencesUtil().resolve(name, 0);
        return element instanceof RFrame ? (RFrame)element : null;
    }

    private void addDebugFrame(RAssistInvocationContext context) {
        IDebugTarget debugTarget = context.getTool().getLaunch().getDebugTarget();
        if (debugTarget == null) {
            return;
        }
        try {
            RFrame frame;
            CombinedRElement envir;
            IStackFrame top;
            IThread[] threads = debugTarget.getThreads();
            if (threads.length > 0 && (top = threads[0].getTopStackFrame()) != null && (envir = (CombinedRElement)top.getAdapter(LtkModelElement.class)) instanceof RFrame && (frame = (RFrame)envir).getFrameType() != 2) {
                this.frames[0].add(frame);
            }
        }
        catch (DebugException e) {
            if (e.getStatus().getCode() == 5011 || e.getStatus().getSeverity() == 8) {
                return;
            }
            StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, "An error occurred when collecting environments for content assist.", (Throwable)e));
        }
    }

    public RFrameIterator iterator() {
        return new RFrameIterator();
    }

    public void clear() {
        this.frames[0] = null;
        this.frames[1] = null;
        this.frames[2].clear();
        this.expliciteScope = null;
        this.importedPackages = null;
        this.workspacePackages.clear();
        this.runtimeWorkspace = null;
    }

    public class RFrameIterator
    implements Iterator<RFrame> {
        private int listIter0;
        private int listIter1 = -1;
        private RFrame next;

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean hasNext() {
            if (this.next == null) ** GOTO lbl8
            return true;
lbl-1000:
            // 1 sources

            {
                if (++this.listIter1 < RFrameSearchPath.this.frames[this.listIter0].size()) {
                    this.next = RFrameSearchPath.this.frames[this.listIter0].get(this.listIter1);
                    return true;
                }
                ++this.listIter0;
                this.listIter1 = -1;
lbl8:
                // 2 sources

                ** while (this.listIter0 < RFrameSearchPath.this.frames.length)
            }
lbl9:
            // 1 sources

            return false;
        }

        @Override
        public RFrame next() {
            if (this.hasNext()) {
                RFrame frame = this.next;
                this.next = null;
                return frame;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getEnvirGroup() {
            return this.listIter0;
        }

        public int getRelevance() {
            switch (this.getEnvirGroup()) {
                case 0: {
                    return Math.max(9 - this.listIter1, 3);
                }
                case 1: {
                    return 1;
                }
            }
            return -5;
        }
    }
}

