/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.rdata;

import java.io.IOException;
import org.eclipse.statet.internal.r.rdata.BasicCombinedRElement;
import org.eclipse.statet.internal.r.rdata.RArrayVar;
import org.eclipse.statet.internal.r.rdata.RDataFrameVar;
import org.eclipse.statet.internal.r.rdata.REnvironmentVar;
import org.eclipse.statet.internal.r.rdata.RFunction2;
import org.eclipse.statet.internal.r.rdata.RLanguageVar;
import org.eclipse.statet.internal.r.rdata.RListVar;
import org.eclipse.statet.internal.r.rdata.RMissingVar;
import org.eclipse.statet.internal.r.rdata.RNullVar;
import org.eclipse.statet.internal.r.rdata.ROtherVar;
import org.eclipse.statet.internal.r.rdata.RPromiseVar;
import org.eclipse.statet.internal.r.rdata.RReferenceVar;
import org.eclipse.statet.internal.r.rdata.RS4ObjectVar;
import org.eclipse.statet.internal.r.rdata.RVectorVar;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.rj.data.RJIO;
import org.eclipse.statet.rj.data.RList;
import org.eclipse.statet.rj.data.RObjectFactory;
import org.eclipse.statet.rj.data.impl.DefaultRObjectFactory;

public class CombinedFactory
extends DefaultRObjectFactory {
    public static final String FACTORY_ID = "combined";
    public static final CombinedFactory INSTANCE = new CombinedFactory();

    public @Nullable BasicCombinedRElement readObject(RJIO io) throws IOException {
        assert ((io.flags & 1) != 0);
        return this.readObject(io, null, null);
    }

    public @Nullable BasicCombinedRElement readObject(RJIO io, @Nullable BasicCombinedRElement parent, @Nullable RElementName name) throws IOException {
        byte type = io.readByte();
        switch (type) {
            case -1: {
                return null;
            }
            case 1: {
                return new RNullVar(parent, name);
            }
            case 2: {
                return new RVectorVar(io, (RObjectFactory)this, parent, name);
            }
            case 3: {
                return new RArrayVar(io, (RObjectFactory)this, parent, name);
            }
            case 7: {
                int options = io.readInt();
                return new RListVar(io, this, options, parent, name);
            }
            case 6: {
                int options = io.readInt();
                return new RDataFrameVar(io, this, options, parent, name);
            }
            case 8: {
                return new REnvironmentVar(io, this, parent, name);
            }
            case 12: {
                return new RLanguageVar(io, (RObjectFactory)this, parent, name);
            }
            case 13: {
                return new RFunction2(io, (RObjectFactory)this, parent, name);
            }
            case 14: {
                return new RReferenceVar(io, (RObjectFactory)this, parent, name);
            }
            case 10: {
                return new RS4ObjectVar(io, this, parent, name);
            }
            case 15: {
                return new ROtherVar(io, (RObjectFactory)this, parent, name);
            }
            case 17: {
                return new RMissingVar(parent, name);
            }
            case 18: {
                return new RPromiseVar(parent, name);
            }
        }
        throw new IOException("object type= " + type);
    }

    public RList readAttributeList(RJIO io) throws IOException {
        return new RListVar(io, this, io.readInt(), null, null);
    }
}

