/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;

public class TrackingConfiguration2LaunchConfiguration {
    public static final String LABEL_KEY = "label";
    public static final String TRACK_STREAM_INFO = "TrackInfo.enable";
    public static final String TRACK_STREAM_INPUT = "TrackInput.enable";
    public static final String TRACK_STREAM_INPUT_HISTORYONLY = "TrackInput.HistoryOnly.enable";
    public static final String TRACK_STREAM_OUTPUT = "TrackOutput.enable";
    public static final String TRACK_STREAM_OUTPUT_TRUNCATE = "TrackOutput.Truncate.enable";
    public static final String TRACK_STREAM_OUTPUT_TRUNCATE_LINES = "TrackOutput.Truncate.lines";
    public static final String SUBMIT_TYPES = "SubmitTypes.ids";
    public static final String FILE_PATH = "File.path";
    public static final String FILE_MODE = "File.mode";
    public static final String PREPEND_TIMESTAMP = "Prepend.Timestamp.enable";
    public static final String LOAD_HISTORY = "History.LoadAtStartup.enable";

    public void load(TrackingConfiguration trackingConfig, ILaunchConfiguration launchConfig) throws CoreException {
        String id = trackingConfig.getId();
        trackingConfig.setName(launchConfig.getAttribute(String.valueOf(id) + '.' + LABEL_KEY, ""));
        trackingConfig.setTrackStreamInfo(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INFO, false));
        trackingConfig.setTrackStreamInput(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INPUT, false));
        trackingConfig.setTrackStreamInputHistoryOnly(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INPUT_HISTORYONLY, false));
        trackingConfig.setTrackStreamOutput(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT, false));
        trackingConfig.setTrackStreamOutputTruncate(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT_TRUNCATE, false));
        trackingConfig.setTrackStreamOutputTruncateLines(launchConfig.getAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT_TRUNCATE_LINES, 1000000));
        List submitTypeNames = launchConfig.getAttribute(String.valueOf(id) + '.' + SUBMIT_TYPES, null);
        if (submitTypeNames != null) {
            EnumSet<SubmitType> submitTypes = EnumSet.noneOf(SubmitType.class);
            for (String name : submitTypeNames) {
                submitTypes.add(SubmitType.valueOf(name));
            }
            trackingConfig.setSubmitTypes(submitTypes);
        } else {
            trackingConfig.setSubmitTypes(SubmitType.getDefaultSet());
        }
        trackingConfig.setFilePath(launchConfig.getAttribute(String.valueOf(id) + '.' + FILE_PATH, ""));
        trackingConfig.setFileMode(launchConfig.getAttribute(String.valueOf(id) + '.' + FILE_MODE, TrackingConfiguration.DEFAULT_FILE_MODE));
        trackingConfig.setPrependTimestamp(launchConfig.getAttribute(String.valueOf(id) + '.' + PREPEND_TIMESTAMP, false));
        if (id.equals("history") && launchConfig instanceof HistoryTrackingConfiguration) {
            ((HistoryTrackingConfiguration)launchConfig).setLoadHistory(launchConfig.getAttribute(String.valueOf(id) + '.' + LOAD_HISTORY, false));
        }
    }

    public void save(TrackingConfiguration trackingConfig, ILaunchConfigurationWorkingCopy launchConfig) {
        String id = trackingConfig.getId();
        launchConfig.setAttribute(String.valueOf(id) + '.' + LABEL_KEY, trackingConfig.getName());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INFO, trackingConfig.getTrackStreamInfo());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INPUT, trackingConfig.getTrackStreamInput());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_INPUT_HISTORYONLY, trackingConfig.getTrackStreamInputHistoryOnly());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT, trackingConfig.getTrackStreamOutput());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT_TRUNCATE, trackingConfig.getTrackStreamOutputTruncate());
        launchConfig.setAttribute(String.valueOf(id) + '.' + TRACK_STREAM_OUTPUT_TRUNCATE_LINES, trackingConfig.getTrackStreamOutputTruncateLines());
        EnumSet<SubmitType> submitTypes = trackingConfig.getSubmitTypes();
        ArrayList<String> submitTypeNames = new ArrayList<String>(submitTypes.size());
        for (SubmitType submitType : submitTypes) {
            submitTypeNames.add(submitType.name());
        }
        launchConfig.setAttribute(String.valueOf(id) + '.' + SUBMIT_TYPES, submitTypeNames);
        launchConfig.setAttribute(String.valueOf(id) + '.' + FILE_PATH, trackingConfig.getFilePath());
        launchConfig.setAttribute(String.valueOf(id) + '.' + FILE_MODE, trackingConfig.getFileMode());
        launchConfig.setAttribute(String.valueOf(id) + '.' + PREPEND_TIMESTAMP, trackingConfig.getPrependTimestamp());
        if (id.equals("history") && launchConfig instanceof HistoryTrackingConfiguration) {
            launchConfig.setAttribute(String.valueOf(id) + '.' + LOAD_HISTORY, ((HistoryTrackingConfiguration)launchConfig).getLoadHistory());
        }
    }
}

