/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.nico.core.util;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.EnumSet;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.IDynamicVariable;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.core.model.IStreamMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.statet.ecommons.io.FileUtil;
import org.eclipse.statet.ecommons.variables.core.ILocationVariable;
import org.eclipse.statet.ecommons.variables.core.VariableText;
import org.eclipse.statet.ecommons.variables.core.WrappedDynamicVariable;
import org.eclipse.statet.internal.nico.core.NicoCorePlugin;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.jcommons.status.ErrorStatus;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.Status;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.status.Statuses;
import org.eclipse.statet.jcommons.status.WarningStatus;
import org.eclipse.statet.jcommons.status.eplatform.EStatusUtils;
import org.eclipse.statet.nico.core.runtime.ITrack;
import org.eclipse.statet.nico.core.runtime.SubmitType;
import org.eclipse.statet.nico.core.runtime.ToolController;
import org.eclipse.statet.nico.core.runtime.ToolProcess;
import org.eclipse.statet.nico.core.runtime.ToolStreamMonitor;
import org.eclipse.statet.nico.core.runtime.ToolStreamProxy;
import org.eclipse.statet.nico.core.runtime.ToolWorkspace;
import org.eclipse.statet.nico.core.util.HistoryTrackingConfiguration;
import org.eclipse.statet.nico.core.util.TrackingConfiguration;

public class TrackWriter
implements ITrack,
IStreamListener,
Disposable {
    private static final String TRUNCATE_INFO = "[...] (truncated)\n\n";
    private final ToolController controller;
    private final TrackingConfiguration config;
    private IFileStore storeFile;
    private Writer outputWriter;
    private IStreamListener inputListener;
    private IStreamListener outputListener;
    private int trumcateMax;
    private int truncateCurrent;

    public static String getTruncateInfo() {
        return TRUNCATE_INFO;
    }

    public static String resolveVariables(String path, ToolWorkspace workspace) throws CoreException {
        ImList<IDynamicVariable> variables = workspace.getStringVariables();
        ArrayList<Object> checkedVariables = new ArrayList<Object>(variables.size());
        for (IDynamicVariable variable : variables) {
            if (variable instanceof ILocationVariable) {
                checkedVariables.add(variable);
                continue;
            }
            checkedVariables.add(new WrappedDynamicVariable(variable){

                public String getValue(String argument) throws CoreException {
                    return super.getValue(argument).replaceAll("\\\\|\\/|\\:", "-");
                }
            });
        }
        VariableText text = new VariableText(path, checkedVariables, true);
        text.performInitialStringSubstitution(true);
        text.performFinalStringSubstitution(null);
        return text.getText();
    }

    public TrackWriter(ToolController controller, TrackingConfiguration config) {
        if (controller == null || config == null) {
            throw new NullPointerException();
        }
        this.controller = controller;
        this.config = config;
    }

    public Status init(ProgressMonitor m) throws StatusException {
        OutputStream outputStream = null;
        try {
            m.setWorkRemaining(3);
            try {
                this.storeFile = this.resolveTrackingPath(this.config.getFilePath());
            }
            catch (CoreException e) {
                throw new StatusException((Status)new ErrorStatus("org.eclipse.statet.nico.core", "Failed to resolve path of the tracking file.", (Throwable)e));
            }
            if (this.config.getId().equals("history") && ((HistoryTrackingConfiguration)this.config).getLoadHistory() && this.storeFile.fetchInfo().exists()) {
                this.controller.getTool().getHistory().load(this.storeFile, this.config.getFileEncoding(), false, m.newSubMonitor(2));
            }
            outputStream = this.storeFile.openOutputStream(this.config.getFileMode(), EStatusUtils.convert((ProgressMonitor)m.newSubMonitor(1)));
            if (this.storeFile.fetchInfo().getLength() <= 0L) {
                FileUtil.prepareTextOutput((OutputStream)outputStream, (String)this.config.getFileEncoding());
            }
            this.outputWriter = new BufferedWriter(new OutputStreamWriter(outputStream, this.config.getFileEncoding()));
            EnumSet<SubmitType> submitTypes = this.config.getSubmitTypes();
            ToolStreamProxy streams = this.controller.getStreams();
            if (this.config.getTrackStreamInfo()) {
                streams.getInfoStreamMonitor().addListener(this, submitTypes);
            }
            if (this.config.getTrackStreamInput()) {
                this.inputListener = this.config.getTrackStreamInputHistoryOnly() ? new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        if ((((ToolStreamMonitor)monitor).getMeta() & 1) == 0) {
                            TrackWriter.this.streamAppendedNL(text);
                        }
                    }
                } : new IStreamListener(){

                    public void streamAppended(String text, IStreamMonitor monitor) {
                        TrackWriter.this.streamAppended(text, monitor);
                    }
                };
                streams.getInputStreamMonitor().addListener(this.inputListener, submitTypes);
            }
            if (this.config.getTrackStreamOutput()) {
                if (this.config.getTrackStreamOutputTruncate()) {
                    this.trumcateMax = this.config.getTrackStreamOutputTruncateLines();
                    this.outputListener = new IStreamListener(){

                        public void streamAppended(String text, IStreamMonitor monitor) {
                            TrackWriter.this.streamAppendedTruncateOutput(text);
                        }
                    };
                } else {
                    this.outputListener = this;
                }
                streams.getOutputStreamMonitor().addListener(this.outputListener, submitTypes);
                streams.getErrorStreamMonitor().addListener(this, submitTypes);
                streams.getSystemOutputMonitor().addListener(this.outputListener, submitTypes);
            }
            if (this.config.getPrependTimestamp()) {
                ToolProcess process = this.controller.getTool();
                String comment = process.createTimestampComment(process.getConnectionTimestamp());
                try {
                    this.outputWriter.write(comment);
                }
                catch (Exception e) {
                    this.onError();
                    throw e;
                }
            }
            return Statuses.OK_STATUS;
        }
        catch (Exception e) {
            this.onError();
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return new WarningStatus("org.eclipse.statet.nico.core", NLS.bind((String)"Could not initialize tracking ''{0}''.", (Object)this.config.getName()), (Throwable)e);
        }
    }

    protected IFileStore resolveTrackingPath(String filePath) throws CoreException {
        filePath = TrackWriter.resolveVariables(filePath, this.controller.getWorkspaceData());
        return FileUtil.getFileStore((String)filePath);
    }

    public void streamAppended(String text, IStreamMonitor monitor) {
        this.truncateCurrent = 0;
        try {
            this.outputWriter.write(text);
        }
        catch (IOException e) {
            NicoCorePlugin.logError("An error occurred when writing to the tracking file. Tracking is stopped.", e);
            this.onError();
        }
    }

    private void streamAppendedTruncateOutput(String text) {
        if (this.truncateCurrent == Integer.MAX_VALUE) {
            return;
        }
        String text2 = null;
        if (this.truncateCurrent > this.trumcateMax) {
            this.truncateCurrent = Integer.MAX_VALUE;
            text = TRUNCATE_INFO;
        } else {
            int next = -1;
            while ((next = text.indexOf(10, next + 1)) >= 0) {
                if (++this.truncateCurrent <= this.trumcateMax) continue;
                if (text.length() == next + 1) break;
                this.truncateCurrent = Integer.MAX_VALUE;
                text = text.substring(0, next + 1);
                text2 = TRUNCATE_INFO;
                break;
            }
        }
        try {
            this.outputWriter.write(text);
            if (text2 != null) {
                this.outputWriter.write(text2);
            }
        }
        catch (IOException e) {
            NicoCorePlugin.logError("An error occurred when writing to the tracking file. Tracking is stopped.", e);
            this.onError();
        }
    }

    private void streamAppendedNL(String text) {
        this.truncateCurrent = 0;
        try {
            this.outputWriter.write(text);
            this.outputWriter.write(10);
        }
        catch (IOException e) {
            NicoCorePlugin.logError("An error occurred when writing to the tracking file. Tracking is stopped.", e);
            this.onError();
        }
    }

    private void onError() {
        block8: {
            ToolStreamProxy streams = this.controller.getStreams();
            streams.getInfoStreamMonitor().removeListener(this);
            if (this.inputListener != null) {
                streams.getInputStreamMonitor().removeListener(this.inputListener);
            }
            if (this.outputListener != null) {
                streams.getOutputStreamMonitor().removeListener(this.outputListener);
                streams.getErrorStreamMonitor().removeListener(this);
            }
            if (this.outputWriter != null) {
                try {
                    try {
                        this.outputWriter.close();
                    }
                    catch (IOException iOException) {
                        this.outputWriter = null;
                        break block8;
                    }
                }
                catch (Throwable throwable) {
                    this.outputWriter = null;
                    throw throwable;
                }
                this.outputWriter = null;
            }
        }
        this.dispose();
    }

    public void dispose() {
        if (this.outputWriter != null) {
            try {
                try {
                    this.outputWriter.close();
                }
                catch (IOException e) {
                    NicoCorePlugin.logError("An error occurred when closing the tracking file. Tracking is stopped.", e);
                    this.outputWriter = null;
                }
            }
            finally {
                this.outputWriter = null;
            }
        }
    }

    @Override
    public String getName() {
        return this.config.getName();
    }

    @Override
    public void flush() {
        Writer writer = this.outputWriter;
        if (writer != null) {
            try {
                writer.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public IFileStore getFile() {
        return this.storeFile;
    }
}

