/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.statet.jcommons.collections.CopyOnWriteIdentityListSet;
import org.eclipse.statet.jcommons.collections.ImIdentityList;
import org.eclipse.statet.ltk.model.core.element.LtkModelElement;
import org.eclipse.statet.ltk.model.core.element.LtkModelElementDelta;
import org.eclipse.statet.ltk.model.core.element.SourceUnit;
import org.eclipse.statet.ltk.ui.ISelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.ModelElementInputListener;
import org.eclipse.statet.ltk.ui.ModelElementInputProvider;
import org.eclipse.statet.ltk.ui.PostSelectionCancelExtension;
import org.eclipse.ui.statushandlers.StatusManager;

public class PostSelectionWithElementInfoController {
    private final IPostSelectionProvider selectionProvider;
    private final ModelElementInputProvider modelProvider;
    private final CopyOnWriteIdentityListSet<ISelectionWithElementInfoListener> listeners = new CopyOnWriteIdentityListSet();
    private final CopyOnWriteIdentityListSet<ISelectionWithElementInfoListener> newListeners = new CopyOnWriteIdentityListSet();
    private final Object inputLock = new Object();
    private final ModelElementInputListener elementChangeListener;
    private final SelectionListener selectionListener;
    private final SelectionListener postSelectionListener;
    private PostSelectionCancelExtension cancelExtension;
    private final List<IgnoreActivation> ignoreList = new ArrayList<IgnoreActivation>();
    private SourceUnit input;
    private boolean inputChanged;
    private SelectionChangedEvent currentSelection;
    private volatile int currentNr;
    private final SelectionTask updateJob = new SelectionTask();

    public PostSelectionWithElementInfoController(ModelElementInputProvider modelProvider, IPostSelectionProvider selectionProvider, PostSelectionCancelExtension cancelExt) {
        this.selectionProvider = selectionProvider;
        this.modelProvider = modelProvider;
        this.elementChangeListener = new ModelElementInputListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void elementChanged(LtkModelElement element) {
                Object object = PostSelectionWithElementInfoController.this.inputLock;
                synchronized (object) {
                    if (PostSelectionWithElementInfoController.this.updateJob.getState() == 2) {
                        PostSelectionWithElementInfoController.this.updateJob.cancel();
                    }
                    PostSelectionWithElementInfoController.this.input = (SourceUnit)element;
                    PostSelectionWithElementInfoController.this.inputChanged = true;
                    ++PostSelectionWithElementInfoController.this.currentNr;
                    PostSelectionWithElementInfoController.this.currentSelection = null;
                    PostSelectionWithElementInfoController.this.updateJob.schedule();
                }
            }

            public void elementInitialInfo(LtkModelElement element) {
                this.checkUpdate(element);
            }

            public void elementUpdatedInfo(LtkModelElement element, LtkModelElementDelta delta) {
                this.checkUpdate(element);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void checkUpdate(LtkModelElement element) {
                Object object = PostSelectionWithElementInfoController.this.inputLock;
                synchronized (object) {
                    ++PostSelectionWithElementInfoController.this.currentNr;
                    if (PostSelectionWithElementInfoController.this.currentSelection == null) {
                        return;
                    }
                }
                PostSelectionWithElementInfoController.this.updateJob.run(null);
            }
        };
        this.selectionListener = new SelectionListener();
        this.selectionListener.active = false;
        this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        this.postSelectionListener = new SelectionListener();
        this.postSelectionListener.active = true;
        this.selectionProvider.addPostSelectionChangedListener((ISelectionChangedListener)this.postSelectionListener);
        this.modelProvider.addListener(this.elementChangeListener);
        if (cancelExt != null) {
            this.cancelExtension = cancelExt;
            this.cancelExtension.controller = this;
            this.cancelExtension.init();
        }
    }

    public void setUpdateOnSelection(boolean active) {
        this.selectionListener.active = active;
    }

    public void setUpdateOnPostSelection(boolean active) {
        this.postSelectionListener.active = active;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.inputLock;
        synchronized (object) {
            ++this.currentNr;
            this.currentSelection = null;
        }
    }

    public void dispose() {
        this.cancel();
        this.modelProvider.removeListener(this.elementChangeListener);
        this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectionListener);
        this.selectionProvider.removePostSelectionChangedListener((ISelectionChangedListener)this.postSelectionListener);
        if (this.cancelExtension != null) {
            this.cancelExtension.dispose();
        }
        this.newListeners.clear();
        this.listeners.clear();
    }

    public void addListener(ISelectionWithElementInfoListener listener) {
        this.listeners.add((Object)listener);
        this.newListeners.add((Object)listener);
        this.updateJob.schedule();
    }

    public void removeListener(ISelectionWithElementInfoListener listener) {
        this.newListeners.remove((Object)listener);
        this.listeners.remove((Object)listener);
    }

    public IgnoreActivation ignoreNext(ISelectionWithElementInfoListener listener) {
        IgnoreActivation control = new IgnoreActivation(listener);
        this.ignoreList.add(control);
        return control;
    }

    private void logListenerError(Throwable e) {
        StatusManager.getManager().handle((IStatus)new Status(4, "org.eclipse.statet.ltk.ui", 0, "An error occurred when calling a registered listener.", e));
    }

    public class IgnoreActivation {
        private final ISelectionWithElementInfoListener listener;
        private boolean marked;
        private int nr;

        private IgnoreActivation(ISelectionWithElementInfoListener listener) {
            this.listener = listener;
        }

        public void deleteNext() {
            this.nr = PostSelectionWithElementInfoController.this.currentNr;
            this.marked = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void delete() {
            this.nr = PostSelectionWithElementInfoController.this.currentNr - 1;
            this.marked = true;
            Object object = PostSelectionWithElementInfoController.this.inputLock;
            synchronized (object) {
                PostSelectionWithElementInfoController.this.ignoreList.remove(this);
            }
        }
    }

    private class SelectionListener
    implements ISelectionChangedListener {
        private boolean active;

        private SelectionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void selectionChanged(SelectionChangedEvent event) {
            if (!this.active) {
                return;
            }
            PostSelectionWithElementInfoController postSelectionWithElementInfoController = PostSelectionWithElementInfoController.this;
            synchronized (postSelectionWithElementInfoController) {
                if (PostSelectionWithElementInfoController.this.currentSelection != null && PostSelectionWithElementInfoController.this.currentSelection.getSelection().equals(event.getSelection())) {
                    return;
                }
                ++PostSelectionWithElementInfoController.this.currentNr;
                PostSelectionWithElementInfoController.this.currentSelection = event;
                PostSelectionWithElementInfoController.this.updateJob.schedule();
            }
        }
    }

    private class SelectionTask
    extends Job {
        private int lastNr;

        public SelectionTask() {
            super("PostSelection with Model Updater");
            this.setPriority(20);
            this.setSystem(true);
            this.setUser(false);
            PostSelectionWithElementInfoController.this.currentNr = Integer.MIN_VALUE;
            this.lastNr = Integer.MIN_VALUE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized IStatus run(IProgressMonitor monitor) {
            SourceUnit input = null;
            try {
                Data run;
                this.checkNewInput();
                IgnoreActivation[] ignore = null;
                Object object = PostSelectionWithElementInfoController.this.inputLock;
                synchronized (object) {
                    block23: {
                        run = new Data(PostSelectionWithElementInfoController.this.input, PostSelectionWithElementInfoController.this.currentSelection, PostSelectionWithElementInfoController.this.currentNr);
                        if (run.inputElement != null && run.selection != null && (this.lastNr != run.stateNr || !PostSelectionWithElementInfoController.this.newListeners.isEmpty())) break block23;
                        IStatus iStatus = Status.OK_STATUS;
                        return iStatus;
                    }
                    if (!PostSelectionWithElementInfoController.this.ignoreList.isEmpty()) {
                        int num = PostSelectionWithElementInfoController.this.ignoreList.size();
                        ignore = PostSelectionWithElementInfoController.this.ignoreList.toArray(new IgnoreActivation[num]);
                        int i = num - 1;
                        while (i >= 0) {
                            if (ignore[i].marked && ignore[i].nr != run.stateNr) {
                                PostSelectionWithElementInfoController.this.ignoreList.remove(i);
                                ignore[i] = null;
                                --num;
                            }
                            --i;
                        }
                        if (num == 0) {
                            ignore = null;
                        }
                    }
                    input = run.inputElement;
                    input.connect(monitor);
                }
                if (run.getInputInfo() == null || run.getInputInfo().getStamp().getContentStamp() != input.getDocument(null).getModificationStamp()) {
                    IStatus iStatus = Status.OK_STATUS;
                    return iStatus;
                }
                ImIdentityList listeners = PostSelectionWithElementInfoController.this.newListeners.clearToList();
                if (run.stateNr != this.lastNr) {
                    listeners = PostSelectionWithElementInfoController.this.listeners.toList();
                    this.lastNr = run.stateNr;
                }
                block13: for (ISelectionWithElementInfoListener listener : listeners) {
                    if (ignore != null) {
                        int j = 0;
                        while (j < ignore.length) {
                            if (ignore[j] != null && ignore[j].listener == listener) continue block13;
                            ++j;
                        }
                    }
                    if (!run.isStillValid()) {
                        IStatus iStatus = Status.CANCEL_STATUS;
                        return iStatus;
                    }
                    try {
                        listener.stateChanged(run);
                    }
                    catch (Exception e) {
                        PostSelectionWithElementInfoController.this.logListenerError(e);
                    }
                }
            }
            finally {
                if (input != null) {
                    input.disconnect(monitor);
                }
            }
            return Status.OK_STATUS;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void checkNewInput() {
            if (PostSelectionWithElementInfoController.this.inputChanged) {
                Object object = PostSelectionWithElementInfoController.this.inputLock;
                synchronized (object) {
                    PostSelectionWithElementInfoController.this.inputChanged = false;
                }
                ImIdentityList listeners = PostSelectionWithElementInfoController.this.listeners.toList();
                for (ISelectionWithElementInfoListener listener : listeners) {
                    try {
                        listener.inputChanged();
                    }
                    catch (Exception e) {
                        PostSelectionWithElementInfoController.this.logListenerError(e);
                    }
                }
            }
        }

        private final class Data
        extends LTKInputData {
            int stateNr;

            Data(SourceUnit input, SelectionChangedEvent currentSelection, int runNr) {
                super(input, currentSelection != null ? currentSelection.getSelection() : null);
                this.stateNr = runNr;
            }

            @Override
            public boolean isStillValid() {
                return ((SelectionTask)SelectionTask.this).PostSelectionWithElementInfoController.this.currentNr == this.stateNr;
            }
        }
    }
}

