/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.PasswordCallback;
import org.eclipse.statet.rj.RjException;

public final class ServerLogin
implements Serializable {
    private static final long serialVersionUID = -596748668244272719L;
    private long id;
    private Key pubkey;
    private Callback[] callbacks;

    public ServerLogin() {
    }

    public ServerLogin(long id, Key pubkey, Callback[] callbacks) {
        this.id = id;
        this.pubkey = pubkey;
        this.callbacks = callbacks;
    }

    public long getId() {
        return this.id;
    }

    public Callback[] getCallbacks() {
        return this.callbacks;
    }

    public ServerLogin createAnswer() throws RjException {
        try {
            Callback[] copy;
            if (this.callbacks != null) {
                copy = new Callback[this.callbacks.length];
                System.arraycopy(this.callbacks, 0, copy, 0, this.callbacks.length);
                if (this.pubkey != null) {
                    this.process(copy, 1, this.pubkey);
                }
            } else {
                copy = null;
            }
            return new ServerLogin(this.id, null, copy);
        }
        catch (Exception e) {
            throw new RjException("An error occurred when creating login data.", e);
        }
    }

    public void readAnswer(Key privateKey) throws RjException {
        try {
            if (privateKey != null) {
                this.process(this.callbacks, 2, privateKey);
            }
        }
        catch (Exception e) {
            throw new RjException("An error occurred when processing login data.", e);
        }
    }

    private void process(Callback[] callbacks, int mode, Key key) throws Exception {
        Cipher with = Cipher.getInstance("RSA");
        with.init(mode, key);
        Charset charset = StandardCharsets.UTF_8;
        int i = 0;
        while (i < callbacks.length) {
            PasswordCallback c;
            char[] orgPassword;
            if (callbacks[i] instanceof PasswordCallback && (orgPassword = (c = (PasswordCallback)callbacks[i]).getPassword()) != null) {
                char[] encPassword;
                byte[] orgBytes;
                if (mode == 1) {
                    orgBytes = charset.encode(CharBuffer.wrap(orgPassword)).array();
                } else {
                    orgBytes = new byte[orgPassword.length];
                    int j = 0;
                    while (j < orgBytes.length) {
                        orgBytes[j] = (byte)orgPassword[j];
                        ++j;
                    }
                }
                byte[] encBytes = with.doFinal(orgBytes);
                if (mode == 1) {
                    encPassword = new char[encBytes.length];
                    int j = 0;
                    while (j < encPassword.length) {
                        encPassword[j] = (char)encBytes[j];
                        ++j;
                    }
                } else {
                    encPassword = charset.decode(ByteBuffer.wrap(encBytes)).array();
                }
                if (mode == 1) {
                    PasswordCallback copy = new PasswordCallback(c.getPrompt(), c.isEchoOn());
                    copy.setPassword(encPassword);
                    callbacks[i] = copy;
                } else {
                    c.clearPassword();
                    c.setPassword(encPassword);
                }
                Arrays.fill(orgBytes, (byte)0);
                Arrays.fill(orgPassword, '\u0000');
                Arrays.fill(encBytes, (byte)0);
                Arrays.fill(encPassword, '\u0000');
            }
            ++i;
        }
    }

    public void clearData() {
        this.pubkey = null;
        if (this.callbacks != null) {
            int i = 0;
            while (i < this.callbacks.length) {
                if (this.callbacks[i] instanceof PasswordCallback) {
                    ((PasswordCallback)this.callbacks[i]).clearPassword();
                }
                this.callbacks[i] = null;
                ++i;
            }
            this.callbacks = null;
        }
    }
}

