/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui;

import java.util.List;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.validation.MultiValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.ui.dialogs.AbstractCheckboxSelectionDialog;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class ProjectSelectionDialog
extends AbstractCheckboxSelectionDialog {
    private final List<IProject> fProjects;

    public ProjectSelectionDialog(Shell parentShell, List<IProject> projects) {
        super(parentShell, 2, projects);
        this.fProjects = projects;
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = new Composite(parent, 0);
        area.setLayoutData((Object)new GridData(4, 128, true, true));
        area.setLayout((Layout)LayoutUtils.newDialogGrid((int)1));
        Composite checkboxComposite = this.createCheckboxComposite(area, "&R projects:");
        checkboxComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        ProjectSelectionDialog.applyDialogFont((Control)area);
        return area;
    }

    protected void configureViewer(CheckboxTableViewer viewer) {
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)WorkbenchLabelProvider.getDecoratingWorkbenchLabelProvider());
        viewer.setInput(this.fProjects);
    }

    protected void addBindings(DataBindingSupport db) {
        super.addBindings(db);
        MultiValidator notEmptyValidator = new MultiValidator(){

            protected IStatus validate() {
                if (ProjectSelectionDialog.this.getCheckedElements().isEmpty()) {
                    return ValidationStatus.error((String)"Please select at least one project.");
                }
                return ValidationStatus.ok();
            }
        };
        db.getContext().addValidationStatusProvider((ValidationStatusProvider)notEmptyValidator);
    }
}

