/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.internal.r.debug.core.model.IRIndexValueInternal;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariableValue;
import org.eclipse.statet.internal.r.debug.core.model.REnvValue;
import org.eclipse.statet.internal.r.debug.core.model.RIndexedValueProxy;
import org.eclipse.statet.internal.r.debug.core.model.RVariableProxy;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.IRDebugTarget;
import org.eclipse.statet.r.debug.core.IRValue;
import org.eclipse.statet.r.debug.core.IRVariable;

@NonNullByDefault
public class RValueProxy
implements IRValue {
    protected final IRValue value;
    protected final IRVariable variable;

    public static RValueProxy create(IRValue value, IRVariable variable) {
        if (value instanceof RValueProxy) {
            value = ((RValueProxy)value).value;
        }
        if (value instanceof IRIndexValueInternal) {
            return new RIndexedValueProxy((IRIndexValueInternal)value, variable);
        }
        return new RValueProxy(value, variable);
    }

    public RValueProxy(IRValue value, IRVariable variable) {
        this.value = value;
        this.variable = variable;
    }

    @Override
    public IRVariable getAssignedVariable() {
        return this.variable;
    }

    public final String getModelIdentifier() {
        return this.value.getModelIdentifier();
    }

    @Override
    public final IRDebugTarget getDebugTarget() {
        return this.value.getDebugTarget();
    }

    public final ILaunch getLaunch() {
        return this.value.getLaunch();
    }

    public final String getReferenceTypeName() throws DebugException {
        return this.value.getReferenceTypeName();
    }

    @Override
    public final String getValueString() throws DebugException {
        if (this.value instanceof REnvValue) {
            return ((REnvValue)this.value).getValueString(this.variable);
        }
        return this.value.getValueString();
    }

    @Override
    public String getDetailString() {
        if (this.value instanceof REnvValue) {
            return ((REnvValue)this.value).getDetailString(this.variable);
        }
        return this.value.getDetailString();
    }

    public final boolean isAllocated() throws DebugException {
        return this.value.isAllocated();
    }

    public final boolean hasVariables() throws DebugException {
        return this.value.hasVariables();
    }

    public @NonNull IVariable[] getVariables() throws DebugException {
        IVariable[] orgVariables = this.value.getVariables();
        if (orgVariables.length == 0) {
            return RElementVariableValue.NO_VARIABLES;
        }
        @NonNull IVariable[] proxyVariables = new IVariable[orgVariables.length];
        int i = 0;
        while (i < orgVariables.length) {
            proxyVariables[i] = RVariableProxy.create((IRVariable)orgVariables[i], this.variable);
            ++i;
        }
        return proxyVariables;
    }

    public <T> @Nullable T getAdapter(Class<T> type) {
        return (T)this.value.getAdapter(type);
    }

    public final int hashCode() {
        return this.value.hashCode();
    }

    public final String toString() {
        return this.value.toString();
    }
}

