/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.core;

import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextLineInformation;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.jcommons.text.core.util.TextLineInformationCreator;

@NonNullByDefault
public class SourceContent
extends BasicTextRegion
implements TextRegion {
    private static final TextLineInformationCreator LINES_CREATOR = new TextLineInformationCreator();
    private final long stamp;
    private final String text;
    private volatile @Nullable TextLineInformation lines;

    public SourceContent(long stamp, String text) {
        this(stamp, text, 0);
    }

    public SourceContent(long stamp, String text, int startOffset) {
        super(startOffset, startOffset + text.length());
        this.stamp = stamp;
        this.text = text;
        this.lines = null;
    }

    public SourceContent(long stamp, String text, int startOffset, TextLineInformation lines) {
        super(startOffset, startOffset + text.length());
        this.stamp = stamp;
        this.text = text;
        this.lines = lines;
    }

    public final long getStamp() {
        return this.stamp;
    }

    public final String getText() {
        return this.text;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final TextLineInformation getLines() {
        TextLineInformation lines = this.lines;
        if (lines == null) {
            TextLineInformationCreator textLineInformationCreator = LINES_CREATOR;
            synchronized (textLineInformationCreator) {
                lines = this.lines;
                if (lines == null) {
                    lines = LINES_CREATOR.create(this.text);
                }
            }
        }
        return lines;
    }

    public String toString() {
        return this.getText();
    }
}

