/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.waltable.data.convert;

import java.text.SimpleDateFormat;
import java.util.TimeZone;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.statet.ecommons.waltable.Messages;
import org.eclipse.statet.ecommons.waltable.data.convert.ConversionFailedException;
import org.eclipse.statet.ecommons.waltable.data.convert.DisplayConverter;
import org.eclipse.statet.internal.ecommons.waltable.WaLTablePlugin;

public class DefaultDateDisplayConverter
extends DisplayConverter {
    private SimpleDateFormat dateFormat;

    public DefaultDateDisplayConverter() {
        this(null, null);
    }

    public DefaultDateDisplayConverter(TimeZone timeZone) {
        this(null, timeZone);
    }

    public DefaultDateDisplayConverter(String dateFormat) {
        this(dateFormat, null);
    }

    public DefaultDateDisplayConverter(String dateFormat, TimeZone timeZone) {
        this.dateFormat = dateFormat != null ? new SimpleDateFormat(dateFormat) : new SimpleDateFormat();
        if (timeZone != null) {
            this.dateFormat.setTimeZone(timeZone);
        }
    }

    @Override
    public Object canonicalToDisplayValue(Object canonicalValue) {
        try {
            if (canonicalValue != null) {
                return this.dateFormat.format(canonicalValue);
            }
        }
        catch (IllegalArgumentException e) {
            WaLTablePlugin.log((IStatus)new Status(2, "org.eclipse.statet.ecommons.waltable.core", "Invalid date value", (Throwable)e));
        }
        return "";
    }

    @Override
    public Object displayToCanonicalValue(Object displayValue) {
        try {
            return this.dateFormat.parse(displayValue.toString());
        }
        catch (Exception e) {
            throw new ConversionFailedException(Messages.getString("DefaultDateDisplayConverter.failure", new Object[]{displayValue, this.dateFormat.toPattern()}), e);
        }
    }
}

