/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.datafilter;

import java.util.Collection;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.set.WritableSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterSet;
import org.eclipse.statet.internal.r.ui.datafilter.FilterType;
import org.eclipse.statet.internal.r.ui.datafilter.LevelVariableFilter;
import org.eclipse.statet.internal.r.ui.datafilter.Messages;
import org.eclipse.statet.internal.r.ui.datafilter.TextSearchType;
import org.eclipse.statet.internal.r.ui.datafilter.VariableFilter;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.r.ui.dataeditor.RDataTableColumn;
import org.eclipse.statet.rj.data.RCharacterStore;
import org.eclipse.statet.rj.data.RDataUtils;
import org.eclipse.statet.rj.data.RObject;
import org.eclipse.statet.rj.data.RStore;
import org.eclipse.statet.rj.data.UnexpectedRDataException;
import org.eclipse.statet.rj.data.impl.RCharacter32Store;
import org.eclipse.statet.rj.services.FunctionCall;
import org.eclipse.statet.rj.ts.core.RToolService;

public class TextVariableFilter
extends VariableFilter {
    private TextSearchType searchType;
    private String searchText;
    private RCharacter32Store availableValues = NO_VALUES;
    private final IObservableSet<@Nullable String> selectedValues;

    public TextVariableFilter(FilterSet set, RDataTableColumn column) {
        super(set, column);
        this.selectedValues = new WritableSet(set.getRealm());
        this.registerObservable((IObservable)this.selectedValues);
    }

    @Override
    public FilterType getType() {
        return FilterType.TEXT;
    }

    @Override
    public void load(VariableFilter filter) {
        if (filter.getType() == FilterType.LEVEL) {
            final LevelVariableFilter levelFilter = (LevelVariableFilter)filter;
            this.runInRealm(new Runnable(){

                @Override
                public void run() {
                    TextVariableFilter.this.selectedValues.addAll((Collection)levelFilter.getSelectedValues());
                }
            });
        } else if (filter.getType() == FilterType.TEXT) {
            final TextVariableFilter textFilter = (TextVariableFilter)filter;
            this.runInRealm(new Runnable(){

                @Override
                public void run() {
                    if (TextVariableFilter.this.availableValues.getLength() == 0L) {
                        TextVariableFilter.this.availableValues = textFilter.availableValues;
                    }
                    TextVariableFilter.this.selectedValues.addAll(textFilter.getSelectedValues());
                }
            });
        }
    }

    @Override
    public void reset() {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                TextVariableFilter.this.selectedValues.clear();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void update(RToolService r, ProgressMonitor m) throws StatusException, UnexpectedRDataException {
        TextSearchType searchType;
        String searchText;
        RDataTableColumn column = this.getColumn();
        TextVariableFilter textVariableFilter = this;
        synchronized (textVariableFilter) {
            searchText = this.searchText;
            searchType = this.searchType;
            this.searchText = null;
            this.searchType = null;
        }
        if (searchType != null && searchText != null) {
            FunctionCall fcall = r.createFunctionCall("rj:::.searchDataTextValues");
            fcall.add(column.getRExpression());
            fcall.addInt("type", searchType.getId());
            fcall.addChar("pattern", searchText);
            fcall.addInt("max", 100);
            RObject data = fcall.evalData(m);
            if (data.getRObjectType() == 1) {
                this.setError(Messages.TextFilter_TooMuch_message);
                return;
            }
            this.addValues((RCharacterStore)RDataUtils.checkRCharVector((RObject)data).getData());
        }
    }

    private static RCharacter32Store combine(RCharacter32Store old, RCharacterStore add) {
        if (add.getLength() == 0L) {
            return old;
        }
        if (old.getLength() == 0L && add instanceof RCharacter32Store) {
            return (RCharacter32Store)add;
        }
        String[] values = new String[(int)Math.max(old.getLength() + add.getLength(), 10000L)];
        int i = 0;
        while ((long)i < add.getLength()) {
            values[i] = add.get(i);
            ++i;
        }
        int j = 0;
        while ((long)j < add.getLength() && i < values.length) {
            String s = add.get(j);
            if (!add.contains(s)) {
                values[i++] = s;
            }
            ++j;
        }
        return new RCharacter32Store(values, i);
    }

    @Override
    protected void setError(final String message) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                TextVariableFilter.super.setError(message);
                TextVariableFilter.this.notifyListeners();
            }
        });
    }

    protected void addValues(final RCharacterStore add) {
        this.runInRealm(new Runnable(){

            @Override
            public void run() {
                TextVariableFilter.this.availableValues = TextVariableFilter.combine(TextVariableFilter.this.availableValues, add);
                TextVariableFilter.super.setError(null);
                TextVariableFilter.this.notifyListeners();
            }
        });
    }

    @Override
    protected String createFilter(String varExpression) {
        return LevelVariableFilter.createLevelFilter((RStore)this.availableValues, this.selectedValues, varExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void search(TextSearchType type, String text) {
        TextVariableFilter textVariableFilter = this;
        synchronized (textVariableFilter) {
            this.searchType = type;
            this.searchText = text;
        }
        this.scheduleUpdate();
    }

    public RCharacterStore getAvailableValues() {
        return this.availableValues;
    }

    public IObservableSet<@Nullable String> getSelectedValues() {
        return this.selectedValues;
    }

    public void removeAllValues() {
        this.availableValues = NO_VALUES;
        this.selectedValues.clear();
    }

    public void removeValues(Collection<@Nullable String> values) {
        if (values.isEmpty()) {
            return;
        }
        for (String value : values) {
            int idx = (int)this.availableValues.indexOf(value);
            if (idx < 0) continue;
            this.availableValues.remove(idx);
        }
        this.selectedValues.removeAll(values);
    }
}

