/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.r.core.model;

import java.util.Comparator;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RFrame;
import org.eclipse.statet.r.core.rsource.ast.RAstNode;

@NonNullByDefault
public abstract class RElementAccess
extends RElementName {
    public static final Comparator<RElementAccess> NAME_POSITION_COMPARATOR = new Comparator<RElementAccess>(){

        private int comparePosition(@Nullable RAstNode node1, @Nullable RAstNode node2) {
            if (node1 == node2) {
                return 0;
            }
            if (node1 == null) {
                return -1;
            }
            if (node2 == null) {
                return 1;
            }
            return Integer.compare(node1.getStartOffset(), node2.getStartOffset());
        }

        @Override
        public int compare(RElementAccess o1, RElementAccess o2) {
            int offset;
            if (o1 == o2) {
                return 0;
            }
            RElementAccess segment1 = o1;
            RElementAccess segment2 = o2;
            while ((offset = this.comparePosition(segment1.getNameNode(), segment2.getNameNode())) == 0) {
                segment1 = o1.getNextSegment();
                if (segment1 == (segment2 = o2.getNextSegment())) {
                    return 0;
                }
                if (segment1 == null) {
                    return -1;
                }
                if (segment2 != null) continue;
                return 1;
            }
            return offset;
        }
    };

    public static @Nullable RElementAccess getMainElementAccessOfNameNode(RAstNode nameNode) {
        RAstNode node = nameNode;
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof RElementAccess)) continue;
                RElementAccess access = (RElementAccess)attachment;
                do {
                    if (!access.isMaster() || access.getNameNode() != nameNode) continue;
                    return (RElementAccess)attachment;
                } while ((access = access.getNextSegment()) != null);
            }
            node = node.getRParent();
        }
        return null;
    }

    public static @Nullable RElementAccess getElementAccessOfNameNode(RAstNode nameNode) {
        RAstNode node = nameNode;
        while (node != null) {
            ImList attachments = node.getAttachments();
            for (Object attachment : attachments) {
                if (!(attachment instanceof RElementAccess)) continue;
                RElementAccess access = (RElementAccess)attachment;
                do {
                    if (!access.isMaster() || access.getNameNode() != nameNode) continue;
                    return access;
                } while ((access = access.getNextSegment()) != null);
            }
            node = node.getRParent();
        }
        return null;
    }

    public abstract RFrame getFrame();

    public abstract boolean isWriteAccess();

    public abstract boolean isFunctionAccess();

    public abstract boolean isCallAccess();

    public boolean isMaster() {
        return true;
    }

    public boolean isSlave() {
        return false;
    }

    public RElementAccess getMaster() {
        return this;
    }

    public abstract RAstNode getNode();

    public abstract @Nullable RAstNode getNameNode();

    @Override
    public abstract @Nullable RElementAccess getNextSegment();

    @Override
    public RElementAccess getLastSegment() {
        RElementAccess lastSegment;
        RElementAccess nextSegment = this;
        do {
            lastSegment = nextSegment;
        } while ((nextSegment = nextSegment.getNextSegment()) != null);
        return lastSegment;
    }

    public abstract ImList<? extends RElementAccess> getAllInUnit(boolean var1);
}

