/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.breakpoints;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.statet.ecommons.resources.core.util.MarkerUpdate;
import org.eclipse.statet.internal.r.debug.core.breakpoints.BasicRBreakpoint;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.r.debug.core.breakpoints.RLineBreakpoint;

@NonNullByDefault
public abstract class GenericLineBreakpoint
extends BasicRBreakpoint
implements RLineBreakpoint {
    public static final String ELEMENT_TYPE_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementTypeAttribute";
    public static final String ELEMENT_ID_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementIdAttribute";
    public static final String ELEMENT_LABEL_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ElementLabelAttribute";
    public static final String SUB_LABEL_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.SubLabelAttribute";
    public static final String CONDITION_ENABLED_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ConditionEnabledAttribute";
    public static final String CONDITION_EXPR_MARKER_ATTR = "org.eclipse.statet.r.resourceMarkers.ConditionExprAttribute";
    private final AtomicReference<@Nullable CachedData> cachedData = new AtomicReference();

    public static void updatePosition(MarkerUpdate markerUpdate, int lineNumber, int charStart, int charEnd) throws CoreException {
        IMarker marker = markerUpdate.getMarker();
        if (lineNumber != marker.getAttribute("lineNumber", -1) || charStart != marker.getAttribute("charStart", -1) || charEnd != marker.getAttribute("charEnd", -1)) {
            markerUpdate.setAttribute("lineNumber", lineNumber);
            markerUpdate.setAttribute("charStart", charStart);
            markerUpdate.setAttribute("charEnd", charEnd);
        }
    }

    public static void updateElementInfo(MarkerUpdate markerUpdate, int elementType, String elementId, String elementLabel, String subLabel) throws CoreException {
        IMarker marker = markerUpdate.getMarker();
        if (elementType != marker.getAttribute(ELEMENT_TYPE_MARKER_ATTR, -1) || !Objects.equals(elementId, marker.getAttribute(ELEMENT_ID_MARKER_ATTR, null)) || !Objects.equals(elementLabel, marker.getAttribute(ELEMENT_LABEL_MARKER_ATTR, null))) {
            markerUpdate.setAttribute(ELEMENT_TYPE_MARKER_ATTR, elementType);
            markerUpdate.setAttribute(ELEMENT_ID_MARKER_ATTR, (Object)elementId);
            markerUpdate.setAttribute(ELEMENT_LABEL_MARKER_ATTR, (Object)elementLabel);
        }
        if (!Objects.equals(subLabel, marker.getAttribute(SUB_LABEL_MARKER_ATTR, null))) {
            markerUpdate.setAttribute(SUB_LABEL_MARKER_ATTR, (Object)subLabel);
        }
    }

    protected GenericLineBreakpoint() {
    }

    protected void addStandardLineBreakpointAttributes(Map<String, Object> attributes, boolean enabled, int lineNumber, int charStart, int charEnd, int elementType, String elementId, String elementLabel, String subLabel) {
        attributes.put("org.eclipse.debug.core.id", this.getModelIdentifier());
        attributes.put("org.eclipse.debug.core.enabled", enabled);
        attributes.put("lineNumber", lineNumber);
        attributes.put("charStart", charStart);
        attributes.put("charEnd", charEnd);
        attributes.put(ELEMENT_TYPE_MARKER_ATTR, elementType);
        if (elementId != null) {
            attributes.put(ELEMENT_ID_MARKER_ATTR, elementId);
        }
        if (elementLabel != null) {
            attributes.put(ELEMENT_LABEL_MARKER_ATTR, elementLabel);
        }
        if (subLabel != null) {
            attributes.put(SUB_LABEL_MARKER_ATTR, elementLabel);
        }
    }

    public int getLineNumber() throws CoreException {
        return this.ensureMarker().getAttribute("lineNumber", -1);
    }

    public int getCharStart() throws CoreException {
        return this.ensureMarker().getAttribute("charStart", -1);
    }

    public int getCharEnd() throws CoreException {
        return this.ensureMarker().getAttribute("charEnd", -1);
    }

    @Override
    public int getElementType() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_TYPE_MARKER_ATTR, -1);
    }

    public String getElementId() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_ID_MARKER_ATTR, null);
    }

    @Override
    public String getElementLabel() throws CoreException {
        return this.ensureMarker().getAttribute(ELEMENT_LABEL_MARKER_ATTR, null);
    }

    @Override
    public @Nullable String getSubLabel() throws CoreException {
        return this.ensureMarker().getAttribute(SUB_LABEL_MARKER_ATTR, null);
    }

    @Override
    public void setConditionEnabled(boolean enabled) throws CoreException {
        this.ensureMarker().setAttribute(CONDITION_ENABLED_MARKER_ATTR, enabled);
    }

    @Override
    public boolean isConditionEnabled() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_ENABLED_MARKER_ATTR, false);
    }

    @Override
    public void setConditionExpr(@Nullable String code) throws CoreException {
        IMarker marker = this.ensureMarker();
        if (code != null && code.trim().length() > 0) {
            marker.setAttribute(CONDITION_EXPR_MARKER_ATTR, (Object)code);
        } else if (marker.getAttribute(CONDITION_EXPR_MARKER_ATTR, null) != null) {
            Object[] objectArray = new Object[2];
            objectArray[0] = false;
            marker.setAttributes(new String[]{CONDITION_ENABLED_MARKER_ATTR, CONDITION_EXPR_MARKER_ATTR}, objectArray);
        }
    }

    @Override
    public String getConditionExpr() throws CoreException {
        return this.ensureMarker().getAttribute(CONDITION_EXPR_MARKER_ATTR, "");
    }

    public void setCachedData(CachedData data) {
        if (this.checkTimestamp(data)) {
            this.cachedData.set(data);
        }
    }

    public @Nullable CachedData getCachedData() {
        CachedData cachedData = this.cachedData.get();
        if (cachedData != null && !this.checkTimestamp(cachedData)) {
            this.cachedData.compareAndSet(cachedData, null);
        }
        return cachedData;
    }

    private boolean checkTimestamp(CachedData data) {
        IResource resource;
        IMarker marker = this.getMarker();
        if (marker != null && (resource = marker.getResource()) != null) {
            return data.getStamp() == resource.getModificationStamp();
        }
        return false;
    }

    public static class CachedData {
        private final long stamp;
        private final String elementId;
        private final int[] rExpressionIndex;

        public CachedData(long stamp, String elementId, int[] rExpressionIndex) {
            this.stamp = stamp;
            this.elementId = elementId;
            this.rExpressionIndex = rExpressionIndex;
        }

        public long getStamp() {
            return this.stamp;
        }

        public String getElementId() {
            return this.elementId;
        }

        public int[] getRExpressionIndex() {
            return this.rExpressionIndex;
        }
    }
}

