/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ecommons.debug.ui.config.actions;

import java.util.Map;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.statet.ecommons.debug.ui.config.LaunchConfigManager;
import org.eclipse.statet.ecommons.debug.ui.config.actions.ActionUtil;
import org.eclipse.statet.ecommons.ui.actions.AbstractScopeHandler;
import org.eclipse.statet.ecommons.ui.util.MessageUtils;
import org.eclipse.statet.jcommons.collections.IdentityCollection;
import org.eclipse.statet.jcommons.collections.ImIdentitySet;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;

@NonNullByDefault
public class RunActiveConfigScopeHandler<TElement>
extends AbstractScopeHandler
implements IElementUpdater,
LaunchConfigManager.Listener {
    protected static final byte UNCHANGED = 0;
    protected static final byte CHANGED_NULL = 1;
    protected static final byte CHANGED_OK = 2;
    private final ActionUtil<TElement> util;
    private final ImIdentitySet<String> launchFlags;
    private @Nullable LaunchConfigManager<TElement> manager;
    private @Nullable String tooltip;

    public RunActiveConfigScopeHandler(IWorkbenchWindow scope, @Nullable String commandId, ActionUtil<TElement> util, ImIdentitySet<String> launchFlags) {
        super((Object)scope, commandId);
        this.util = util;
        this.launchFlags = launchFlags;
    }

    public void dispose() {
        this.updateManager((LaunchConfigManager<TElement>)null);
    }

    protected IWorkbenchWindow getWorkbenchWindow() {
        return (IWorkbenchWindow)ObjectUtils.nonNullAssert((Object)super.getWorkbenchWindow());
    }

    protected ActionUtil<TElement> getUtil() {
        return this.util;
    }

    protected ImIdentitySet<String> getLaunchFlags() {
        return this.launchFlags;
    }

    protected synchronized byte updateManager(@Nullable LaunchConfigManager<TElement> manager) {
        if (manager == this.manager) {
            return 0;
        }
        if (this.manager != null) {
            this.manager.removeListener(this);
        }
        this.manager = manager;
        if (manager != null) {
            manager.addListener(this);
            this.updateInfo(manager, manager.getActiveConfig());
        } else {
            this.updateInfo(null, null);
        }
        return manager != null ? (byte)2 : 1;
    }

    private void updateInfo(@Nullable LaunchConfigManager<TElement> manager, @Nullable ILaunchConfiguration config) {
        this.tooltip = manager != null && config != null ? MessageUtils.escapeForTooltip((CharSequence)manager.getLabel(config, (IdentityCollection<String>)this.launchFlags, true)) : null;
    }

    @Override
    public void availableConfigChanged(ImList<ILaunchConfiguration> configs) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void activeConfigChanged(ILaunchConfiguration config) {
        RunActiveConfigScopeHandler runActiveConfigScopeHandler = this;
        synchronized (runActiveConfigScopeHandler) {
            this.updateInfo(this.manager, config);
        }
        this.refreshCommandElements();
    }

    protected synchronized byte updateManager(IEvaluationContext context) {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        @Nullable TElement element = this.util.getLaunchElement(window);
        LaunchConfigManager<TElement> manager = null;
        if (element != null) {
            manager = this.util.getManager(window, element);
        }
        return this.updateManager(manager);
    }

    public void setEnabled(IEvaluationContext context) {
        byte changed = this.updateManager(context);
        if (changed != 0) {
            this.setBaseEnabled(changed > 1);
            this.refreshCommandElements();
        }
    }

    public void updateCommandElement(UIElement element, Map<String, ?> parameters) {
        element.setTooltip(this.tooltip);
    }

    protected @Nullable Object execute(ExecutionEvent event, IEvaluationContext context) throws ExecutionException {
        IWorkbenchWindow window = this.getWorkbenchWindow();
        @Nullable TElement element = this.util.getLaunchElement(window);
        if (element == null) {
            return null;
        }
        LaunchConfigManager<TElement> manager = this.manager;
        if (manager == null) {
            return null;
        }
        this.util.launchActive(window, manager, element, this.getLaunchFlags());
        return null;
    }
}

