/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.srvext.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.login.FailedLoginException;
import javax.security.auth.login.LoginException;
import org.eclipse.statet.rj.RjException;
import org.eclipse.statet.rj.server.srvext.ServerAuthMethod;
import org.eclipse.statet.rj.server.util.ServerUtils;

public class SimpleNamePassAuthMethod
extends ServerAuthMethod {
    private Properties users;
    private byte[] digestSash;
    private MessageDigest digestService;
    private Charset digestCharset;

    public SimpleNamePassAuthMethod() {
        super("name-pass", true);
    }

    @Override
    public void doInit(String arg) throws RjException {
        ServerUtils.ArgKeyValue config = ServerUtils.getArgConfigValue(arg);
        try {
            this.digestSash = new byte[8];
            SecureRandom random = SecureRandom.getInstance("SHA1PRNG");
            random.nextBytes(this.digestSash);
            this.digestService = MessageDigest.getInstance("SHA-512");
            this.digestCharset = Charset.forName("UTF-8");
        }
        catch (Exception e) {
            throw new RjException("", e);
        }
        if (config.getKey().equals("file")) {
            String fileName = config.getValue();
            if (fileName == null || fileName.length() == 0) {
                throw new RjException("Missing password file name.", null);
            }
            File file = new File(fileName);
            this.users = new Properties();
            try {
                this.users.load(new FileInputStream(file));
            }
            catch (IOException e) {
                throw new RjException("Reading password file failed.", null);
            }
        } else {
            throw new RjException(String.format("Unsupported configuration type '%1$s'.", config.getKey()));
        }
        this.digestService.update(this.digestSash);
        Set<Map.Entry<Object, Object>> entrySet = this.users.entrySet();
        for (Map.Entry<Object, Object> entry : entrySet) {
            byte[] password = this.digestService.digest(this.digestCharset.encode((String)entry.getValue()).array());
            entry.setValue(password);
        }
        System.gc();
    }

    @Override
    protected Callback[] doCreateLogin() throws RjException {
        return new Callback[]{new NameCallback("Loginname"), new PasswordCallback("Password", false)};
    }

    @Override
    protected String doPerformLogin(Callback[] callbacks) throws LoginException, RjException {
        byte[] loginPassword;
        String loginName = ((NameCallback)callbacks[0]).getName();
        Object object = this.users.get(loginName);
        if (object instanceof byte[] && Arrays.equals((byte[])object, loginPassword = this.getPass((PasswordCallback)callbacks[1]))) {
            return loginName;
        }
        throw new FailedLoginException("Invalid loginname or password");
    }

    private byte[] getPass(PasswordCallback callback) {
        char[] loginPassword = callback.getPassword();
        if (loginPassword == null) {
            return new byte[0];
        }
        this.digestService.update(this.digestSash);
        byte[] loginBytes = this.digestService.digest(this.digestCharset.encode(CharBuffer.wrap(loginPassword)).array());
        callback.clearPassword();
        Arrays.fill(loginPassword, '\u0000');
        return loginBytes;
    }
}

