/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.rj.server.rh;

import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Set;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.rj.server.rh.Handle;
import org.eclipse.statet.rj.server.rh.RhEngine;
import org.eclipse.statet.rj.server.rh.RhRefListener;
import org.eclipse.statet.rj.server.rh.RhWeakRef;

@NonNullByDefault
public final class RhEnv {
    private static final Object NO_DATA = new Object();
    public final Handle handle;
    private boolean isDisposed;
    private final RhEngine engine;
    private final @Nullable RhRefListener refListener;
    private int strongCounter;
    private int weakCounter;
    private @Nullable RhWeakRef weakRef;
    private final IdentityHashMap<String, @Nullable Object> regKeys = new IdentityHashMap(4);

    public RhEnv(RhEngine engine, Handle handle, @Nullable RhRefListener refListener) {
        this.engine = engine;
        this.handle = handle;
        this.refListener = refListener;
    }

    public boolean isRegAny() {
        return this.regKeys.size() > 0;
    }

    public boolean isReg(String key) {
        return this.regKeys.containsKey(key);
    }

    public boolean isRegAny(Collection<String> keys) {
        Set<String> keySet = this.regKeys.keySet();
        for (String key : keys) {
            if (!keySet.contains(key)) continue;
            return true;
        }
        return false;
    }

    public boolean addReg(String key) {
        if (!this.regKeys.containsKey(key)) {
            this.regKeys.put(key, NO_DATA);
            if (!this.isDisposed) {
                switch (key.charAt(1)) {
                    case 's': {
                        this.preserveStrong();
                        break;
                    }
                    case 'w': {
                        this.preserveWeak();
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public boolean addReg(String key, Object data) {
        if (this.regKeys.put(key, data) == null) {
            if (!this.isDisposed) {
                switch (key.charAt(1)) {
                    case 's': {
                        this.preserveStrong();
                        break;
                    }
                    case 'w': {
                        this.preserveWeak();
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public @Nullable Object getData(String key) {
        Object object = this.regKeys.get(key);
        return object != NO_DATA ? object : null;
    }

    public boolean removeReg(String key) {
        if (this.regKeys.remove(key) != null) {
            if (!this.isDisposed) {
                switch (key.charAt(1)) {
                    case 's': {
                        this.releaseStrong();
                        break;
                    }
                    case 'w': {
                        this.releaseWeak();
                        break;
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void checkWeakRef() {
        if (this.weakCounter > 0 && this.strongCounter == 0 && this.weakRef == null) {
            this.weakRef = this.engine.newWeakRef(this.handle, this.refListener != null ? this.refListener : ref -> this.dispose());
        }
    }

    private void preserveStrong() {
        if (this.strongCounter++ == 0) {
            this.engine.preserve(this.handle);
        }
    }

    private void releaseStrong() {
        if (--this.strongCounter == 0) {
            this.checkWeakRef();
            this.engine.releasePreserved(this.handle);
        }
    }

    private void preserveWeak() {
        if (this.weakCounter++ == 0) {
            this.checkWeakRef();
        }
    }

    private void releaseWeak() {
        --this.weakCounter;
    }

    public boolean isDisposed() {
        return this.isDisposed;
    }

    protected void dispose() {
        if (this.isDisposed) {
            return;
        }
        this.isDisposed = true;
        if (this.weakRef != null) {
            this.weakRef.dispose(this.engine);
        }
        if (this.strongCounter > 0) {
            this.strongCounter = 0;
            this.engine.releasePreserved(this.handle);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("env ");
        sb.append(this.handle.toString());
        sb.append(" (");
        if (this.isDisposed) {
            sb.append("disposed, ");
        }
        if (this.strongCounter > 0) {
            sb.append("r= s");
        } else if (this.weakRef != null) {
            sb.append("r= w");
        } else {
            sb.append("r= 0");
        }
        sb.append(')');
        return sb.toString();
    }
}

