/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.templates;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.GlobalTemplateVariables;
import org.eclipse.jface.text.templates.SimpleTemplateVariableResolver;
import org.eclipse.jface.text.templates.TemplateBuffer;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariable;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.statet.internal.ltk.ui.TemplatesMessages;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.lang.ObjectUtils;
import org.eclipse.statet.ltk.core.ElementName;
import org.eclipse.statet.ltk.core.util.UserInfo;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.IWorkspaceSourceUnit;
import org.eclipse.statet.ltk.ui.templates.IWorkbenchTemplateContext;
import org.eclipse.statet.ltk.ui.templates.TemplateUtils;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

@NonNullByDefault
public class SourceEditorContextType
extends TemplateContextType {
    public static final String FILE_NAME_VAR_NAME = "file_name";
    public static final String SELECT_START_VAR_NAME = "selection_begin";
    public static final String SELECT_END_VAR_NAME = "selection_end";

    public SourceEditorContextType(String id, String name) {
        super(id, name);
    }

    public SourceEditorContextType(String id) {
        super(id);
    }

    public SourceEditorContextType() {
    }

    protected void addCommonVariables() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Dollar());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Date());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Year());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Time());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.User());
        this.addResolver((TemplateVariableResolver)new AuthorName());
        this.addResolver((TemplateVariableResolver)new AuthorEmail());
        this.addResolver((TemplateVariableResolver)new Project());
    }

    protected void addEditorVariables() {
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.Cursor());
        this.addResolver((TemplateVariableResolver)new GlobalTemplateVariables.WordSelection());
        this.addResolver((TemplateVariableResolver)new MyLineSelection());
    }

    protected void addSourceUnitGenerationVariables() {
        this.addResolver((TemplateVariableResolver)new File());
        this.addResolver(new InitialSelectionStart());
        this.addResolver(new InitialSelectionEnd());
    }

    public void resolve(TemplateBuffer buffer, TemplateContext context) throws MalformedTreeException, BadLocationException {
        ObjectUtils.nonNullAssert((Object)context);
        TemplateVariable[] variables = buffer.getVariables();
        Document document = new Document(buffer.getString());
        List<TextEdit> positions = TemplateUtils.variablesToPositions(variables);
        ArrayList<ReplaceEdit> edits = new ArrayList<ReplaceEdit>(5);
        int i = 0;
        while (i != variables.length) {
            TemplateVariable variable = variables[i];
            if (!variable.isUnambiguous()) {
                boolean multiLine;
                int[] oldOffsets = variable.getOffsets();
                int oldLength = variable.getLength();
                String oldValue = variable.getDefaultValue();
                String type = variable.getType();
                TemplateVariableResolver resolver = this.getResolver(type);
                if (resolver == null) {
                    resolver = new TemplateVariableResolver();
                    resolver.setType(type);
                }
                resolver.resolve(variable, context);
                String value = variable.getDefaultValue();
                String[] ln = document.getLegalLineDelimiters();
                boolean bl = multiLine = TextUtilities.indexOf((String[])ln, (String)value, (int)0)[0] != -1;
                if (!oldValue.equals(value)) {
                    int k = 0;
                    while (k != oldOffsets.length) {
                        String indent;
                        String thisValue = value;
                        if (multiLine && (indent = TemplateUtils.searchIndentation((IDocument)document, oldOffsets[k])).length() > 0) {
                            int[] search;
                            StringBuilder temp = new StringBuilder(thisValue);
                            int offset = 0;
                            while ((search = TextUtilities.indexOf((String[])ln, (String)temp.toString(), (int)offset))[0] != -1) {
                                offset = search[0] + ln[search[1]].length();
                                temp.insert(offset, indent);
                                offset += indent.length();
                            }
                            thisValue = temp.toString();
                        }
                        edits.add(new ReplaceEdit(oldOffsets[k], oldLength, thisValue));
                        ++k;
                    }
                }
            }
            ++i;
        }
        MultiTextEdit edit = new MultiTextEdit(0, document.getLength());
        edit.addChildren(positions.toArray(new TextEdit[positions.size()]));
        edit.addChildren(edits.toArray(new TextEdit[edits.size()]));
        edit.apply((IDocument)document, 2);
        TemplateUtils.positionsToVariables(positions, variables);
        buffer.setContent(document.get(), variables);
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof SourceEditorContextType) {
            SourceEditorContextType other = (SourceEditorContextType)((Object)obj);
            return this.getId().equals(other.getId());
        }
        return false;
    }

    public static class AuthorEmail
    extends SimpleTemplateVariableResolver {
        public AuthorEmail() {
            super("author_email", TemplatesMessages.Templates_Variable_AuthorEmail_description);
        }

        protected String resolve(TemplateContext context) {
            return UserInfo.getAuthorInfo().getEmail();
        }
    }

    public static class AuthorName
    extends SimpleTemplateVariableResolver {
        public AuthorName() {
            super("author_name", TemplatesMessages.Templates_Variable_AuthorName_description);
        }

        protected String resolve(TemplateContext context) {
            return UserInfo.getAuthorInfo().getName();
        }
    }

    protected static class CodeTemplatesVariableResolver
    extends TemplateVariableResolver {
        public CodeTemplatesVariableResolver(String type, String description) {
            super(type, description);
        }

        protected @Nullable String resolve(TemplateContext context) {
            return context.getVariable(this.getType());
        }
    }

    protected static class File
    extends SimpleTemplateVariableResolver {
        public File() {
            super(SourceEditorContextType.FILE_NAME_VAR_NAME, TemplatesMessages.Templates_Variable_File_description);
        }

        protected String resolve(TemplateContext context) {
            ElementName elementName;
            ISourceUnit su;
            if (context instanceof IWorkbenchTemplateContext && (su = ((IWorkbenchTemplateContext)context).getSourceUnit()) != null && (elementName = su.getElementName()) != null) {
                return elementName.getSegmentName();
            }
            return "";
        }
    }

    protected static class InitialSelectionEnd
    extends TemplateVariableResolver {
        public InitialSelectionEnd() {
            super(SourceEditorContextType.SELECT_END_VAR_NAME, TemplatesMessages.Templates_Variable_SelectionEnd_description);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            variable.setValue("");
            variable.setUnambiguous(true);
        }
    }

    protected static class InitialSelectionStart
    extends TemplateVariableResolver {
        public InitialSelectionStart() {
            super(SourceEditorContextType.SELECT_START_VAR_NAME, TemplatesMessages.Templates_Variable_SelectionBegin_description);
        }

        public void resolve(TemplateVariable variable, TemplateContext context) {
            variable.setValue("");
            variable.setUnambiguous(true);
        }
    }

    private static class MyLineSelection
    extends GlobalTemplateVariables.LineSelection {
        private MyLineSelection() {
        }

        protected String resolve(TemplateContext context) {
            char c;
            String value = super.resolve(context);
            int length = value.length();
            if (length > 0 && context instanceof DocumentTemplateContext && (c = value.charAt(length - 1)) != '\n' && c != '\r') {
                value = String.valueOf(value) + TextUtilities.getDefaultLineDelimiter((IDocument)((DocumentTemplateContext)context).getDocument());
            }
            return value;
        }
    }

    protected static class Project
    extends SimpleTemplateVariableResolver {
        public Project() {
            super("enclosing_project", TemplatesMessages.Templates_Variable_EnclosingProject_description);
        }

        protected String resolve(TemplateContext context) {
            ISourceUnit su;
            if (context instanceof IWorkbenchTemplateContext && (su = ((IWorkbenchTemplateContext)context).getSourceUnit()) instanceof IWorkspaceSourceUnit) {
                return ((IWorkspaceSourceUnit)su).getResource().getProject().getName();
            }
            return "";
        }
    }

    protected static class Todo
    extends SimpleTemplateVariableResolver {
        public Todo() {
            super("todo", TemplatesMessages.Templates_Variable_ToDo_description);
        }

        protected String resolve(TemplateContext context) {
            String tag;
            if (context instanceof IWorkbenchTemplateContext && (tag = this.getTag(((IWorkbenchTemplateContext)context).getSourceUnit())) != null) {
                return tag;
            }
            return "TODO";
        }

        protected @Nullable String getTag(@Nullable ISourceUnit su) {
            return null;
        }
    }
}

