/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.text.AbstractDocument;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.text.core.PartitionConstraint;
import org.eclipse.statet.ltk.ast.core.util.AstSelection;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.ISelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAddon;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.IDocumentProvider;

public abstract class AbstractMarkOccurrencesProvider
implements ISourceEditorAddon,
ISelectionWithElementInfoListener {
    private static final int CLEAR = -1;
    private static final int KEEP = 1;
    private static final int UPDATE = 2;
    private final SourceEditor1 editor;
    private final String partitioning;
    private final PartitionConstraint toleratePartitions;
    private boolean isMarkEnabled;
    private RunData lastRun;

    public AbstractMarkOccurrencesProvider(SourceEditor1 editor, PartitionConstraint toleratePartitions) {
        if (editor == null) {
            throw new NullPointerException("editor");
        }
        if (toleratePartitions == null) {
            throw new NullPointerException("validPartitions");
        }
        this.editor = editor;
        this.partitioning = this.editor.getDocumentContentInfo().getPartitioning();
        this.toleratePartitions = toleratePartitions;
    }

    @Override
    public void install(ISourceEditor editor) {
        this.isMarkEnabled = true;
        this.editor.addPostSelectionWithElementInfoListener(this);
    }

    @Override
    public void uninstall() {
        this.isMarkEnabled = false;
        this.editor.removePostSelectionWithElementInfoListener(this);
        this.removeAnnotations();
    }

    @Override
    public void inputChanged() {
        this.lastRun = null;
    }

    @Override
    public void stateChanged(LTKInputData state) {
        ISelection selection = state.getSelection();
        boolean ok = this.update((ISourceUnit)state.getInputElement(), state.getAstSelection(), selection instanceof ITextSelection ? (ITextSelection)selection : null);
        if (!ok && state.isStillValid()) {
            this.removeAnnotations();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean update(ISourceUnit inputElement, AstSelection astSelection, ITextSelection orgSelection) {
        if (!this.isMarkEnabled) {
            return false;
        }
        try {
            ISourceUnitModelInfo info = inputElement.getModelInfo(this.editor.getModelTypeId(), 0, (IProgressMonitor)new NullProgressMonitor());
            if (this.editor.getSourceUnit() != inputElement) return false;
            if (info == null) return false;
            if (astSelection == null) {
                return false;
            }
            RunData run = new RunData(inputElement.getDocument(null), info.getStamp());
            if (run.doc == null) {
                return false;
            }
            if (this.lastRun != null && this.lastRun.isValid() && this.lastRun.stamp.equals(run.stamp)) {
                return true;
            }
            this.doUpdate(run, info, astSelection, orgSelection);
            if (!this.isMarkEnabled) {
                return false;
            }
            if (run.set == 0) {
                this.checkKeep(run, orgSelection);
            }
            switch (run.set) {
                case 1: {
                    return true;
                }
                case 2: {
                    this.updateAnnotations(run);
                    return true;
                }
            }
            this.removeAnnotations();
            return true;
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
        catch (BadPartitioningException badPartitioningException) {
            return false;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return false;
    }

    protected abstract void doUpdate(RunData var1, ISourceUnitModelInfo var2, AstSelection var3, ITextSelection var4) throws BadLocationException, BadPartitioningException, UnsupportedOperationException;

    protected void checkKeep(RunData run, ITextSelection selection) throws BadLocationException, BadPartitioningException {
        if (this.lastRun == null || !this.lastRun.stamp.equals(run.stamp)) {
            run.clear();
            return;
        }
        if (selection instanceof ITextSelection) {
            ITextSelection textSelection = selection;
            Point currentSelection = this.editor.currentSelection;
            int offset = textSelection.getOffset();
            int docLength = run.doc.getLength();
            ITypedRegion partition = run.doc.getPartition(this.partitioning, offset, false);
            if (!(docLength <= 0 || currentSelection.y <= 0 && offset == currentSelection.x && (textSelection.getLength() != 0 || partition == null || !this.toleratePartitions.matches(partition.getType()) || offset > 0 && Character.isLetterOrDigit(run.doc.getChar(offset - 1)) || offset < docLength && !Character.isWhitespace(run.doc.getChar(offset))))) {
                run.keep();
                return;
            }
        }
    }

    protected IAnnotationModel getAnnotationModel() {
        IDocumentProvider documentProvider = this.editor.getDocumentProvider();
        if (documentProvider == null) {
            throw new UnsupportedOperationException();
        }
        IAnnotationModel annotationModel = documentProvider.getAnnotationModel((Object)this.editor.getEditorInput());
        if (annotationModel == null || !(annotationModel instanceof IAnnotationModelExtension)) {
            throw new UnsupportedOperationException();
        }
        return annotationModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateAnnotations(RunData run) throws BadLocationException {
        if (!run.isValid()) {
            return;
        }
        IAnnotationModel annotationModel = this.getAnnotationModel();
        Annotation[] lastAnnotations = this.lastRun != null ? this.lastRun.annotations : null;
        Object object = SourceEditor1.getLockObject(annotationModel);
        synchronized (object) {
            if (!run.isValid()) {
                return;
            }
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(lastAnnotations, run.todo);
            run.annotations = run.todo.keySet().toArray(new Annotation[run.todo.keySet().size()]);
            run.todo = null;
            this.lastRun = run;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAnnotations() {
        IAnnotationModel annotationModel = this.getAnnotationModel();
        Object object = SourceEditor1.getLockObject(annotationModel);
        synchronized (object) {
            if (this.lastRun == null) {
                return;
            }
            ((IAnnotationModelExtension)annotationModel).replaceAnnotations(this.lastRun.annotations, null);
            this.lastRun = null;
        }
    }

    public final class RunData {
        public final AbstractDocument doc;
        public ISourceModelStamp stamp;
        private Annotation[] annotations;
        private Point range;
        private int set = 0;
        private Map<Annotation, Position> todo;

        RunData(AbstractDocument doc, ISourceModelStamp stamp) {
            this.doc = doc;
            this.stamp = stamp;
        }

        public boolean isValid() {
            Point currentSelection = ((AbstractMarkOccurrencesProvider)AbstractMarkOccurrencesProvider.this).editor.currentSelection;
            return this.range != null && currentSelection.x >= this.range.x && currentSelection.x + currentSelection.y <= this.range.y && this.doc.getModificationStamp() == this.stamp.getSourceStamp();
        }

        public boolean accept(Point range) {
            this.range = range;
            if (this.isValid()) {
                return true;
            }
            this.range = null;
            return false;
        }

        public void set(Map<Annotation, Position> annotations) {
            this.set = 2;
            this.todo = annotations;
        }

        public void keep() {
            this.set = 1;
        }

        public void clear() {
            this.set = -1;
        }
    }
}

