/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.ltk.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.statet.internal.ltk.core.ModelTypeDescriptor;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.Disposable;
import org.eclipse.statet.ltk.core.IExtContentTypeManager;

public class ExtContentTypeServices
implements IExtContentTypeManager,
Disposable {
    private static final String CONFIG_CONTENTTYPEACTIVATION_EXTENSIONPOINT_ID = "org.eclipse.statet.ltk.ContentTypeActivation";
    private static final String CONFIG_CONTENTTYPE_ELEMENT_NAME = "contentType";
    private static final String CONFIG_ID_ATTRIBUTE_NAME = "id";
    private static final String CONFIG_CONTENTTYPE_ID_ATTRIBUTE_NAME = "contentTypeId";
    private static final String CONFIG_SECONDARY_ID_ATTRIBUTE_NAME = "secondaryId";
    private static final String CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME = "modelTypeId";
    private static final String[] NO_TYPES = new String[0];
    private Map<String, String[]> primaryToSecondary;
    private Map<String, String[]> secondaryToPrimary;
    private Map<String, String> primaryToModel;
    private Map<String, ModelTypeDescriptor> modelDescriptors;

    private static boolean matches(IContentType type, String typeId) {
        while (type != null) {
            if (typeId.equals(type.getId())) {
                return true;
            }
            type = type.getBaseType();
        }
        return false;
    }

    private static boolean matches(String[] ids, String typeId) {
        int i = 0;
        while (i < ids.length) {
            if (typeId.equals(ids[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static void add(Map<String, Set<String>> map, String key, String value) {
        Set<String> set = map.get(key);
        if (set == null) {
            set = new HashSet<String>();
            map.put(key, set);
        }
        set.add(value);
    }

    private static Map<String, String[]> copy(Map<String, Set<String>> from, Map<String, String[]> to) {
        for (Map.Entry<String, Set<String>> entry : from.entrySet()) {
            Set<String> set = entry.getValue();
            to.put(entry.getKey(), set.toArray(new String[set.size()]));
        }
        return to;
    }

    public ExtContentTypeServices() {
        this.load();
    }

    private void load() {
        IConfigurationElement element;
        IConfigurationElement[] elements;
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        HashMap<String, ModelTypeDescriptor> modelTypes = new HashMap<String, ModelTypeDescriptor>();
        HashMap<String, Set<String>> primaryToSecondary = new HashMap<String, Set<String>>();
        HashMap<String, Set<String>> secondaryToPrimary = new HashMap<String, Set<String>>();
        HashMap<String, String> primaryToModel = new HashMap<String, String>();
        IConfigurationElement[] iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor(CONFIG_CONTENTTYPEACTIVATION_EXTENSIONPOINT_ID);
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            element = iConfigurationElementArray[n2];
            if (element.getName().equals(CONFIG_CONTENTTYPE_ELEMENT_NAME)) {
                String primary = element.getAttribute(CONFIG_ID_ATTRIBUTE_NAME);
                String secondary = element.getAttribute(CONFIG_SECONDARY_ID_ATTRIBUTE_NAME);
                if (primary != null && secondary != null && primary.length() > 0 && secondary.length() > 0) {
                    primary = primary.intern();
                    secondary = secondary.intern();
                    ExtContentTypeServices.add(primaryToSecondary, primary, secondary);
                    ExtContentTypeServices.add(secondaryToPrimary, secondary, primary);
                }
            }
            ++n2;
        }
        iConfigurationElementArray = elements = extensionRegistry.getConfigurationElementsFor("org.eclipse.statet.ltk.ModelTypes");
        n = elements.length;
        n2 = 0;
        while (n2 < n) {
            String id;
            element = iConfigurationElementArray[n2];
            if (element.getName().equals("modelType") && (id = element.getAttribute(CONFIG_ID_ATTRIBUTE_NAME)) != null && !id.isEmpty()) {
                IConfigurationElement[] children;
                ModelTypeDescriptor descriptor = (ModelTypeDescriptor)modelTypes.get(id = id.intern());
                if (descriptor == null) {
                    descriptor = new ModelTypeDescriptor(id);
                    modelTypes.put(id, descriptor);
                }
                IConfigurationElement[] iConfigurationElementArray2 = children = element.getChildren();
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    String secondaryId;
                    IConfigurationElement child = iConfigurationElementArray2[n4];
                    if (child.getName().equals("secondaryType") && (secondaryId = child.getAttribute(CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME)) != null && !secondaryId.isEmpty() && !descriptor.secondaryTypeIds.contains(secondaryId = secondaryId.intern())) {
                        descriptor.secondaryTypeIds.add(secondaryId);
                    }
                    ++n4;
                }
            }
            if (element.getName().equals(CONFIG_CONTENTTYPE_ELEMENT_NAME)) {
                String contentTypeId = element.getAttribute(CONFIG_CONTENTTYPE_ID_ATTRIBUTE_NAME);
                String modelTypeId = element.getAttribute(CONFIG_MODELTYPE_ID_ATTRIBUTE_NAME);
                if (contentTypeId != null && !contentTypeId.isEmpty() && modelTypeId != null && !modelTypeId.isEmpty()) {
                    contentTypeId = contentTypeId.intern();
                    modelTypeId = modelTypeId.intern();
                    primaryToModel.put(contentTypeId, modelTypeId);
                }
            }
            ++n2;
        }
        ExtContentTypeServices.checkModelTypes(modelTypes);
        this.primaryToSecondary = ExtContentTypeServices.copy(primaryToSecondary, new HashMap<String, String[]>());
        this.secondaryToPrimary = ExtContentTypeServices.copy(secondaryToPrimary, new HashMap<String, String[]>());
        this.primaryToModel = primaryToModel;
        this.modelDescriptors = modelTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkModelTypes(Map<String, ModelTypeDescriptor> modelTypes) {
        ArrayList<String> temp = new ArrayList<String>();
        Iterator<ModelTypeDescriptor> iterator = modelTypes.values().iterator();
        while (iterator.hasNext()) {
            ModelTypeDescriptor descriptor;
            ModelTypeDescriptor modelTypeDescriptor = descriptor = iterator.next();
            synchronized (modelTypeDescriptor) {
                temp.clear();
                for (String sId : descriptor.secondaryTypeIds) {
                    if (!modelTypes.containsKey(sId)) continue;
                    temp.add(sId);
                }
                descriptor.checkedSecondaryTypeIds = ImCollections.toList(temp);
            }
        }
    }

    @Override
    public String[] getSecondaryContentTypes(String primaryContentType) {
        String[] types = this.primaryToSecondary.get(primaryContentType);
        return types != null ? types : NO_TYPES;
    }

    @Override
    public String[] getPrimaryContentTypes(String secondaryContentType) {
        String[] types = this.secondaryToPrimary.get(secondaryContentType);
        return types != null ? types : NO_TYPES;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public boolean matchesActivatedContentType(String primaryContentTypeId, String activatedContentTypeId, boolean self) {
        manager = Platform.getContentTypeManager();
        primary = primaryContentType = manager.getContentType(primaryContentTypeId);
        if (!self || !primary.getId().equals(activatedContentTypeId) && !ExtContentTypeServices.matches(primary, activatedContentTypeId)) ** GOTO lbl9
        return true;
lbl-1000:
        // 1 sources

        {
            types = this.getSecondaryContentTypes(primary.getId());
            if (types != null && ExtContentTypeServices.matches(types, activatedContentTypeId)) {
                return true;
            }
            primary = primary.getBaseType();
lbl9:
            // 2 sources

            ** while (primary != null)
        }
lbl10:
        // 1 sources

        return false;
    }

    @Override
    public ModelTypeDescriptor getModelType(String modelTypeId) {
        return modelTypeId != null ? this.modelDescriptors.get(modelTypeId) : null;
    }

    @Override
    public ModelTypeDescriptor getModelTypeForContentType(String contentTypeId) {
        return this.getModelType(this.primaryToModel.get(contentTypeId));
    }

    public void dispose() {
    }
}

