/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.core.model;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.statet.docmlet.wikitext.core.ast.Embedded;
import org.eclipse.statet.docmlet.wikitext.core.markup.WikitextMarkupLanguage;
import org.eclipse.statet.docmlet.wikitext.core.model.EmbeddingReconcileItem;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocModelInfo;
import org.eclipse.statet.docmlet.wikitext.core.model.IWikidocSuModelContainerEmbeddedExtension;
import org.eclipse.statet.ltk.ast.core.AstNode;
import org.eclipse.statet.ltk.ast.core.EmbeddingAstNode;
import org.eclipse.statet.ltk.core.SourceContent;
import org.eclipse.statet.ltk.issues.core.ProblemRequestor;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.yaml.core.ast.SourceComponent;
import org.eclipse.statet.yaml.core.ast.YamlAstNode;
import org.eclipse.statet.yaml.core.ast.YamlParser;
import org.eclipse.statet.yaml.core.model.IYamlModelInfo;
import org.eclipse.statet.yaml.core.model.YamlChunkElement;
import org.eclipse.statet.yaml.core.model.YamlElementName;
import org.eclipse.statet.yaml.core.model.YamlModel;
import org.eclipse.statet.yaml.core.model.YamlProblemReporter;

public class YamlReconcilerExtension
implements IWikidocSuModelContainerEmbeddedExtension {
    private static final YamlElementName METADATA_ELEMENT_NAME = YamlElementName.create((int)15, (String)"Metadata (YAML)");
    private final YamlParser parser = new YamlParser();
    private final YamlProblemReporter problemReporter = new YamlProblemReporter();

    @Override
    public void reconcileEmbeddedAst(SourceContent content, List<Embedded> list, WikitextMarkupLanguage markupLanguage, int level, IProgressMonitor monitor) {
        for (EmbeddingAstNode embeddingAstNode : list) {
            if (embeddingAstNode.getForeignTypeId() != "Yaml") continue;
            String text = content.getText();
            int offset = embeddingAstNode.getStartOffset();
            while (offset < text.length() && Character.isWhitespace(text.charAt(offset))) {
                ++offset;
            }
            SourceComponent component = this.parser.parse(text.substring(offset, embeddingAstNode.getEndOffset()), (AstNode)embeddingAstNode, offset);
            embeddingAstNode.setForeignNode((AstNode)component);
        }
    }

    @Override
    public void reconcileEmbeddedModel(SourceContent content, IWikidocModelInfo wikitextModel, List<EmbeddingReconcileItem> list, int level, IProgressMonitor monitor) {
        ISourceStructElement sourceElement = wikitextModel.getSourceElement();
        int metadataCount = 0;
        ArrayList<YamlChunkElement> chunkElements = new ArrayList<YamlChunkElement>();
        for (EmbeddingReconcileItem item : list) {
            if (item.getForeignTypeId() != "Yaml") continue;
            YamlChunkElement element = new YamlChunkElement((ISourceStructElement)item.getModelRefElement(), (YamlAstNode)item.getAstNode().getForeignNode(), METADATA_ELEMENT_NAME, metadataCount++);
            item.setModelTypeElement((ISourceStructElement)element);
            chunkElements.add(element);
        }
        if (metadataCount == 0) {
            return;
        }
        IYamlModelInfo modelInfo = YamlModel.getYamlModelManager().reconcile(sourceElement.getSourceUnit(), (ISourceUnitModelInfo)wikitextModel, chunkElements, level, monitor);
        if (modelInfo != null) {
            wikitextModel.addAttachment(modelInfo);
        }
    }

    @Override
    public void reportEmbeddedProblems(SourceContent content, IWikidocModelInfo wikitextModel, ProblemRequestor problemRequestor, int level, IProgressMonitor monitor) {
        IYamlModelInfo yamlModel = YamlModel.getYamlModelInfo((ISourceUnitModelInfo)wikitextModel);
        if (yamlModel == null) {
            return;
        }
        this.problemReporter.run(yamlModel, content, problemRequestor, level, monitor);
    }
}

