/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.blocks;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.parser.Attributes;
import org.eclipse.mylyn.wikitext.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.parser.HeadingAttributes;
import org.eclipse.statet.docmlet.wikitext.core.source.SourceHeadingAttributes;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.CommonmarkLocator;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.Line;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.LineSequence;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.ProcessingContext;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlock;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlockItem;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.SourceBlocks;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.TextSegment;
import org.eclipse.statet.internal.docmlet.wikitext.commonmark.core.inlines.InlineParser;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.collections.ImList;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;

@NonNullByDefault
public class AtxHeaderBlock
extends SourceBlock {
    private static final Pattern START_PATTERN = Pattern.compile("#{1,6}(?:[ \t].*)?", 32);
    private static final Pattern PATTERN = Pattern.compile("(#{1,6})(?:[ \t]??(.+?))??(?:\\ +#+)?\\ *", 32);
    private final Matcher startMatcher = START_PATTERN.matcher("");
    private @Nullable Matcher matcher;

    @Override
    public boolean canStart(LineSequence lineSequence, @Nullable SourceBlockItem<?> currentBlockItem) {
        Line currentLine = lineSequence.getCurrentLine();
        return currentLine != null && !currentLine.isBlank() && currentLine.getIndent() < 4 && currentLine.setupIndent(this.startMatcher).matches();
    }

    @Override
    public void createItem(SourceBlocks.SourceBlockBuilder builder, LineSequence lineSequence) {
        SourceBlockItem<AtxHeaderBlock> blockItem = new SourceBlockItem<AtxHeaderBlock>(this, builder);
        lineSequence.advance();
    }

    @Override
    public void initializeContext(ProcessingContext context, SourceBlockItem<?> blockItem) {
    }

    @Override
    public void emit(ProcessingContext context, SourceBlockItem<?> blockItem, CommonmarkLocator locator, DocumentBuilder builder) {
        Line startLine = (Line)blockItem.getLines().get(0);
        Matcher matcher = startLine.setup(this.getProcessMatcher(), true, true);
        AtxHeaderBlock.assertMatches(matcher);
        int contentOffset = matcher.start(2);
        int contentEnd = matcher.end(2);
        int headingLevel = this.headingLevel(startLine, matcher);
        if (contentEnd > contentOffset) {
            Line headerContent = startLine.segment(contentOffset, contentEnd - contentOffset);
            TextSegment textSegment = new TextSegment((ImList<Line>)ImCollections.newList((Object)headerContent));
            SourceHeadingAttributes attributes = new SourceHeadingAttributes(startLine.getLineDelimiter().isEmpty() ? 256 : 0);
            InlineParser inlineParser = context.getInlineParser();
            String headingText = inlineParser.toStringContent(context, textSegment);
            attributes.setId(context.generateHeadingId(headingLevel, headingText));
            locator.setBlockBegin(blockItem);
            builder.beginHeading(headingLevel, (Attributes)attributes);
            inlineParser.emit(context, textSegment, locator, builder);
            locator.setBlockEnd(blockItem);
            builder.endHeading();
        } else {
            locator.setBlockBegin(blockItem);
            builder.beginHeading(headingLevel, (Attributes)new HeadingAttributes());
            locator.setBlockEnd(blockItem);
            builder.endHeading();
        }
    }

    private Matcher getProcessMatcher() {
        if (this.matcher == null) {
            this.matcher = PATTERN.matcher("");
        }
        return this.matcher;
    }

    private int headingLevel(Line line, Matcher matcher) {
        return matcher.end(1) - matcher.regionStart();
    }
}

