/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.ui.rhelp;

import java.util.HashMap;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.statet.ecommons.databinding.IntegerValidator;
import org.eclipse.statet.ecommons.databinding.jface.AbstractSWTObservableValue;
import org.eclipse.statet.ecommons.databinding.jface.DataBindingSupport;
import org.eclipse.statet.ecommons.preferences.ui.ManagedConfigurationBlock;
import org.eclipse.statet.ecommons.runtime.core.StatusChangeListener;
import org.eclipse.statet.ecommons.ui.util.LayoutUtils;
import org.eclipse.statet.internal.r.ui.rhelp.RHelpPreferences;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

class RHelpConfigurationBlock
extends ManagedConfigurationBlock {
    private Button homeBlankControl;
    private Button homeREnvControl;
    private Button homeCustomControl;
    private Text homeUrlControl;
    private Button searchReusePageControl;
    private Text searchMaxFragmentsControl;

    protected RHelpConfigurationBlock(StatusChangeListener statusListener) {
        super(null, statusListener);
    }

    protected void createBlockArea(Composite pageComposite) {
        HashMap<Object, Object> prefs = new HashMap<Object, Object>();
        prefs.put(RHelpPreferences.HOMEPAGE_URL_PREF, null);
        prefs.put(RHelpPreferences.SEARCH_REUSE_PAGE_ENABLED_PREF, null);
        prefs.put(RHelpPreferences.SEARCH_PREVIEW_FRAGMENTS_MAX_PREF, null);
        this.setupPreferenceManager(prefs);
        Composite appearanceOptions = this.createAppearanceOptions(pageComposite);
        appearanceOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite homeOptions = this.createHomeOptions(pageComposite);
        homeOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        Composite searchOptions = this.createSearchOptions(pageComposite);
        searchOptions.setLayoutData((Object)new GridData(4, 4, true, false));
        this.initBindings();
        this.updateControls();
    }

    private Composite createAppearanceOptions(Composite pageComposite) {
        Group group = new Group(pageComposite, 0);
        group.setText("Appearance:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        Link control = this.addLinkControl((Composite)group, "See also settings for StatET > Documentation in <a href=\"org.eclipse.ui.preferencePages.ColorsAndFonts\">Color and Fonts</a>.");
        control.setLayoutData((Object)new GridData(4, 4, true, false));
        return group;
    }

    private Composite createHomeOptions(Composite pageComposite) {
        Group group = new Group(pageComposite, 0);
        group.setText("Home Page:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)3));
        Button button = new Button((Composite)group, 16);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("&Blank page");
        this.homeBlankControl = button;
        button = new Button((Composite)group, 16);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("Default &R environment");
        this.homeREnvControl = button;
        button = new Button((Composite)group, 16);
        button.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        button.setText("C&ustom");
        this.homeCustomControl = button;
        Text text = new Text((Composite)group, 2048);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        text.setText("");
        this.homeUrlControl = text;
        return group;
    }

    private Composite createSearchOptions(Composite pageComposite) {
        Group group = new Group(pageComposite, 0);
        group.setText("Search:");
        group.setLayout((Layout)LayoutUtils.newGroupGrid((int)2));
        this.searchReusePageControl = new Button((Composite)group, 32);
        this.searchReusePageControl.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        this.searchReusePageControl.setText("Reuse &page in R Help view to show matches.");
        Label label = new Label((Composite)group, 0);
        label.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        label.setText("Maximum preview &fragments:");
        Text text = new Text((Composite)group, 133120);
        GridData gd = new GridData(16384, 0x1000000, false, false);
        gd.widthHint = LayoutUtils.hintWidth((Text)text, (int)5);
        text.setLayoutData((Object)gd);
        this.searchMaxFragmentsControl = text;
        return group;
    }

    protected void addBindings(DataBindingSupport db) {
        db.getContext().bindValue((IObservableValue)new HomeObservable(db.getRealm()), this.createObservable(RHelpPreferences.HOMEPAGE_URL_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.selection().observe((Widget)this.searchReusePageControl), this.createObservable(RHelpPreferences.SEARCH_REUSE_PAGE_ENABLED_PREF));
        db.getContext().bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)this.searchMaxFragmentsControl), this.createObservable(RHelpPreferences.SEARCH_PREVIEW_FRAGMENTS_MAX_PREF), new UpdateValueStrategy().setAfterGetValidator((IValidator)new IntegerValidator(1, 1000, "Invalid maximum for preview fragments specified (1-1000).")), null);
    }

    class HomeObservable
    extends AbstractSWTObservableValue
    implements SelectionListener,
    ModifyListener {
        private boolean isCustom;
        private String url;
        private String lastCustom;
        private boolean isUpdating;

        public HomeObservable(Realm realm) {
            super(realm, (Widget)RHelpConfigurationBlock.this.homeUrlControl);
            this.lastCustom = "http://";
            RHelpConfigurationBlock.this.homeUrlControl.addModifyListener((ModifyListener)this);
            RHelpConfigurationBlock.this.homeBlankControl.addSelectionListener((SelectionListener)this);
            RHelpConfigurationBlock.this.homeREnvControl.addSelectionListener((SelectionListener)this);
            RHelpConfigurationBlock.this.homeCustomControl.addSelectionListener((SelectionListener)this);
        }

        public Object getValueType() {
            return String.class;
        }

        protected Object doGetValue() {
            if (!this.isUpdating) {
                this.isUpdating = true;
                try {
                    this.updateUrl();
                }
                finally {
                    this.isUpdating = false;
                }
            }
            return this.url;
        }

        protected void doSetValue(Object value) {
            this.isUpdating = true;
            this.url = (String)value;
            if (this.url == null) {
                this.url = "about:blank";
            }
            try {
                if (this.url.equals("about:blank")) {
                    RHelpConfigurationBlock.this.homeBlankControl.setSelection(true);
                    RHelpConfigurationBlock.this.homeREnvControl.setSelection(false);
                    RHelpConfigurationBlock.this.homeCustomControl.setSelection(false);
                    this.isCustom = false;
                } else if (this.url.equals("erhelp:/browse/default-workbench/")) {
                    RHelpConfigurationBlock.this.homeBlankControl.setSelection(false);
                    RHelpConfigurationBlock.this.homeREnvControl.setSelection(true);
                    RHelpConfigurationBlock.this.homeCustomControl.setSelection(false);
                    this.isCustom = false;
                } else {
                    RHelpConfigurationBlock.this.homeBlankControl.setSelection(false);
                    RHelpConfigurationBlock.this.homeREnvControl.setSelection(false);
                    RHelpConfigurationBlock.this.homeCustomControl.setSelection(true);
                    this.isCustom = true;
                    this.lastCustom = this.url;
                }
                RHelpConfigurationBlock.this.homeUrlControl.setText(this.url);
            }
            finally {
                this.isUpdating = false;
            }
        }

        private void updateUrl() {
            String oldUrl = this.url;
            if (RHelpConfigurationBlock.this.homeBlankControl.getSelection()) {
                if (this.isCustom) {
                    this.lastCustom = RHelpConfigurationBlock.this.homeUrlControl.getText();
                }
                this.isCustom = false;
                this.url = "about:blank";
            } else if (RHelpConfigurationBlock.this.homeREnvControl.getSelection()) {
                if (this.isCustom) {
                    this.lastCustom = RHelpConfigurationBlock.this.homeUrlControl.getText();
                }
                this.isCustom = false;
                this.url = "erhelp:/browse/default-workbench/";
            } else {
                this.isCustom = true;
                String string = this.url = this.lastCustom != null ? this.lastCustom : "";
            }
            if (!this.url.equals(RHelpConfigurationBlock.this.homeUrlControl.getText())) {
                RHelpConfigurationBlock.this.homeUrlControl.setText(this.url);
            }
            if (!this.url.equals(oldUrl)) {
                this.fireValueChange(Diffs.createValueDiff((Object)oldUrl, (Object)this.url));
            }
        }

        public void widgetSelected(SelectionEvent e) {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            try {
                this.updateUrl();
            }
            finally {
                this.isUpdating = false;
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void modifyText(ModifyEvent e) {
            if (this.isUpdating) {
                return;
            }
            this.isUpdating = true;
            try {
                RHelpConfigurationBlock.this.homeBlankControl.setSelection(false);
                RHelpConfigurationBlock.this.homeREnvControl.setSelection(false);
                RHelpConfigurationBlock.this.homeCustomControl.setSelection(true);
                this.lastCustom = RHelpConfigurationBlock.this.homeUrlControl.getText();
                this.updateUrl();
            }
            finally {
                this.isUpdating = false;
            }
        }
    }
}

