/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.ui.launcher;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.statet.ecommons.text.TextUtil;
import org.eclipse.statet.ecommons.ui.workbench.WorkbenchUIUtils;
import org.eclipse.statet.internal.r.debug.ui.RLaunchingMessages;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.util.LTKWorkbenchUIUtil;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IURIEditorInput;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class LaunchShortcutUtil {
    public static final String TOGGLE_ECHO_COMMAND_ID = "org.eclipse.statet.r.commands.ToggleRunEcho";

    public static String getContentTypeId(IFile file) {
        IContentType contentType = IDE.guessContentType((IFile)file);
        return contentType != null ? contentType.getId() : null;
    }

    public static String getContentTypeId(URI uri) {
        String fileName = URIUtil.lastSegment((URI)uri);
        if (fileName != null) {
            IContentType contentType = Platform.getContentTypeManager().findContentTypeFor(fileName);
            return contentType != null ? contentType.getId() : null;
        }
        return null;
    }

    /*
     * Exception decompiling
     */
    public static List<String> getCodeLines(IFile file) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [8[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static List<String> getSelectedCodeLines(ExecutionEvent event) throws CoreException {
        try {
            ISelection selection = WorkbenchUIUtils.getCurrentSelection((Object)event.getApplicationContext());
            IWorkbenchPart workbenchPart = HandlerUtil.getActivePart((ExecutionEvent)event);
            if (selection instanceof ITextSelection) {
                ITextEditor editor;
                IDocumentProvider documentProvider;
                String code;
                ITextSelection textSelection = (ITextSelection)selection;
                if (textSelection.getLength() > 0 && (code = textSelection.getText()) != null) {
                    ArrayList<String> lines = new ArrayList<String>(2 + code.length() / 30);
                    TextUtil.addLines((String)code, lines);
                    return lines;
                }
                IDocument document = null;
                if (workbenchPart instanceof ITextEditor && (documentProvider = (editor = (ITextEditor)workbenchPart).getDocumentProvider()) != null) {
                    document = documentProvider.getDocument((Object)editor.getEditorInput());
                }
                if (document == null && (editor = (ISourceEditor)workbenchPart.getAdapter(ISourceEditor.class)) != null) {
                    document = editor.getViewer().getDocument();
                }
                if (document != null) {
                    ArrayList<String> lines = new ArrayList<String>(document.getNumberOfLines(textSelection.getOffset(), textSelection.getLength()));
                    if (textSelection.getLength() > 0) {
                        TextUtil.addLines((IDocument)document, (int)textSelection.getOffset(), (int)textSelection.getLength(), lines);
                    } else {
                        int line = document.getLineOfOffset(textSelection.getOffset());
                        IRegion lineInformation = document.getLineInformation(line);
                        lines.add(document.get(lineInformation.getOffset(), lineInformation.getLength()));
                    }
                    return lines;
                }
            }
            return null;
        }
        catch (BadLocationException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.statet.r.ui", -1, RLaunchingMessages.SubmitCode_error_WhenAnalyzingAndCollecting_message, (Throwable)e));
        }
    }

    public static Object getFile(IEditorInput editorInput) {
        if (editorInput instanceof IFileEditorInput) {
            return ((IFileEditorInput)editorInput).getFile();
        }
        if (editorInput instanceof IURIEditorInput) {
            return ((IURIEditorInput)editorInput).getURI();
        }
        return null;
    }

    public static IStatus createUnsupported() {
        return new Status(4, "org.eclipse.statet.r.ui", RLaunchingMessages.SubmitCode_info_NotSupported_message);
    }

    public static void handleUnsupportedExecution(ExecutionEvent executionEvent) {
        LTKWorkbenchUIUtil.indicateStatus((IStatus)LaunchShortcutUtil.createUnsupported(), (ExecutionEvent)executionEvent);
    }

    public static void handleRLaunchException(Throwable e, String defaultMessage, ExecutionEvent executionEvent) {
        Status status = new Status(4, "org.eclipse.statet.r.ui", 0, defaultMessage, e);
        StatusManager.getManager().handle((IStatus)status);
        if (e instanceof CoreException) {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)((CoreException)e).getStatus(), (ExecutionEvent)executionEvent);
        } else {
            LTKWorkbenchUIUtil.indicateStatus((IStatus)status, (ExecutionEvent)executionEvent);
        }
    }

    private LaunchShortcutUtil() {
    }
}

