/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.internal.r.debug.core.model;

import java.util.Objects;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IRegisterGroup;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.statet.internal.r.debug.core.Messages;
import org.eclipse.statet.internal.r.debug.core.RDebugCorePlugin;
import org.eclipse.statet.internal.r.debug.core.model.RDebugElement;
import org.eclipse.statet.internal.r.debug.core.model.RDebugTarget;
import org.eclipse.statet.internal.r.debug.core.model.RElementVariable;
import org.eclipse.statet.internal.r.debug.core.model.RMainThread;
import org.eclipse.statet.jcommons.lang.NonNull;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.status.ProgressMonitor;
import org.eclipse.statet.jcommons.status.StatusException;
import org.eclipse.statet.jcommons.ts.core.SystemRunnable;
import org.eclipse.statet.jcommons.ts.core.Tool;
import org.eclipse.statet.jcommons.ts.core.ToolRunnable;
import org.eclipse.statet.jcommons.ts.core.ToolService;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.r.core.data.CombinedRElement;
import org.eclipse.statet.r.core.data.CombinedRReference;
import org.eclipse.statet.r.core.model.RElementName;
import org.eclipse.statet.r.core.model.RModel;
import org.eclipse.statet.r.debug.core.IRStackFrame;
import org.eclipse.statet.r.debug.core.breakpoints.RBreakpointStatus;
import org.eclipse.statet.r.nico.AbstractRDbgController;
import org.eclipse.statet.r.nico.ICombinedRDataAdapter;
import org.eclipse.statet.rj.server.dbg.Frame;
import org.eclipse.statet.rj.server.dbg.FrameContext;

public class RStackFrame
extends RDebugElement
implements IRStackFrame {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final RMainThread thread;
    private int stamp;
    private Frame dbgFrame;
    private FrameContext dbgFrameContext;
    private final RElementName elementName;
    private final String call;
    private final String fileName;
    private Long handle;
    private boolean detailLoaded;
    private LoadContextRunnable contextRunnable;
    private final Condition contextCondition = this.lock.writeLock().newCondition();
    private final Condition contextWaitCondition = this.lock.writeLock().newCondition();
    private PositionResolver positionResolver;
    private RElementVariable frameVariable;
    private IValue variables;
    private RBreakpointStatus breakpointStatus;

    public RStackFrame(RDebugTarget target, RMainThread thread, int stamp, Frame dbgFrame, Long handle, String call, String fileName, RBreakpointStatus breakpointStatus) {
        super(target);
        this.thread = thread;
        this.stamp = stamp;
        this.dbgFrame = dbgFrame;
        this.elementName = dbgFrame.getPosition() > 0 ? RElementName.create((int)39, (String)Integer.toString(dbgFrame.getPosition())) : (dbgFrame.getPosition() == 0 ? RModel.GLOBAL_ENV_NAME : null);
        this.handle = handle;
        this.call = call;
        this.fileName = fileName;
        this.breakpointStatus = breakpointStatus;
    }

    public boolean update(int stamp, Frame dbgFrame, Long handle, String call, String fileName, RBreakpointStatus breakpointStatus) {
        if (call.equals(this.call) && Objects.equals(dbgFrame.getFileName(), this.dbgFrame.getFileName()) && dbgFrame.getFileTimestamp() == this.dbgFrame.getFileTimestamp()) {
            this.lock.writeLock().lock();
            try {
                if (this.stamp != stamp) {
                    this.stamp = stamp;
                    if (!(dbgFrame.getExprSrcref() != null ? dbgFrame.getExprSrcref().equals(this.dbgFrame.getExprSrcref()) : this.dbgFrame.getExprSrcref() == null) || dbgFrame.getFileTimestamp() == 0L || breakpointStatus != null) {
                        this.dbgFrame = dbgFrame;
                        this.detailLoaded = false;
                        this.breakpointStatus = breakpointStatus;
                        if (this.contextRunnable != null) {
                            this.contextRunnable.cancel = true;
                            this.contextCondition.signalAll();
                        }
                    }
                    this.handle = handle;
                    this.frameVariable = null;
                    this.variables = null;
                }
                return true;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        return false;
    }

    @Override
    public RMainThread getThread() {
        return this.thread;
    }

    public String getName() throws DebugException {
        return this.call;
    }

    @Override
    public RElementName getElementName() {
        RElementVariable variable = this.frameVariable;
        if (variable != null) {
            CombinedRElement element = variable.getElement();
            return element.getElementName();
        }
        return this.elementName;
    }

    public @NonNull Long getHandle() {
        return this.handle;
    }

    public Frame getDbgFrame() {
        return this.dbgFrame;
    }

    @Override
    public String getInfoFileName() {
        return this.fileName;
    }

    @Override
    public int getInfoLineNumber() {
        int[] exprSrcref = this.dbgFrame.getExprSrcref();
        return exprSrcref != null ? exprSrcref[0] : -1;
    }

    @Override
    public int getPosition() {
        return this.dbgFrame.getPosition();
    }

    public boolean isTerminated() {
        return this.thread.isTerminated();
    }

    public boolean canTerminate() {
        return this.thread.canTerminate();
    }

    public void terminate() throws DebugException {
        this.thread.terminate();
    }

    public boolean isSuspended() {
        return this.thread.isSuspended();
    }

    public boolean canSuspend() {
        return this.thread.canSuspend();
    }

    public boolean canResume() {
        return this.thread.canResume();
    }

    public void suspend() throws DebugException {
        this.thread.suspend();
    }

    public void resume() throws DebugException {
        this.thread.resume();
    }

    public boolean isStepping() {
        return this.thread.isStepping();
    }

    public boolean canStepInto() {
        return this.isSuspended() && this.dbgFrame.isTopFrame();
    }

    public boolean canStepOver() {
        return this.isSuspended() && (this.dbgFrame.getFlags() & 0x100) == 0;
    }

    public boolean canStepReturn() {
        return this.isSuspended() && this.dbgFrame.getPosition() > 0 && !this.dbgFrame.isTopLevelCommand();
    }

    public void stepInto() throws DebugException {
        if (this.canStepInto()) {
            this.getThread().stepInto();
        }
    }

    public void stepOver() throws DebugException {
        if (this.canStepOver()) {
            this.getThread().stepToFrame(this, 0);
        }
    }

    public void stepReturn() throws DebugException {
        if (this.canStepReturn()) {
            this.getThread().stepToFrame(this, 1);
        }
    }

    public boolean hasVariables() throws DebugException {
        return this.dbgFrame.getPosition() > 0;
    }

    public IVariable[] getVariables() throws DebugException {
        this.lock.readLock().lock();
        try {
            if (this.ensureContext() != null && this.variables != null) {
                IVariable[] iVariableArray = this.variables.getVariables();
                return iVariableArray;
            }
            IVariable[] iVariableArray = new IVariable[]{};
            return iVariableArray;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public boolean hasRegisterGroups() throws DebugException {
        return false;
    }

    public IRegisterGroup[] getRegisterGroups() throws DebugException {
        return null;
    }

    public void setPositionResolver(FrameContext context, PositionResolver resolver) {
        this.lock.writeLock().lock();
        if (this.dbgFrameContext != null ? this.dbgFrameContext == context : context == null) {
            this.positionResolver = resolver;
        }
        this.lock.writeLock().unlock();
    }

    public int getLineNumber() throws DebugException {
        PositionResolver resolver;
        this.lock.readLock().lock();
        try {
            resolver = this.positionResolver;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (resolver != null) {
            return resolver.getLineNumber() + 1;
        }
        return this.getInfoLineNumber();
    }

    public int getCharStart() throws DebugException {
        PositionResolver resolver;
        this.lock.readLock().lock();
        try {
            resolver = this.positionResolver;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (resolver != null) {
            return resolver.getCharStart();
        }
        return -1;
    }

    public int getCharEnd() throws DebugException {
        PositionResolver resolver;
        this.lock.readLock().lock();
        try {
            resolver = this.positionResolver;
        }
        finally {
            this.lock.readLock().unlock();
        }
        if (resolver != null) {
            return resolver.getCharEnd();
        }
        return -1;
    }

    private FrameContext ensureContext() {
        if (!this.detailLoaded) {
            this.lock.readLock().unlock();
            this.lock.writeLock().lock();
            try {
                Frame frame;
                block17: {
                    frame = this.dbgFrame;
                    while (this.contextRunnable != null && this.dbgFrame == frame) {
                        try {
                            this.contextWaitCondition.await();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    if (!this.detailLoaded && this.dbgFrame == frame) {
                        if (this.dbgFrame.getPosition() < 0) {
                            this.detailLoaded = true;
                        } else {
                            this.contextRunnable = new LoadContextRunnable();
                            try {
                                if (((RDebugTarget)this.getDebugTarget()).getProcess().getQueue().addHot((ToolRunnable)this.contextRunnable).getSeverity() != 0) break block17;
                                try {
                                    this.contextCondition.await();
                                }
                                catch (InterruptedException e) {
                                    this.contextRunnable.cancel = true;
                                }
                                if (this.contextRunnable.cancel) {
                                    ((RDebugTarget)this.getDebugTarget()).getProcess().getQueue().removeHot((ToolRunnable)this.contextRunnable);
                                }
                            }
                            finally {
                                this.contextRunnable = null;
                                this.contextWaitCondition.signalAll();
                            }
                        }
                    }
                }
                if (this.dbgFrame != frame) {
                    return null;
                }
            }
            finally {
                this.lock.readLock().lock();
                this.lock.writeLock().unlock();
            }
        }
        return this.dbgFrameContext;
    }

    public FrameContext getContext() {
        this.lock.readLock().lock();
        try {
            FrameContext frameContext = this.ensureContext();
            return frameContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void loadContext(AbstractRDbgController r, ProgressMonitor m) throws StatusException {
        this.lock.writeLock().lock();
        try {
            if (!r.isSuspended() || r.getHotTasksState() > 1) {
                return;
            }
            try {
                this.detailLoaded = true;
                if (this.stamp == r.getChangeStamp()) {
                    this.dbgFrameContext = r.evalFrameContext(this.dbgFrame.getPosition(), m);
                    CombinedRElement element = null;
                    if (this.dbgFrame.getPosition() >= 0) {
                        CombinedRReference ref = ICombinedRDataAdapter.createReference((long)this.getHandle(), (RElementName)this.elementName, (byte)8, (String)"environment");
                        element = this.thread.resolveReference((CombinedRElement)ref, this.stamp, m);
                    }
                    if (element != null) {
                        this.frameVariable = new RElementVariable(element, this.thread, this.stamp, null);
                        this.variables = this.frameVariable.getValue(m);
                    }
                }
            }
            catch (CoreException e) {
                RDebugCorePlugin.log((IStatus)new Status(4, "org.eclipse.statet.r.debug.core", 0, "An error occured when updating the debug context (position " + this.dbgFrame.getPosition() + ").", (Throwable)e));
            }
        }
        finally {
            try {
                this.contextCondition.signalAll();
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
    }

    @Override
    public <T> @Nullable T getAdapter(Class<T> type) {
        if (type == IRStackFrame.class) {
            return (T)this;
        }
        if (type == RBreakpointStatus.class) {
            return (T)this.breakpointStatus;
        }
        if (type == IBreakpoint.class) {
            RBreakpointStatus breakpointStatus = this.breakpointStatus;
            return (T)(breakpointStatus != null ? breakpointStatus.getBreakpoint() : null);
        }
        if (type == IModelElement.class) {
            RElementVariable variable = this.frameVariable;
            return (T)(variable != null ? this.frameVariable.getElement() : null);
        }
        return super.getAdapter(type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append("\n\t");
        sb.append("position= ").append(this.dbgFrame.getPosition());
        sb.append("\n\t");
        sb.append("fileName= ").append(this.dbgFrame.getFileName());
        sb.append("\n\t");
        sb.append("exprSrcref= ").append(this.getInfoLineNumber());
        return sb.toString();
    }

    private class LoadContextRunnable
    implements SystemRunnable {
        private boolean cancel;

        public String getTypeId() {
            return "r/dbg/stackframe";
        }

        public String getLabel() {
            return Messages.DebugContext_UpdateStackFrame_task;
        }

        public boolean canRunIn(Tool tool) {
            return tool == RStackFrame.this.thread.getTool();
        }

        public boolean changed(int event, Tool process) {
            switch (event) {
                case 288: {
                    return this.cancel;
                }
                case 289: {
                    return false;
                }
                case 290: {
                    RStackFrame.this.lock.writeLock().lock();
                    try {
                        RStackFrame.this.contextCondition.signalAll();
                        break;
                    }
                    finally {
                        RStackFrame.this.lock.writeLock().unlock();
                    }
                }
            }
            return true;
        }

        public void run(ToolService service, ProgressMonitor m) throws StatusException {
            RStackFrame.this.loadContext((AbstractRDbgController)service, m);
        }
    }

    public static interface PositionResolver {
        public int getLineNumber();

        public int getCharStart();

        public int getCharEnd();
    }
}

