/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting.assist;

import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.persistence.TemplateStore;
import org.eclipse.statet.internal.ltk.ui.LTKUIPlugin;
import org.eclipse.statet.jcommons.collections.ImCollections;
import org.eclipse.statet.jcommons.lang.NonNullByDefault;
import org.eclipse.statet.jcommons.lang.Nullable;
import org.eclipse.statet.jcommons.text.core.BasicTextRegion;
import org.eclipse.statet.jcommons.text.core.TextRegion;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistInvocationContext;
import org.eclipse.statet.ltk.ui.sourceediting.assist.AssistProposalCollector;
import org.eclipse.statet.ltk.ui.sourceediting.assist.ContentAssist;
import org.eclipse.statet.ltk.ui.sourceediting.assist.IContentAssistComputer;
import org.eclipse.statet.ltk.ui.sourceediting.assist.TemplateProposal;
import org.eclipse.statet.ltk.ui.templates.SourceEditorTemplateContext;
import org.eclipse.swt.graphics.Image;
import org.eclipse.text.templates.ContextTypeRegistry;

@NonNullByDefault
public abstract class TemplateCompletionComputer
implements IContentAssistComputer {
    private static final byte SELECTION_NONE = 0;
    private static final byte SELECTION_INLINE = 1;
    private static final byte SELECTION_MULTILINE = 2;
    private static final Pattern SELECTION_INLINE_PATTERN = Pattern.compile("\\$\\{word_selection\\}");
    private static final Pattern SELECTION_ANY_PATTERN = Pattern.compile("\\$\\{(?:word_selection|line_selection)\\}");
    protected final TemplateStore templateStore;
    protected final ContextTypeRegistry typeRegistry;

    public TemplateCompletionComputer(TemplateStore templateStore, ContextTypeRegistry contextTypes) {
        if (templateStore == null) {
            throw new NullPointerException("templateStore");
        }
        if (contextTypes == null) {
            throw new NullPointerException("contextTypes");
        }
        this.templateStore = templateStore;
        this.typeRegistry = contextTypes;
    }

    protected final TemplateStore getTemplateStore() {
        return this.templateStore;
    }

    protected final ContextTypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    @Override
    public void sessionStarted(ISourceEditor editor, ContentAssist assist) {
    }

    @Override
    public void sessionEnded() {
    }

    protected boolean handleRequest(int mode, String prefix) {
        return prefix != null && (prefix.length() > 0 || mode == 2);
    }

    @Override
    public @Nullable IStatus computeCompletionProposals(AssistInvocationContext context, int mode, AssistProposalCollector proposals, IProgressMonitor monitor) {
        SourceViewer viewer = context.getSourceViewer();
        boolean flags = false;
        String prefix = this.extractPrefix(context);
        if (!this.handleRequest(mode, prefix)) {
            return null;
        }
        AssistInvocationContext region = context.getLength() == 0 ? new BasicTextRegion(context.getInvocationOffset() - prefix.length(), context.getInvocationOffset()) : context;
        SourceEditorTemplateContext templateContext = this.createTemplateContext(context, region, 0);
        if (templateContext == null) {
            return null;
        }
        int count = 0;
        if (context.getLength() > 0) {
            if (prefix.length() == context.getLength()) {
                count = this.doComputeProposals(templateContext, prefix, 0, region, proposals);
            }
            prefix = "";
            if (count != 0 && (templateContext = this.createTemplateContext(context, region, 0)) == null) {
                return null;
            }
        }
        try {
            int selectionType;
            IDocument document = viewer.getDocument();
            String text = document.get(context.getOffset(), context.getLength());
            if (text.isEmpty()) {
                selectionType = 0;
            } else {
                selectionType = text.indexOf(10) >= 0 ? 2 : 1;
                templateContext.setVariable("text", text);
            }
            templateContext.setVariable("selection", text);
            this.doComputeProposals(templateContext, prefix, selectionType, region, proposals);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public @Nullable IStatus computeInformationProposals(AssistInvocationContext context, AssistProposalCollector tenders, IProgressMonitor monitor) {
        return null;
    }

    private int doComputeProposals(DocumentTemplateContext context, String prefix, int selectionType, TextRegion replacementRegion, AssistProposalCollector proposals) {
        boolean count = false;
        List<Template> templates = this.getTemplates(context.getContextType().getId());
        for (Template template : templates) {
            if (!this.include(template, prefix) && !this.isSelectionTemplate(selectionType, template)) continue;
            try {
                context.getContextType().validate(template.getPattern());
            }
            catch (TemplateException e) {
                continue;
            }
            proposals.add(this.createProposal(template, context, prefix, replacementRegion, template.getName().regionMatches(true, 0, prefix, 0, prefix.length()) ? 20 : -100));
        }
        return 0;
    }

    protected boolean include(Template template, String prefix) {
        return template.getName().regionMatches(true, 0, prefix, 0, prefix.length());
    }

    private boolean isSelectionTemplate(int selectionType, Template template) {
        switch (selectionType) {
            case 1: {
                return SELECTION_INLINE_PATTERN.matcher(template.getPattern()).matches();
            }
            case 2: {
                return SELECTION_ANY_PATTERN.matcher(template.getPattern()).matches();
            }
        }
        return false;
    }

    protected String extractPrefix(AssistInvocationContext context) {
        return context.getIdentifierPrefix();
    }

    protected List<Template> getTemplates(String contextTypeId) {
        return ImCollections.newList((Object[])this.templateStore.getTemplates(contextTypeId));
    }

    protected abstract @Nullable TemplateContextType getContextType(AssistInvocationContext var1, TextRegion var2);

    protected @Nullable SourceEditorTemplateContext createTemplateContext(AssistInvocationContext context, TextRegion region, int flags) {
        TemplateContextType contextType = this.getContextType(context, region);
        if (contextType != null) {
            return new SourceEditorTemplateContext(contextType, context.getDocument(), region.getStartOffset(), region.getLength(), context.getEditor(), flags);
        }
        return null;
    }

    protected TemplateProposal createProposal(Template template, DocumentTemplateContext context, String prefix, TextRegion region, int relevance) {
        return new TemplateProposal(template, (TemplateContext)context, region, this.getImage(template), relevance);
    }

    protected @Nullable Image getImage(Template template) {
        return LTKUIPlugin.getInstance().getImageRegistry().get("org.eclipse.statet.ltk.ui/image/obj/text.template");
    }
}

