/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.statet.ltk.ui.sourceediting;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.statet.ecommons.ui.SharedUIResources;
import org.eclipse.statet.ecommons.ui.actions.HandlerCollection;
import org.eclipse.statet.ecommons.ui.util.UIAccess;
import org.eclipse.statet.ecommons.ui.workbench.AbstractEditorOutlinePage;
import org.eclipse.statet.internal.ltk.ui.EditingMessages;
import org.eclipse.statet.ltk.ast.core.AstInfo;
import org.eclipse.statet.ltk.core.ISourceModelStamp;
import org.eclipse.statet.ltk.model.core.IModelElementDelta;
import org.eclipse.statet.ltk.model.core.elements.IModelElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceStructElement;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnit;
import org.eclipse.statet.ltk.model.core.elements.ISourceUnitModelInfo;
import org.eclipse.statet.ltk.ui.IModelElementInputListener;
import org.eclipse.statet.ltk.ui.ISelectionWithElementInfoListener;
import org.eclipse.statet.ltk.ui.LTKInputData;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditor;
import org.eclipse.statet.ltk.ui.sourceediting.ISourceEditorAssociated;
import org.eclipse.statet.ltk.ui.sourceediting.OutlineContentProvider;
import org.eclipse.statet.ltk.ui.sourceediting.SourceEditor1;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.editors.text.IEncodingSupport;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public abstract class SourceEditor1OutlinePage
extends AbstractEditorOutlinePage
implements IContentOutlinePage,
IAdaptable,
ISourceEditorAssociated,
IShowInSource,
IShowInTargetList,
IShowInTarget,
IPostSelectionProvider,
IModelElementInputListener {
    private final SourceEditor1 editor;
    private final String mainType;
    private OutlineContentProvider contentProvider;
    private ISourceModelStamp currentModelStamp;
    private IModelElement inputUnit;
    private SyncWithEditorAction syncWithEditorAction;

    public SourceEditor1OutlinePage(SourceEditor1 editor, String mainType, String contextMenuId) {
        super(contextMenuId);
        if (editor == null) {
            throw new NullPointerException();
        }
        if (mainType == null) {
            throw new NullPointerException();
        }
        this.editor = editor;
        this.mainType = mainType;
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
        pageSite.setSelectionProvider((ISelectionProvider)this);
    }

    protected boolean isUpToDate(ISourceModelStamp stamp) {
        ISourceModelStamp current = this.currentModelStamp;
        return current != null && current.equals(stamp);
    }

    protected IModelElement.Filter getContentFilter() {
        return null;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        this.editor.getModelInputProvider().addListener(this);
        this.getViewer().setInput((Object)this.inputUnit);
    }

    protected OutlineContentProvider createContentProvider() {
        return new OutlineContentProvider(new OutlineContent());
    }

    protected void configureViewer(TreeViewer viewer) {
        this.contentProvider = this.createContentProvider();
        viewer.setContentProvider((IContentProvider)this.contentProvider);
    }

    protected void initActions(IServiceLocator serviceLocator, HandlerCollection handlers) {
        super.initActions(serviceLocator, handlers);
        this.syncWithEditorAction = new SyncWithEditorAction();
    }

    protected void contributeToActionBars(IServiceLocator serviceLocator, IActionBars actionBars, HandlerCollection handlers) {
        super.contributeToActionBars(serviceLocator, actionBars, handlers);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.editor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.editor.getAction(ITextEditorActionConstants.REDO));
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", this.editor.getAction(ITextEditorActionConstants.NEXT));
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", this.editor.getAction(ITextEditorActionConstants.PREVIOUS));
        IMenuManager menuManager = actionBars.getMenuManager();
        menuManager.add((IAction)this.syncWithEditorAction);
        IContextService service = (IContextService)serviceLocator.getService(IContextService.class);
        service.activateContext("org.eclipse.statet.ltk.contexts.EditSource1MenuSet");
    }

    protected void contextMenuAboutToShow(IMenuManager m) {
        Separator additions = new Separator("additions");
        m.add((IContributionItem)additions);
    }

    @Override
    public void elementChanged(IModelElement element) {
        this.inputUnit = element;
        this.currentModelStamp = null;
        TreeViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            viewer.setInput((Object)this.inputUnit);
        }
    }

    @Override
    public void elementInitialInfo(IModelElement element) {
        this.elementUpdatedInfo(element, null);
    }

    @Override
    public void elementUpdatedInfo(final IModelElement element, IModelElementDelta delta) {
        if (element != this.inputUnit || element == null && this.inputUnit == null) {
            return;
        }
        Display display = UIAccess.getDisplay();
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                TreeViewer viewer = SourceEditor1OutlinePage.this.getViewer();
                if (element != SourceEditor1OutlinePage.this.inputUnit || !UIAccess.isOkToUse((Viewer)viewer) || SourceEditor1OutlinePage.this.isUpToDate(SourceEditor1OutlinePage.this.contentProvider.getStamp(element))) {
                    return;
                }
                SourceEditor1OutlinePage.this.beginIgnoreSelection();
                try {
                    viewer.refresh(true);
                }
                finally {
                    SourceEditor1OutlinePage.this.endIgnoreSelection(false);
                }
            }
        });
    }

    protected ISourceUnitModelInfo getModelInfo(Object input) {
        if (input instanceof ISourceUnit) {
            return ((ISourceUnit)input).getModelInfo(this.mainType, 0, null);
        }
        return null;
    }

    public void dispose() {
        this.editor.getModelInputProvider().removeListener(this);
        this.editor.handleOutlinePageClosed();
        super.dispose();
    }

    protected void selectInEditor(ISelection selection) {
        this.editor.setSelection(selection, this.syncWithEditorAction);
    }

    protected void select(ISourceStructElement element) {
        TreeViewer viewer = this.getViewer();
        if (UIAccess.isOkToUse((Viewer)viewer)) {
            this.beginIgnoreSelection();
            try {
                IModelElement.Filter filter = this.getContentFilter();
                Object selectedElement = null;
                IStructuredSelection currentSelection = (IStructuredSelection)viewer.getSelection();
                if (currentSelection.size() == 1) {
                    selectedElement = currentSelection.getFirstElement();
                }
                while (element != null && (element.getElementType() & 0xFF0) != 528) {
                    ISourceStructElement parent;
                    if (selectedElement != null && element.equals(selectedElement)) {
                        return;
                    }
                    if (filter == null || filter.include((IModelElement)element)) {
                        selectedElement = null;
                        viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
                        if (!viewer.getSelection().isEmpty()) {
                            return;
                        }
                    }
                    if (!((parent = element.getSourceParent()) instanceof ISourceStructElement)) break;
                    element = parent;
                }
                if (!viewer.getSelection().isEmpty()) {
                    viewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
            finally {
                this.endIgnoreSelection(true);
            }
        }
    }

    public ShowInContext getShowInContext() {
        return new ShowInContext((Object)this.editor.getEditorInput(), null);
    }

    public String[] getShowInTargetIds() {
        return new String[]{"org.eclipse.ui.navigator.ProjectExplorer"};
    }

    public boolean show(ShowInContext context) {
        IModelElement inputUnit = this.inputUnit;
        ISelection selection = context.getSelection();
        if (selection instanceof LTKInputData) {
            LTKInputData data = (LTKInputData)selection;
            data.update();
            if (inputUnit.equals(data.getInputElement())) {
                this.select(data.getModelSelection());
                return true;
            }
        }
        return false;
    }

    @Override
    public ISourceEditor getSourceEditor() {
        return this.editor;
    }

    public <T> T getAdapter(Class<T> adapterType) {
        if (adapterType == ISourceEditorAssociated.class) {
            return (T)this;
        }
        if (adapterType == IEncodingSupport.class) {
            return (T)this.editor.getAdapter(IEncodingSupport.class);
        }
        if (adapterType == IContentType.class) {
            return (T)this.editor.getContentType();
        }
        return null;
    }

    public class AstContentProvider
    extends OutlineContentProvider {
        public AstContentProvider() {
            super(new OutlineContent());
        }

        @Override
        public ISourceModelStamp getStamp(Object inputElement) {
            AstInfo ast;
            if (inputElement instanceof ISourceUnit && (ast = ((ISourceUnit)inputElement).getAstInfo(SourceEditor1OutlinePage.this.mainType, false, null)) != null) {
                return ast.getStamp();
            }
            return null;
        }

        @Override
        public Object[] getElements(Object inputElement) {
            AstInfo ast;
            if (inputElement instanceof ISourceUnit && (ast = ((ISourceUnit)inputElement).getAstInfo(SourceEditor1OutlinePage.this.mainType, false, null)) != null) {
                SourceEditor1OutlinePage.this.currentModelStamp = ast.getStamp();
                return new Object[]{ast.getRoot()};
            }
            return new Object[0];
        }
    }

    protected class OutlineContent
    implements OutlineContentProvider.IOutlineContent {
        @Override
        public ISourceUnitModelInfo getModelInfo(Object input) {
            return SourceEditor1OutlinePage.this.getModelInfo(input);
        }

        @Override
        public IModelElement.Filter getContentFilter() {
            return SourceEditor1OutlinePage.this.getContentFilter();
        }
    }

    private class SyncWithEditorAction
    extends ToggleAction
    implements ISelectionWithElementInfoListener {
        public SyncWithEditorAction() {
            super("sync.editor", true, 0);
            this.setText(EditingMessages.SyncWithEditor_label);
            this.setImageDescriptor(SharedUIResources.getImages().getDescriptor("org.eclipse.statet.ecommons.uimisc/image/loctool/synchronized"));
        }

        @Override
        protected void configure(boolean on) {
            if (on) {
                SourceEditor1OutlinePage.this.editor.addPostSelectionWithElementInfoListener(this);
            } else {
                SourceEditor1OutlinePage.this.editor.removePostSelectionWithElementInfoListener(this);
            }
        }

        @Override
        public void inputChanged() {
        }

        @Override
        public void stateChanged(final LTKInputData state) {
            if (!state.isStillValid()) {
                return;
            }
            if (!SourceEditor1OutlinePage.this.isUpToDate(state.getInputInfo().getStamp())) {
                SourceEditor1OutlinePage.this.elementUpdatedInfo(state.getInputElement(), null);
            }
            UIAccess.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (state.isStillValid() && SyncWithEditorAction.this.isChecked()) {
                        SourceEditor1OutlinePage.this.select(state.getModelSelection());
                    }
                }
            });
        }
    }

    @Deprecated
    protected abstract class ToggleAction
    extends Action {
        private final String settingsKey;
        private final int time;

        public ToggleAction(String checkSettingsKey, boolean checkSettingsDefault, int expensive) {
            assert (checkSettingsKey != null);
            this.settingsKey = checkSettingsKey;
            this.time = expensive;
            IDialogSettings settings = SourceEditor1OutlinePage.this.getDialogSettings();
            boolean on = settings.get(this.settingsKey) == null ? checkSettingsDefault : SourceEditor1OutlinePage.this.getDialogSettings().getBoolean(this.settingsKey);
            this.setChecked(on);
            this.configure(on);
        }

        protected void init() {
        }

        public void run() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    boolean on = ToggleAction.this.isChecked();
                    ToggleAction.this.configure(on);
                    SourceEditor1OutlinePage.this.getDialogSettings().put(ToggleAction.this.settingsKey, on);
                }
            };
            if (this.time == 0) {
                runnable.run();
            } else {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)runnable);
            }
        }

        protected abstract void configure(boolean var1);
    }
}

