/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ecore.design.service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;

public class EReferenceServices {
    private static final String CARDINALITY_SEPARATOR = "..";
    private static final String EOPPOSITE_SEPARATOR = " - ";
    private static final String DERIVED_PREFIX = "/";
    private static final String CARDINALITY_UNBOUNDED = "*";
    private static final String CARDINALITY_UNBOUNDED_ALTERNATIVE = "-1";

    public String getEOppositeEReferenceName(EReference ref) {
        if (ref.getEOpposite() != null) {
            return String.valueOf(this.render(ref.getEOpposite())) + EOPPOSITE_SEPARATOR + this.render(ref);
        }
        return "";
    }

    public List<EReference> getEOppositeEReferences(EPackage pkg, List<EReference> references) {
        HashMap<String, EReference> map = new HashMap<String, EReference>();
        for (EReference ref : references) {
            if (ref.getEOpposite() == null) continue;
            String key1 = String.valueOf(ref.getEOpposite().hashCode()) + ref.hashCode();
            String key2 = String.valueOf(ref.hashCode()) + ref.getEOpposite().hashCode();
            if (map.get(key1) != null || map.get(key2) != null) continue;
            map.put(key1, ref);
        }
        return new ArrayList<EReference>(map.values());
    }

    public String render(EReference ref) {
        StringBuilder sb = new StringBuilder();
        this.renderCardinality(ref, sb);
        this.renderName(ref, sb);
        return sb.toString();
    }

    private void renderCardinality(EReference ref, StringBuilder sb) {
        sb.append("[");
        sb.append(this.renderBound(ref.getLowerBound()));
        sb.append(CARDINALITY_SEPARATOR);
        sb.append(this.renderBound(ref.getUpperBound()));
        sb.append("]");
    }

    private String renderBound(int bound) {
        if (bound == -1) {
            return CARDINALITY_UNBOUNDED;
        }
        return String.valueOf(bound);
    }

    private void renderName(EReference ref, StringBuilder sb) {
        if (ref.getName() != null) {
            sb.append(" ");
            if (ref.isDerived()) {
                sb.append(DERIVED_PREFIX);
            }
            sb.append(ref.getName());
        }
    }

    public EReference performEdit(EReference ref, String editString) {
        if ("0".equals(editString.trim())) {
            ref.setLowerBound(0);
        } else if ("1".equals(editString.trim())) {
            ref.setLowerBound(1);
        } else if (CARDINALITY_UNBOUNDED.equals(editString.trim())) {
            ref.setUpperBound(-1);
        } else if (CARDINALITY_UNBOUNDED_ALTERNATIVE.equals(editString.trim())) {
            ref.setUpperBound(-1);
        } else {
            this.editName(ref, editString);
            this.editCardinality(ref, editString);
        }
        return ref;
    }

    private void editName(EReference ref, String editString) {
        String namePart = this.extractNamePart(ref, editString);
        if (namePart != null && namePart.trim().length() > 0) {
            boolean derived = namePart.startsWith(DERIVED_PREFIX);
            ref.setDerived(derived);
            ref.setName(namePart.substring(derived ? DERIVED_PREFIX.length() : 0).trim());
        }
    }

    private String extractNamePart(EReference ref, String name) {
        int end = name.indexOf("]");
        if (end != -1 && end < name.length()) {
            return name.substring(end + 1).trim();
        }
        return name.trim();
    }

    private void editCardinality(EReference ref, String editString) {
        List<Integer> card = this.parseCardinality(editString);
        if (card.get(0) != null) {
            ref.setLowerBound(card.get(0).intValue());
        }
        if (card.get(1) != null) {
            ref.setUpperBound(card.get(1).intValue());
        }
    }

    public List<Integer> parseCardinality(String editString) {
        ArrayList<Integer> result = new ArrayList<Integer>(Arrays.asList(null, null));
        String spec = this.extractCardinalityPart(editString);
        if (spec != null && spec.contains(CARDINALITY_SEPARATOR)) {
            String[] parts = spec.split(Pattern.quote(CARDINALITY_SEPARATOR));
            switch (parts.length) {
                case 0: {
                    break;
                }
                case 1: {
                    if (spec.startsWith(CARDINALITY_SEPARATOR)) {
                        result.set(1, this.parseBound(parts[0]));
                        break;
                    }
                    if (!spec.endsWith(CARDINALITY_SEPARATOR)) break;
                    result.set(0, this.parseBound(parts[0]));
                    break;
                }
                default: {
                    result.set(0, this.parseBound(parts[0]));
                    result.set(1, this.parseBound(parts[1]));
                }
            }
        }
        return result;
    }

    private Integer parseBound(String bound) {
        if (CARDINALITY_UNBOUNDED.equals(bound.trim())) {
            return -1;
        }
        try {
            return Integer.parseInt(bound.trim());
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public String extractCardinalityPart(String editString) {
        int start = editString.indexOf("[");
        int end = editString.indexOf("]");
        if (start != -1 && end != -1 && start < end && end < editString.length()) {
            return editString.substring(start + 1, end).trim();
        }
        return null;
    }
}

