/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.io.content;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.ExceptionUtil;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.SerializedInvoker;

public class PathContentSource
implements Content.Source {
    private final AutoLock lock;
    private final SerializedInvoker invoker;
    private final Path path;
    private final long length;
    private final ByteBufferPool byteBufferPool;
    private int bufferSize;
    private boolean useDirectByteBuffers;
    private SeekableByteChannel channel;
    private long totalRead;
    private Runnable demandCallback;
    private Content.Chunk errorChunk;

    public PathContentSource(Path path) {
        this(path, null, true, -1);
    }

    public PathContentSource(Path path, ByteBufferPool byteBufferPool) {
        int n;
        boolean bl;
        ByteBufferPool byteBufferPool2;
        ByteBufferPool.Sized sized;
        if (byteBufferPool instanceof ByteBufferPool.Sized) {
            sized = (ByteBufferPool.Sized)byteBufferPool;
            byteBufferPool2 = sized.getWrapped();
        } else {
            byteBufferPool2 = byteBufferPool;
        }
        if (byteBufferPool instanceof ByteBufferPool.Sized) {
            sized = (ByteBufferPool.Sized)byteBufferPool;
            bl = sized.isDirect();
        } else {
            bl = true;
        }
        if (byteBufferPool instanceof ByteBufferPool.Sized) {
            sized = (ByteBufferPool.Sized)byteBufferPool;
            n = sized.getSize();
        } else {
            n = -1;
        }
        this(path, byteBufferPool2, bl, n);
    }

    public PathContentSource(Path path, ByteBufferPool.Sized sizedBufferPool) {
        this(path, sizedBufferPool == null ? null : sizedBufferPool.getWrapped(), sizedBufferPool == null ? true : sizedBufferPool.isDirect(), sizedBufferPool == null ? -1 : sizedBufferPool.getSize());
    }

    private PathContentSource(Path path, ByteBufferPool byteBufferPool, boolean direct, int bufferSize) {
        this.lock = new AutoLock();
        this.invoker = new SerializedInvoker(PathContentSource.class);
        try {
            if (!Files.isRegularFile(path, new LinkOption[0])) {
                throw new NoSuchFileException(path.toString());
            }
            if (!Files.isReadable(path)) {
                throw new AccessDeniedException(path.toString());
            }
            this.path = path;
            this.length = Files.size(path);
            this.byteBufferPool = byteBufferPool != null ? byteBufferPool : ByteBufferPool.NON_POOLING;
            this.useDirectByteBuffers = direct;
            this.bufferSize = bufferSize > 0 ? bufferSize : 4096;
        }
        catch (IOException x) {
            throw new UncheckedIOException(x);
        }
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    @Deprecated(forRemoval=true)
    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public boolean isUseDirectByteBuffers() {
        return this.useDirectByteBuffers;
    }

    @Deprecated(forRemoval=true)
    public void setUseDirectByteBuffers(boolean useDirectByteBuffers) {
        this.useDirectByteBuffers = useDirectByteBuffers;
    }

    @Override
    public Content.Chunk read() {
        boolean last;
        int read;
        SeekableByteChannel channel;
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk != null) {
                Content.Chunk chunk = this.errorChunk;
                return chunk;
            }
            if (this.channel == null) {
                try {
                    this.channel = this.open();
                }
                catch (Throwable x) {
                    Content.Chunk chunk = this.failure(x);
                    if (ignored != null) {
                        ignored.close();
                    }
                    return chunk;
                }
            }
            channel = this.channel;
        }
        if (!channel.isOpen()) {
            return Content.Chunk.EOF;
        }
        RetainableByteBuffer retainableByteBuffer = this.byteBufferPool.acquire(this.getBufferSize(), this.isUseDirectByteBuffers());
        ByteBuffer byteBuffer = retainableByteBuffer.getByteBuffer();
        try {
            BufferUtil.clearToFill((ByteBuffer)byteBuffer);
            read = this.read(channel, byteBuffer);
            BufferUtil.flipToFlush((ByteBuffer)byteBuffer, (int)0);
        }
        catch (Throwable x) {
            retainableByteBuffer.release();
            return this.failure(x);
        }
        if (read > 0) {
            this.totalRead += (long)read;
        }
        boolean bl = last = read == -1 || this.isReadComplete(this.totalRead);
        if (last) {
            IO.close((Closeable)channel);
        }
        return Content.Chunk.asChunk(byteBuffer, last, retainableByteBuffer);
    }

    protected SeekableByteChannel open() throws IOException {
        return Files.newByteChannel(this.path, StandardOpenOption.READ);
    }

    protected int read(SeekableByteChannel channel, ByteBuffer byteBuffer) throws IOException {
        return channel.read(byteBuffer);
    }

    protected boolean isReadComplete(long read) {
        return read == this.getLength();
    }

    @Override
    public void demand(Runnable demandCallback) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.demandCallback != null) {
                throw new IllegalStateException("demand pending");
            }
            this.demandCallback = demandCallback;
        }
        this.invoker.run(this::invokeDemandCallback);
    }

    private void invokeDemandCallback() {
        Runnable demandCallback;
        try (AutoLock ignored = this.lock.lock();){
            demandCallback = this.demandCallback;
            this.demandCallback = null;
        }
        if (demandCallback != null) {
            ExceptionUtil.run((Runnable)demandCallback, this::fail);
        }
    }

    @Override
    public void fail(Throwable failure) {
        this.failure(failure);
    }

    private Content.Chunk failure(Throwable failure) {
        try (AutoLock ignored = this.lock.lock();){
            if (this.errorChunk == null) {
                this.errorChunk = Content.Chunk.from(failure);
                IO.close((Closeable)this.channel);
            }
            Content.Chunk chunk = this.errorChunk;
            return chunk;
        }
    }

    @Override
    public boolean rewind() {
        try (AutoLock ignored = this.lock.lock();){
            IO.close((Closeable)this.channel);
            this.channel = null;
            this.totalRead = 0L;
            this.demandCallback = null;
            this.errorChunk = null;
        }
        return true;
    }
}

