/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.util.Currency;
import com.ibm.icu.util.CurrencyAmount;
import com.ibm.icu.util.ULocale;
import java.io.InvalidObjectException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Set;

public class NumberFormat
extends Format {
    private static final long serialVersionUID = 1L;
    public final java.text.NumberFormat numberFormat;
    public static final int NUMBERSTYLE = 0;
    public static final int CURRENCYSTYLE = 1;
    public static final int PERCENTSTYLE = 2;
    public static final int SCIENTIFICSTYLE = 3;
    public static final int INTEGERSTYLE = 4;
    public static final int ISOCURRENCYSTYLE = 5;
    public static final int PLURALCURRENCYSTYLE = 6;
    public static final int INTEGER_FIELD = 0;
    public static final int FRACTION_FIELD = 1;
    private static volatile ULocale[] availableULocales;

    public NumberFormat(java.text.NumberFormat delegate) {
        this.numberFormat = delegate;
    }

    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number, toAppendTo, jdkPos);
        if (jdkPos != null) {
            pos.setBeginIndex(jdkPos.getBeginIndex());
            pos.setEndIndex(jdkPos.getEndIndex());
        }
        return buf;
    }

    public final Object parseObject(String source, ParsePosition parsePosition) {
        return this.numberFormat.parse(source, parsePosition);
    }

    public final String format(double number) {
        return this.numberFormat.format(number);
    }

    public final String format(long number) {
        return this.numberFormat.format(number);
    }

    public final String format(BigInteger number) {
        return this.numberFormat.format(number);
    }

    public final String format(BigDecimal number) {
        return this.numberFormat.format(number);
    }

    public final String format(com.ibm.icu.math.BigDecimal number) {
        return this.numberFormat.format(number.toBigDecimal());
    }

    public final String format(CurrencyAmount currAmt) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number, toAppendTo, jdkPos);
        pos.setBeginIndex(jdkPos.getBeginIndex());
        pos.setEndIndex(jdkPos.getEndIndex());
        return buf;
    }

    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number, toAppendTo, jdkPos);
        pos.setBeginIndex(jdkPos.getBeginIndex());
        pos.setEndIndex(jdkPos.getEndIndex());
        return buf;
    }

    public StringBuffer format(BigInteger number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number, toAppendTo, jdkPos);
        pos.setBeginIndex(jdkPos.getBeginIndex());
        pos.setEndIndex(jdkPos.getEndIndex());
        return buf;
    }

    public StringBuffer format(BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number, toAppendTo, jdkPos);
        pos.setBeginIndex(jdkPos.getBeginIndex());
        pos.setEndIndex(jdkPos.getEndIndex());
        return buf;
    }

    public StringBuffer format(com.ibm.icu.math.BigDecimal number, StringBuffer toAppendTo, FieldPosition pos) {
        FieldPosition jdkPos = NumberFormat.toJDKFieldPosition(pos);
        StringBuffer buf = this.numberFormat.format(number.toBigDecimal(), toAppendTo, jdkPos);
        pos.setBeginIndex(jdkPos.getBeginIndex());
        pos.setEndIndex(jdkPos.getEndIndex());
        return buf;
    }

    public StringBuffer format(CurrencyAmount currAmt, StringBuffer toAppendTo, FieldPosition pos) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public Number parse(String text, ParsePosition parsePosition) {
        return this.numberFormat.parse(text, parsePosition);
    }

    public Number parse(String text) throws ParseException {
        return this.numberFormat.parse(text);
    }

    CurrencyAmount parseCurrency(String text, ParsePosition pos) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public boolean isParseIntegerOnly() {
        return this.numberFormat.isParseIntegerOnly();
    }

    public void setParseIntegerOnly(boolean value) {
        this.numberFormat.setParseIntegerOnly(value);
    }

    public void setParseStrict(boolean value) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public boolean isParseStrict() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static final NumberFormat getInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 0);
    }

    public static NumberFormat getInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    public static NumberFormat getInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getInstance(int style) {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), style);
    }

    public static NumberFormat getInstance(Locale inLocale, int style) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), style);
    }

    public static final NumberFormat getNumberInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 0);
    }

    public static NumberFormat getNumberInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 0);
    }

    public static NumberFormat getNumberInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 0);
    }

    public static final NumberFormat getIntegerInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 4);
    }

    public static NumberFormat getIntegerInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 4);
    }

    public static NumberFormat getIntegerInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 4);
    }

    public static final NumberFormat getCurrencyInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 1);
    }

    public static NumberFormat getCurrencyInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 1);
    }

    public static NumberFormat getCurrencyInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 1);
    }

    public static final NumberFormat getPercentInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 2);
    }

    public static NumberFormat getPercentInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 2);
    }

    public static NumberFormat getPercentInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 2);
    }

    public static final NumberFormat getScientificInstance() {
        return NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT), 3);
    }

    public static NumberFormat getScientificInstance(Locale inLocale) {
        return NumberFormat.getInstance(ULocale.forLocale(inLocale), 3);
    }

    public static NumberFormat getScientificInstance(ULocale inLocale) {
        return NumberFormat.getInstance(inLocale, 3);
    }

    public static Locale[] getAvailableLocales() {
        return java.text.NumberFormat.getAvailableLocales();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ULocale[] getAvailableULocales() {
        if (availableULocales != null) return (ULocale[])availableULocales.clone();
        Class<NumberFormat> clazz = NumberFormat.class;
        synchronized (NumberFormat.class) {
            if (availableULocales != null) return (ULocale[])availableULocales.clone();
            Locale[] locales = java.text.NumberFormat.getAvailableLocales();
            ULocale[] ulocales = new ULocale[locales.length];
            int i = 0;
            while (i < locales.length) {
                ulocales[i] = ULocale.forLocale(locales[i]);
                ++i;
            }
            availableULocales = ulocales;
            // ** MonitorExit[var0] (shouldn't be in output)
            return (ULocale[])availableULocales.clone();
        }
    }

    public static Object registerFactory(NumberFormatFactory factory) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static boolean unregister(Object registryKey) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public int hashCode() {
        return this.numberFormat.hashCode();
    }

    public boolean equals(Object obj) {
        try {
            return this.numberFormat.equals(((NumberFormat)obj).numberFormat);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public Object clone() {
        return new NumberFormat((java.text.NumberFormat)this.numberFormat.clone());
    }

    public boolean isGroupingUsed() {
        return this.numberFormat.isGroupingUsed();
    }

    public void setGroupingUsed(boolean newValue) {
        this.numberFormat.setGroupingUsed(newValue);
    }

    public int getMaximumIntegerDigits() {
        return this.numberFormat.getMaximumIntegerDigits();
    }

    public void setMaximumIntegerDigits(int newValue) {
        this.numberFormat.setMaximumIntegerDigits(newValue);
    }

    public int getMinimumIntegerDigits() {
        return this.numberFormat.getMinimumIntegerDigits();
    }

    public void setMinimumIntegerDigits(int newValue) {
        this.numberFormat.setMinimumIntegerDigits(newValue);
    }

    public int getMaximumFractionDigits() {
        return this.numberFormat.getMaximumFractionDigits();
    }

    public void setMaximumFractionDigits(int newValue) {
        this.numberFormat.setMaximumFractionDigits(newValue);
    }

    public int getMinimumFractionDigits() {
        return this.numberFormat.getMinimumFractionDigits();
    }

    public void setMinimumFractionDigits(int newValue) {
        this.numberFormat.setMinimumFractionDigits(newValue);
    }

    public void setCurrency(Currency theCurrency) {
        this.numberFormat.setCurrency(theCurrency.currency);
    }

    public Currency getCurrency() {
        return new Currency(this.numberFormat.getCurrency());
    }

    public int getRoundingMode() {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public void setRoundingMode(int roundingMode) {
        throw new UnsupportedOperationException("Method not supported by com.ibm.icu.base");
    }

    public static NumberFormat getInstance(ULocale desiredLocale, int choice) {
        Locale locale = desiredLocale.toLocale();
        java.text.NumberFormat nf = null;
        switch (choice) {
            case 0: {
                nf = java.text.NumberFormat.getInstance(locale);
                break;
            }
            case 4: {
                nf = java.text.NumberFormat.getIntegerInstance(locale);
                break;
            }
            case 1: {
                nf = java.text.NumberFormat.getCurrencyInstance(locale);
                break;
            }
            case 2: {
                nf = java.text.NumberFormat.getPercentInstance(locale);
                break;
            }
            case 3: {
                nf = new DecimalFormat("#E0", new DecimalFormatSymbols(locale));
                nf.setMaximumFractionDigits(10);
            }
        }
        return new NumberFormat(nf);
    }

    public NumberFormat() {
        this(java.text.NumberFormat.getInstance(ULocale.getDefault(ULocale.Category.FORMAT).toLocale()));
    }

    private static FieldPosition toJDKFieldPosition(FieldPosition icuPos) {
        if (icuPos == null) {
            return null;
        }
        int fieldID = icuPos.getField();
        Format.Field fieldAttribute = icuPos.getFieldAttribute();
        FieldPosition jdkPos = null;
        if (fieldID >= 0) {
            if (fieldID == 1) {
                fieldID = 1;
            } else if (fieldID == 0) {
                fieldID = 0;
            }
        }
        if (fieldAttribute != null) {
            if (fieldAttribute.equals(Field.CURRENCY)) {
                fieldAttribute = NumberFormat.Field.CURRENCY;
            } else if (fieldAttribute.equals(Field.DECIMAL_SEPARATOR)) {
                fieldAttribute = NumberFormat.Field.DECIMAL_SEPARATOR;
            } else if (fieldAttribute.equals(Field.EXPONENT)) {
                fieldAttribute = NumberFormat.Field.EXPONENT;
            } else if (fieldAttribute.equals(Field.EXPONENT_SIGN)) {
                fieldAttribute = NumberFormat.Field.EXPONENT_SIGN;
            } else if (fieldAttribute.equals(Field.EXPONENT_SYMBOL)) {
                fieldAttribute = NumberFormat.Field.EXPONENT_SYMBOL;
            } else if (fieldAttribute.equals(Field.FRACTION)) {
                fieldAttribute = NumberFormat.Field.FRACTION;
            } else if (fieldAttribute.equals(Field.GROUPING_SEPARATOR)) {
                fieldAttribute = NumberFormat.Field.GROUPING_SEPARATOR;
            } else if (fieldAttribute.equals(Field.INTEGER)) {
                fieldAttribute = NumberFormat.Field.INTEGER;
            } else if (fieldAttribute.equals(Field.PERCENT)) {
                fieldAttribute = NumberFormat.Field.PERCENT;
            } else if (fieldAttribute.equals(Field.PERMILLE)) {
                fieldAttribute = NumberFormat.Field.PERMILLE;
            } else if (fieldAttribute.equals(Field.SIGN)) {
                fieldAttribute = NumberFormat.Field.SIGN;
            }
            jdkPos = new FieldPosition(fieldAttribute, fieldID);
        } else {
            jdkPos = new FieldPosition(fieldID);
        }
        jdkPos.setBeginIndex(icuPos.getBeginIndex());
        jdkPos.setEndIndex(icuPos.getEndIndex());
        return jdkPos;
    }

    public static class Field
    extends Format.Field {
        static final long serialVersionUID = -4516273749929385842L;
        public static final Field SIGN = new Field("sign");
        public static final Field INTEGER = new Field("integer");
        public static final Field FRACTION = new Field("fraction");
        public static final Field EXPONENT = new Field("exponent");
        public static final Field EXPONENT_SIGN = new Field("exponent sign");
        public static final Field EXPONENT_SYMBOL = new Field("exponent symbol");
        public static final Field DECIMAL_SEPARATOR = new Field("decimal separator");
        public static final Field GROUPING_SEPARATOR = new Field("grouping separator");
        public static final Field PERCENT = new Field("percent");
        public static final Field PERMILLE = new Field("per mille");
        public static final Field CURRENCY = new Field("currency");

        protected Field(String fieldName) {
            super(fieldName);
        }

        protected Object readResolve() throws InvalidObjectException {
            if (this.getName().equals(INTEGER.getName())) {
                return INTEGER;
            }
            if (this.getName().equals(FRACTION.getName())) {
                return FRACTION;
            }
            if (this.getName().equals(EXPONENT.getName())) {
                return EXPONENT;
            }
            if (this.getName().equals(EXPONENT_SIGN.getName())) {
                return EXPONENT_SIGN;
            }
            if (this.getName().equals(EXPONENT_SYMBOL.getName())) {
                return EXPONENT_SYMBOL;
            }
            if (this.getName().equals(CURRENCY.getName())) {
                return CURRENCY;
            }
            if (this.getName().equals(DECIMAL_SEPARATOR.getName())) {
                return DECIMAL_SEPARATOR;
            }
            if (this.getName().equals(GROUPING_SEPARATOR.getName())) {
                return GROUPING_SEPARATOR;
            }
            if (this.getName().equals(PERCENT.getName())) {
                return PERCENT;
            }
            if (this.getName().equals(PERMILLE.getName())) {
                return PERMILLE;
            }
            if (this.getName().equals(SIGN.getName())) {
                return SIGN;
            }
            throw new InvalidObjectException("An invalid object.");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class NumberFormatFactory {
        public static final int FORMAT_NUMBER = 0;
        public static final int FORMAT_CURRENCY = 1;
        public static final int FORMAT_PERCENT = 2;
        public static final int FORMAT_SCIENTIFIC = 3;
        public static final int FORMAT_INTEGER = 4;

        public boolean visible() {
            return true;
        }

        public abstract Set<String> getSupportedLocaleNames();

        public NumberFormat createFormat(ULocale loc, int formatType) {
            return this.createFormat(loc.toLocale(), formatType);
        }

        public NumberFormat createFormat(Locale loc, int formatType) {
            return this.createFormat(ULocale.forLocale(loc), formatType);
        }

        protected NumberFormatFactory() {
        }
    }
}

