/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.BufferedGraphicsSource;
import org.eclipse.draw2d.DeferredUpdateManager;
import org.eclipse.draw2d.EventDispatcher;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.NativeGraphicsSource;
import org.eclipse.draw2d.SWTEventDispatcher;
import org.eclipse.draw2d.StackLayout;
import org.eclipse.draw2d.UpdateManager;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.presentations.PresentationUtil;

public class LightweightSystem {
    private Canvas canvas;
    IFigure contents;
    private IFigure root;
    private EventDispatcher dispatcher;
    private UpdateManager manager = new DeferredUpdateManager();
    private int ignoreResize;
    private RAPDragTracker tracker;

    public LightweightSystem(Canvas c) {
        this();
        this.setControl(c);
    }

    public LightweightSystem() {
        this.init();
    }

    protected void addListeners() {
        final EventHandler handler = this.createEventHandler();
        this.canvas.getAccessible().addAccessibleListener((AccessibleListener)handler);
        this.canvas.getAccessible().addAccessibleControlListener((AccessibleControlListener)handler);
        this.canvas.addMouseListener((MouseListener)handler);
        this.canvas.addKeyListener((KeyListener)handler);
        this.canvas.addTraverseListener((TraverseListener)handler);
        this.canvas.addFocusListener((FocusListener)handler);
        this.canvas.addDisposeListener((DisposeListener)handler);
        PresentationUtil.addDragListener((Control)this.canvas, (Listener)handler);
        DragSource dragSource = new DragSource((Control)this.canvas, 7);
        DragSourceListener listener = new DragSourceListener(){

            public void dragStart(DragSourceEvent event) {
                LightweightSystem.this.tracker = new RAPDragTracker(handler, (Widget)LightweightSystem.this.canvas);
                LightweightSystem.this.tracker.open();
            }

            public void dragSetData(DragSourceEvent event) {
            }

            public void dragFinished(DragSourceEvent event) {
                if (LightweightSystem.this.tracker != null) {
                    LightweightSystem.this.tracker.close();
                    LightweightSystem.this.tracker = null;
                }
            }
        };
        dragSource.addDragListener(listener);
        this.canvas.addListener(37, (Listener)handler);
        this.canvas.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                LightweightSystem.this.controlResized();
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                LightweightSystem.this.paint(event.gc);
            }
        });
    }

    protected void controlResized() {
        if (this.ignoreResize > 0) {
            return;
        }
        Rectangle r = new Rectangle(this.canvas.getClientArea());
        r.setLocation(0, 0);
        this.root.setBounds(r);
        this.root.revalidate();
        this.getUpdateManager().performUpdate();
    }

    protected EventDispatcher getEventDispatcher() {
        if (this.dispatcher == null) {
            this.setEventDispatcher(new SWTEventDispatcher());
        }
        return this.dispatcher;
    }

    public IFigure getRootFigure() {
        return this.root;
    }

    protected final EventHandler createEventHandler() {
        return this.internalCreateEventHandler();
    }

    protected RootFigure createRootFigure() {
        RootFigure f = new RootFigure();
        f.addNotify();
        f.setOpaque(true);
        f.setLayoutManager(new StackLayout());
        return f;
    }

    public UpdateManager getUpdateManager() {
        return this.manager;
    }

    protected void init() {
        this.setRootPaneFigure(this.createRootFigure());
    }

    EventHandler internalCreateEventHandler() {
        return new EventHandler();
    }

    public void paint(GC gc) {
        this.getUpdateManager().paint(gc);
    }

    public void setContents(IFigure figure) {
        if (this.contents != null) {
            this.root.remove(this.contents);
        }
        this.contents = figure;
        this.root.add(this.contents);
    }

    public void setControl(Canvas c) {
        if (this.canvas == c) {
            return;
        }
        this.canvas = c;
        if ((c.getStyle() & 0x20000000) != 0) {
            this.getUpdateManager().setGraphicsSource(new NativeGraphicsSource((Control)this.canvas));
        } else {
            this.getUpdateManager().setGraphicsSource(new BufferedGraphicsSource((Control)this.canvas));
        }
        this.getEventDispatcher().setControl((Control)c);
        this.addListeners();
        Rectangle r = new Rectangle(this.canvas.getClientArea());
        r.setLocation(0, 0);
        this.root.setBounds(r);
        this.root.revalidate();
    }

    public void setEventDispatcher(EventDispatcher dispatcher) {
        this.dispatcher = dispatcher;
        dispatcher.setRoot(this.root);
        dispatcher.setControl((Control)this.canvas);
    }

    void setIgnoreResize(boolean value) {
        this.ignoreResize = value ? ++this.ignoreResize : --this.ignoreResize;
    }

    protected void setRootPaneFigure(RootFigure root) {
        this.getUpdateManager().setRoot(root);
        this.root = root;
    }

    public void setUpdateManager(UpdateManager um) {
        this.manager = um;
        this.manager.setRoot(this.root);
    }

    protected class EventHandler
    implements MouseMoveListener,
    MouseListener,
    AccessibleControlListener,
    KeyListener,
    TraverseListener,
    FocusListener,
    AccessibleListener,
    MouseTrackListener,
    Listener,
    DisposeListener {
        protected EventHandler() {
        }

        public void focusGained(FocusEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchFocusGained(e);
        }

        public void focusLost(FocusEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchFocusLost(e);
        }

        public void getChild(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChild(e);
            }
        }

        public void getChildAtPoint(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildAtPoint(e);
            }
        }

        public void getChildCount(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildCount(e);
            }
        }

        public void getChildren(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getChildren(e);
            }
        }

        public void getDefaultAction(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getDefaultAction(e);
            }
        }

        public void getDescription(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getDescription(e);
            }
        }

        public void getFocus(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getFocus(e);
            }
        }

        public void getHelp(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getHelp(e);
            }
        }

        public void getKeyboardShortcut(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getKeyboardShortcut(e);
            }
        }

        public void getLocation(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getLocation(e);
            }
        }

        public void getName(AccessibleEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getName(e);
            }
        }

        public void getRole(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getRole(e);
            }
        }

        public void getSelection(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getSelection(e);
            }
        }

        public void getState(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getState(e);
            }
        }

        public void getValue(AccessibleControlEvent e) {
            EventDispatcher.AccessibilityDispatcher ad = LightweightSystem.this.getEventDispatcher().getAccessibilityDispatcher();
            if (ad != null) {
                ad.getValue(e);
            }
        }

        public void handleEvent(Event event) {
            if (event.type == 37) {
                LightweightSystem.this.getEventDispatcher().dispatchMouseWheelScrolled(event);
            } else if (event.type == 29) {
                MouseEvent me = new MouseEvent(event);
                me.stateMask = 524288;
                LightweightSystem.this.getEventDispatcher().dispatchMouseMoved(me);
            }
        }

        public void keyPressed(KeyEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchKeyPressed(e);
        }

        public void keyReleased(KeyEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchKeyReleased(e);
        }

        public void keyTraversed(TraverseEvent e) {
            e.doit = true;
            LightweightSystem.this.getEventDispatcher().dispatchKeyTraversed(e);
        }

        public void mouseDoubleClick(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseDoubleClicked(e);
        }

        public void mouseDown(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMousePressed(e);
        }

        public void mouseEnter(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseEntered(e);
        }

        public void mouseExit(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseExited(e);
        }

        public void mouseHover(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseHover(e);
        }

        public void mouseMove(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseMoved(e);
        }

        public void mouseUp(MouseEvent e) {
            LightweightSystem.this.getEventDispatcher().dispatchMouseReleased(e);
            if (LightweightSystem.this.tracker != null) {
                LightweightSystem.this.tracker.close();
                LightweightSystem.this.tracker = null;
            }
        }

        public void widgetDisposed(DisposeEvent e) {
            LightweightSystem.this.getUpdateManager().dispose();
        }
    }

    protected class RAPDragTracker {
        public boolean cancelled;
        public boolean tracking;
        private final MouseMoveListener listener;
        private final Widget widget;

        public RAPDragTracker(MouseMoveListener listener, Widget widget) {
            this.listener = listener;
            this.widget = widget;
        }

        public void open() {
            Job dragJob = new Job("Drag-Job"){

                protected IStatus run(IProgressMonitor monitor) {
                    block7: {
                        final Display display = RAPDragTracker.this.widget.getDisplay();
                        RAPDragTracker.this.cancelled = false;
                        RAPDragTracker.this.tracking = true;
                        try {
                            try {
                                long timeout = 0L;
                                long refreshRate = 200L;
                                while (RAPDragTracker.this.tracking && !RAPDragTracker.this.cancelled) {
                                    if (display == null || display.isDisposed()) continue;
                                    display.syncExec(new Runnable(){

                                        public void run() {
                                            if (LightweightSystem.this.canvas.isDisposed()) {
                                                (this).RAPDragTracker.this.tracking = false;
                                                (this).RAPDragTracker.this.cancelled = true;
                                                return;
                                            }
                                            Event ev = new Event();
                                            ev.display = display;
                                            Point loc = LightweightSystem.this.canvas.toControl(display.getCursorLocation());
                                            ev.type = 29;
                                            ev.widget = RAPDragTracker.this.widget;
                                            ev.button = 1;
                                            ev.x = loc.x;
                                            ev.y = loc.y;
                                            MouseEvent me = new MouseEvent(ev);
                                            me.stateMask = 524288;
                                            RAPDragTracker.this.listener.mouseMove(me);
                                        }
                                    });
                                    if ((timeout += refreshRate) >= 60000L) {
                                        RAPDragTracker.this.cancelled = true;
                                    }
                                    Thread.sleep(refreshRate);
                                }
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                                display.syncExec(new Runnable(){

                                    public void run() {
                                        RAPDragTracker.this.close();
                                    }
                                });
                                break block7;
                            }
                        }
                        catch (Throwable throwable) {
                            display.syncExec(new /* invalid duplicate definition of identical inner class */);
                            throw throwable;
                        }
                        display.syncExec(new /* invalid duplicate definition of identical inner class */);
                    }
                    return Status.OK_STATUS;
                }
            };
            dragJob.setSystem(true);
            dragJob.schedule();
        }

        public void close() {
            this.tracking = false;
        }
    }

    protected class RootFigure
    extends Figure {
        protected RootFigure() {
        }

        public Color getBackgroundColor() {
            if (this.bgColor != null) {
                return this.bgColor;
            }
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getBackground();
            }
            return null;
        }

        public Font getFont() {
            if (this.font != null) {
                return this.font;
            }
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getFont();
            }
            return null;
        }

        public Color getForegroundColor() {
            if (this.fgColor != null) {
                return this.fgColor;
            }
            if (LightweightSystem.this.canvas != null) {
                return LightweightSystem.this.canvas.getForeground();
            }
            return null;
        }

        public UpdateManager getUpdateManager() {
            return LightweightSystem.this.getUpdateManager();
        }

        public EventDispatcher internalGetEventDispatcher() {
            return LightweightSystem.this.getEventDispatcher();
        }

        public boolean isMirrored() {
            return (LightweightSystem.this.canvas.getStyle() & 0x8000000) != 0;
        }

        public boolean isShowing() {
            return true;
        }
    }
}

