/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import org.apache.coyote.OutputBuffer;
import org.apache.coyote.Response;
import org.apache.coyote.http11.AbstractOutputBuffer;
import org.apache.coyote.http11.Constants;
import org.apache.coyote.http11.OutputFilter;
import org.apache.tomcat.util.MutableInteger;
import org.apache.tomcat.util.buf.ByteChunk;
import org.apache.tomcat.util.http.HttpMessages;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.NioSelectorPool;

public class InternalNioOutputBuffer
extends AbstractOutputBuffer {
    protected MutableInteger lastWrite = new MutableInteger(1);
    protected NioChannel socket;
    protected NioSelectorPool pool;
    int total = 0;

    public InternalNioOutputBuffer(Response response, int headerBufferSize) {
        this.response = response;
        this.buf = new byte[headerBufferSize];
        this.outputStreamOutputBuffer = new SocketOutputBuffer();
        this.filterLibrary = new OutputFilter[0];
        this.activeFilters = new OutputFilter[0];
        this.lastActiveFilter = -1;
        this.committed = false;
        this.finished = false;
        HttpMessages.getMessage(200);
    }

    public void setSocket(NioChannel socket) {
        this.socket = socket;
    }

    public void setSelectorPool(NioSelectorPool pool) {
        this.pool = pool;
    }

    public NioSelectorPool getSelectorPool() {
        return this.pool;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.flushBuffer();
    }

    @Override
    public void recycle() {
        super.recycle();
        if (this.socket != null) {
            this.socket.getBufHandler().getWriteBuffer().clear();
            this.socket = null;
        }
        this.lastWrite.set(1);
    }

    @Override
    public void endRequest() throws IOException {
        super.endRequest();
        this.flushBuffer();
    }

    @Override
    public void sendAck() throws IOException {
        if (!this.committed) {
            this.socket.getBufHandler().getWriteBuffer().put(Constants.ACK_BYTES, 0, Constants.ACK_BYTES.length);
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, true);
        }
    }

    private synchronized int writeToSocket(ByteBuffer bytebuffer, boolean block, boolean flip) throws IOException {
        if (flip) {
            bytebuffer.flip();
        }
        int written = 0;
        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        if (att == null) {
            throw new IOException("Key must be cancelled");
        }
        long writeTimeout = att.getTimeout();
        Selector selector = null;
        try {
            selector = this.getSelectorPool().get();
        }
        catch (IOException iOException) {}
        try {
            written = this.getSelectorPool().write(bytebuffer, this.socket, selector, writeTimeout, block, this.lastWrite);
            while (!this.socket.flush(true, selector, writeTimeout, this.lastWrite)) {
            }
        }
        finally {
            if (selector != null) {
                this.getSelectorPool().put(selector);
            }
        }
        if (block) {
            bytebuffer.clear();
        }
        this.total = 0;
        return written;
    }

    @Override
    protected void commit() throws IOException {
        this.committed = true;
        this.response.setCommitted(true);
        if (this.pos > 0) {
            this.addToBB(this.buf, 0, this.pos);
        }
    }

    private synchronized void addToBB(byte[] buf, int offset, int length) throws IOException {
        while (length > 0) {
            int thisTime = length;
            if (this.socket.getBufHandler().getWriteBuffer().position() == this.socket.getBufHandler().getWriteBuffer().capacity() || this.socket.getBufHandler().getWriteBuffer().remaining() == 0) {
                this.flushBuffer();
            }
            if (thisTime > this.socket.getBufHandler().getWriteBuffer().remaining()) {
                thisTime = this.socket.getBufHandler().getWriteBuffer().remaining();
            }
            this.socket.getBufHandler().getWriteBuffer().put(buf, offset, thisTime);
            length -= thisTime;
            offset += thisTime;
            this.total += thisTime;
        }
        NioEndpoint.KeyAttachment ka = (NioEndpoint.KeyAttachment)this.socket.getAttachment(false);
        if (ka != null) {
            ka.access();
        }
    }

    protected void flushBuffer() throws IOException {
        SelectionKey key = this.socket.getIOChannel().keyFor(this.socket.getPoller().getSelector());
        if (key != null) {
            NioEndpoint.KeyAttachment attach = (NioEndpoint.KeyAttachment)key.attachment();
            attach.access();
        }
        if (this.socket.getBufHandler().getWriteBuffer().position() > 0) {
            this.socket.getBufHandler().getWriteBuffer().flip();
            this.writeToSocket(this.socket.getBufHandler().getWriteBuffer(), true, false);
        }
    }

    protected class SocketOutputBuffer
    implements OutputBuffer {
        protected SocketOutputBuffer() {
        }

        @Override
        public int doWrite(ByteChunk chunk, Response res) throws IOException {
            int len = chunk.getLength();
            int start = chunk.getStart();
            byte[] b = chunk.getBuffer();
            InternalNioOutputBuffer.this.addToBB(b, start, len);
            InternalNioOutputBuffer.this.byteCount += (long)chunk.getLength();
            return chunk.getLength();
        }

        @Override
        public long getBytesWritten() {
            return InternalNioOutputBuffer.this.byteCount;
        }
    }
}

