/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.valves;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionListener;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleListener;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.comet.CometProcessor;
import org.apache.catalina.connector.CometEventImpl;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;

public class CometConnectionManagerValve
extends ValveBase
implements HttpSessionListener,
LifecycleListener {
    protected static final String info = "org.apache.catalina.valves.CometConnectionManagerValve/1.0";
    protected List<Request> cometRequests = Collections.synchronizedList(new ArrayList());
    protected String cometRequestsAttribute = "org.apache.tomcat.comet.connectionList";

    public CometConnectionManagerValve() {
        super(false);
    }

    @Override
    protected synchronized void startInternal() throws LifecycleException {
        if (this.container instanceof Context) {
            this.container.addLifecycleListener(this);
        }
        this.setState(LifecycleState.STARTING);
    }

    @Override
    protected synchronized void stopInternal() throws LifecycleException {
        this.setState(LifecycleState.STOPPING);
        if (this.container instanceof Context) {
            this.container.removeLifecycleListener(this);
        }
    }

    @Override
    public void lifecycleEvent(LifecycleEvent event) {
        if ("before_stop".equals(event.getType())) {
            for (Request request : this.cometRequests) {
                HttpSession session = request.getSession(false);
                if (session != null) {
                    session.removeAttribute(this.cometRequestsAttribute);
                }
                try {
                    CometEventImpl cometEvent = request.getEvent();
                    cometEvent.setEventType(CometEvent.EventType.END);
                    cometEvent.setEventSubType(CometEvent.EventSubType.WEBAPP_RELOAD);
                    this.getNext().event(request, request.getResponse(), cometEvent);
                    cometEvent.close();
                }
                catch (Exception e) {
                    this.container.getLogger().warn(sm.getString("cometConnectionManagerValve.event"), e);
                }
            }
            this.cometRequests.clear();
        }
    }

    @Override
    public String getInfo() {
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invoke(Request request, Response response) throws IOException, ServletException {
        this.getNext().invoke(request, response);
        if (request.isComet() && !response.isClosed()) {
            HttpSession session = request.getSession(true);
            this.cometRequests.add(request);
            HttpSession httpSession = session;
            synchronized (httpSession) {
                Request[] requests = (Request[])session.getAttribute(this.cometRequestsAttribute);
                if (requests == null) {
                    requests = new Request[]{request};
                    session.setAttribute(this.cometRequestsAttribute, requests);
                } else {
                    Request[] newRequests = new Request[requests.length + 1];
                    int i = 0;
                    while (i < requests.length) {
                        newRequests[i] = requests[i];
                        ++i;
                    }
                    newRequests[requests.length] = request;
                    session.setAttribute(this.cometRequestsAttribute, newRequests);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        boolean ok;
        block36: {
            Throwable throwable2;
            block37: {
                ok = false;
                try {
                    this.getNext().event(request, response, event);
                    ok = true;
                    break block36;
                }
                catch (Throwable throwable2) {
                    if (ok && !response.isClosed() && event.getEventType() != CometEvent.EventType.END && (event.getEventType() != CometEvent.EventType.ERROR || event.getEventSubType() == CometEvent.EventSubType.TIMEOUT)) break block37;
                    this.cometRequests.remove(request);
                    HttpSession session = request.getSession(false);
                    if (session == null) break block37;
                    HttpSession httpSession = session;
                    synchronized (httpSession) {
                        Request[] reqs = null;
                        try {
                            reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                        }
                        catch (IllegalStateException illegalStateException) {}
                        if (reqs != null) {
                            boolean found = false;
                            int i = 0;
                            while (!found && i < reqs.length) {
                                found = reqs[i] == request;
                                ++i;
                            }
                            if (found) {
                                if (reqs.length > 1) {
                                    Request[] newConnectionInfos = new Request[reqs.length - 1];
                                    int pos = 0;
                                    int i2 = 0;
                                    while (i2 < reqs.length) {
                                        if (reqs[i2] != request) {
                                            newConnectionInfos[pos++] = reqs[i2];
                                        }
                                        ++i2;
                                    }
                                    try {
                                        session.setAttribute(this.cometRequestsAttribute, newConnectionInfos);
                                    }
                                    catch (IllegalStateException illegalStateException) {}
                                } else {
                                    try {
                                        session.removeAttribute(this.cometRequestsAttribute);
                                    }
                                    catch (IllegalStateException illegalStateException) {}
                                }
                            }
                        }
                    }
                }
            }
            throw throwable2;
        }
        if (!ok || response.isClosed() || event.getEventType() == CometEvent.EventType.END || event.getEventType() == CometEvent.EventType.ERROR && event.getEventSubType() != CometEvent.EventSubType.TIMEOUT) {
            this.cometRequests.remove(request);
            HttpSession session = request.getSession(false);
            if (session != null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    Request[] reqs = null;
                    try {
                        reqs = (Request[])session.getAttribute(this.cometRequestsAttribute);
                    }
                    catch (IllegalStateException illegalStateException) {}
                    if (reqs != null) {
                        boolean found = false;
                        int i = 0;
                        while (!found && i < reqs.length) {
                            found = reqs[i] == request;
                            ++i;
                        }
                        if (found) {
                            if (reqs.length > 1) {
                                Request[] newConnectionInfos = new Request[reqs.length - 1];
                                int pos = 0;
                                int i3 = 0;
                                while (i3 < reqs.length) {
                                    if (reqs[i3] != request) {
                                        newConnectionInfos[pos++] = reqs[i3];
                                    }
                                    ++i3;
                                }
                                try {
                                    session.setAttribute(this.cometRequestsAttribute, newConnectionInfos);
                                }
                                catch (IllegalStateException illegalStateException) {}
                            } else {
                                try {
                                    session.removeAttribute(this.cometRequestsAttribute);
                                }
                                catch (IllegalStateException illegalStateException) {}
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void sessionCreated(HttpSessionEvent se) {
    }

    @Override
    public void sessionDestroyed(HttpSessionEvent se) {
        Request[] reqs = (Request[])se.getSession().getAttribute(this.cometRequestsAttribute);
        if (reqs != null) {
            int i = 0;
            while (i < reqs.length) {
                Request req = reqs[i];
                try {
                    CometEventImpl event = req.getEvent();
                    event.setEventType(CometEvent.EventType.END);
                    event.setEventSubType(CometEvent.EventSubType.SESSION_END);
                    ((CometProcessor)req.getWrapper().getServlet()).event(event);
                    event.close();
                }
                catch (Exception e) {
                    req.getWrapper().getParent().getLogger().warn(sm.getString("cometConnectionManagerValve.listenerEvent"), e);
                }
                ++i;
            }
        }
    }
}

