/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo;

import java.net.URL;
import java.util.Dictionary;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rap.demo.editor.FooEditorInput;
import org.eclipse.rap.demo.wizard.SurveyWizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class DemoActionBarAdvisor
extends ActionBarAdvisor {
    private IWebBrowser browser;
    private ActionFactory.IWorkbenchAction exitAction;
    private ActionFactory.IWorkbenchAction importAction;
    private ActionFactory.IWorkbenchAction exportAction;
    private Action aboutAction;
    private Action rapWebSiteAction;
    private MenuManager showViewMenuMgr;
    private ActionFactory.IWorkbenchAction preferencesAction;
    private Action wizardAction;
    private Action browserAction;
    public ActionFactory.IWorkbenchAction saveAction;
    private ActionFactory.IWorkbenchAction saveAllAction;
    private Action newEditorAction;
    private static int browserIndex;

    public DemoActionBarAdvisor(IActionBarConfigurer configurer) {
        super(configurer);
    }

    protected void makeActions(final IWorkbenchWindow window) {
        ImageDescriptor quitActionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rap.demo", (String)"icons/ttt.gif");
        ImageDescriptor helpActionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rap.demo", (String)"icons/help.gif");
        ImageDescriptor wizardActionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rap.demo", (String)"icons/login.gif");
        ImageDescriptor browserActionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rap.demo", (String)"icons/internal_browser.gif");
        ImageDescriptor rapWebSiteActionImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.rap.demo", (String)"icons/browser.gif");
        this.exitAction = ActionFactory.QUIT.create(window);
        this.exitAction.setImageDescriptor(quitActionImage);
        this.register((IAction)this.exitAction);
        this.importAction = ActionFactory.IMPORT.create(window);
        this.register((IAction)this.importAction);
        this.exportAction = ActionFactory.EXPORT.create(window);
        this.register((IAction)this.exportAction);
        this.saveAction = ActionFactory.SAVE.create(window);
        this.register((IAction)this.saveAction);
        this.saveAllAction = ActionFactory.SAVE_ALL.create(window);
        this.register((IAction)this.saveAllAction);
        this.preferencesAction = ActionFactory.PREFERENCES.create(window);
        this.register((IAction)this.preferencesAction);
        this.newEditorAction = new Action(){

            public void run() {
                try {
                    window.getActivePage().openEditor((IEditorInput)new FooEditorInput(DemoActionBarAdvisor.this), "org.eclipse.rap.demo.editor", true);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.newEditorAction.setText("Open new editor");
        this.newEditorAction.setId("org.eclipse.rap.demo.neweditor");
        this.newEditorAction.setImageDescriptor(window.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_NEW_WIZARD"));
        this.register((IAction)this.newEditorAction);
        this.aboutAction = new Action(){

            public void run() {
                Shell shell = window.getShell();
                Bundle bundle = Platform.getBundle((String)"org.eclipse.rap.ui");
                Dictionary headers = bundle.getHeaders();
                Object version = headers.get("Bundle-Version");
                MessageDialog.openInformation((Shell)shell, (String)"RAP Workbench Demo", (String)("Running on RAP version " + String.valueOf(version)));
            }
        };
        this.aboutAction.setText("About");
        this.aboutAction.setId("org.eclipse.rap.demo.about");
        this.aboutAction.setImageDescriptor(helpActionImage);
        this.register((IAction)this.aboutAction);
        this.rapWebSiteAction = new Action(){

            public void run() {
                IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
                try {
                    int style = 128;
                    DemoActionBarAdvisor.this.browser = browserSupport.createBrowser(style, DemoActionBarAdvisor.this.rapWebSiteAction.getId(), "", "");
                    DemoActionBarAdvisor.this.browser.openURL(new URL("http://eclipse.org/rap"));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        };
        this.rapWebSiteAction.setText("RAP Home Page");
        this.rapWebSiteAction.setId("org.eclipse.rap.demo.rapWebSite");
        this.rapWebSiteAction.setImageDescriptor(rapWebSiteActionImage);
        this.register((IAction)this.rapWebSiteAction);
        this.showViewMenuMgr = new MenuManager("Show View", "showView");
        IContributionItem showViewMenu = ContributionItemFactory.VIEWS_SHORTLIST.create(window);
        this.showViewMenuMgr.add(showViewMenu);
        this.wizardAction = new Action(){

            public void run() {
                SurveyWizard wizard = new SurveyWizard();
                WizardDialog dlg = new WizardDialog(window.getShell(), (IWizard)wizard);
                dlg.open();
            }
        };
        this.wizardAction.setText("Open wizard");
        this.wizardAction.setId("org.eclipse.rap.demo.wizard");
        this.wizardAction.setImageDescriptor(wizardActionImage);
        this.register((IAction)this.wizardAction);
        this.browserAction = new Action(){

            public void run() {
                ++browserIndex;
                try {
                    window.getActivePage().showView("org.eclipse.rap.demo.DemoBrowserViewPart", String.valueOf(browserIndex), 1);
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
            }
        };
        this.browserAction.setText("Open new Browser View");
        this.browserAction.setId("org.eclipse.rap.demo.browser");
        this.browserAction.setImageDescriptor(browserActionImage);
        this.register((IAction)this.browserAction);
    }

    protected void fillMenuBar(IMenuManager menuBar) {
        MenuManager fileMenu = new MenuManager("File", "file");
        MenuManager windowMenu = new MenuManager("Window", "window");
        MenuManager helpMenu = new MenuManager("Help", "help");
        menuBar.add((IContributionItem)fileMenu);
        fileMenu.add((IAction)this.importAction);
        fileMenu.add((IAction)this.exportAction);
        fileMenu.add((IAction)this.exitAction);
        windowMenu.add((IContributionItem)this.showViewMenuMgr);
        windowMenu.add((IAction)this.preferencesAction);
        menuBar.add((IContributionItem)windowMenu);
        menuBar.add((IContributionItem)helpMenu);
        helpMenu.add((IAction)this.rapWebSiteAction);
        helpMenu.add((IContributionItem)new Separator("about"));
        helpMenu.add((IAction)this.aboutAction);
    }

    protected void fillCoolBar(ICoolBarManager coolBar) {
        this.createToolBar(coolBar, "main");
        this.createToolBar(coolBar, "editor");
    }

    private void createToolBar(ICoolBarManager coolBar, String name) {
        ToolBarManager toolbar = new ToolBarManager(0x820000);
        coolBar.add((IContributionItem)new ToolBarContributionItem((IToolBarManager)toolbar, name));
        if (name != "editor") {
            toolbar.add((IAction)this.wizardAction);
            toolbar.add((IAction)this.browserAction);
            toolbar.add((IAction)this.aboutAction);
            toolbar.add((IAction)this.exitAction);
        } else {
            toolbar.add((IAction)this.newEditorAction);
            toolbar.add((IAction)this.saveAction);
            toolbar.add((IAction)this.saveAllAction);
        }
    }

    protected void fillStatusLine(IStatusLineManager statusLine) {
        statusLine.add((IAction)this.aboutAction);
    }
}

