/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.WorkbenchImages;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.providers.EditorElement;
import org.eclipse.ui.quickaccess.QuickAccessElement;

public class EditorProvider
extends QuickAccessProvider {
    private Map<String, EditorElement> idToElement;

    @Override
    public QuickAccessElement findElement(String id, String filterText) {
        this.getElements();
        return this.idToElement.get(id);
    }

    @Override
    public QuickAccessElement[] getElements() {
        if (this.idToElement == null) {
            this.idToElement = new HashMap<String, EditorElement>();
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            if (activePage == null) {
                return new QuickAccessElement[0];
            }
            IEditorReference[] iEditorReferenceArray = activePage.getEditorReferences();
            int n = iEditorReferenceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editor = iEditorReferenceArray[n2];
                EditorElement editorElement = new EditorElement(editor);
                this.idToElement.put(editorElement.getId(), editorElement);
                ++n2;
            }
        }
        return this.idToElement.values().toArray(new QuickAccessElement[this.idToElement.size()]);
    }

    @Override
    public String getId() {
        return "org.eclipse.ui.editors";
    }

    @Override
    public ImageDescriptor getImageDescriptor() {
        return WorkbenchImages.getImageDescriptor("IMG_OBJ_NODE");
    }

    @Override
    public String getName() {
        return QuickAccessMessages.get().QuickAccess_Editors;
    }

    @Override
    protected void doReset() {
        this.idToElement = null;
    }

    @Override
    public boolean requiresUiAccess() {
        return true;
    }
}

