/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class PreferencesPageContainer
implements IPreferencePageContainer {
    private Composite control;
    private ScrolledComposite scrolled;

    void createContents(Composite parent, int style) {
        this.scrolled = new ScrolledComposite(parent, 768);
        GridData newPageData = new GridData(1808);
        this.scrolled.setLayoutData((Object)newPageData);
        this.control = new Composite((Composite)this.scrolled, style);
        this.scrolled.setContent((Control)this.control);
        this.scrolled.setExpandVertical(true);
        this.scrolled.setExpandHorizontal(true);
        GridData controlData = new GridData(1808);
        this.control.setLayoutData((Object)controlData);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 1;
        this.control.setLayout((Layout)layout);
    }

    Control getControl() {
        return this.control;
    }

    boolean show(IPreferenceNode node) {
        this.createGeneralEntry(node);
        this.control.layout(true);
        return true;
    }

    private void createGeneralEntry(IPreferenceNode node) {
        PreferenceEntry entry = this.createEntry(node, "General", 0);
        entry.addSubNodes();
    }

    private PreferenceEntry createEntry(IPreferenceNode node, String name, int indent) {
        PreferenceEntry entry = new PreferenceEntry(node, name);
        entry.createContents(indent);
        return entry;
    }

    public IPreferenceStore getPreferenceStore() {
        return null;
    }

    public void updateButtons() {
    }

    public void updateMessage() {
    }

    public void updateTitle() {
    }

    private void adjustScrollbars(Point contentSize) {
        Point size = this.control.getSize();
        this.scrolled.setMinHeight(size.y + contentSize.y);
        this.scrolled.setMinWidth(Math.max(size.x, contentSize.x));
    }

    private class PreferenceEntry {
        Composite composite;
        IPreferenceNode node;
        String title;
        int offset;
        Label expandImage;
        Label titleLabel;
        Composite pageContainer;

        PreferenceEntry(IPreferenceNode displayedNode, String pageTitle) {
            this.node = displayedNode;
            this.title = pageTitle;
        }

        private void addSubNodes() {
            IPreferenceNode[] subnodes = this.node.getSubNodes();
            PreferenceEntry previous = null;
            int i = 0;
            while (i < subnodes.length) {
                PreferenceEntry entry = PreferencesPageContainer.this.createEntry(subnodes[i], subnodes[i].getLabelText(), this.offset + 1);
                if (previous == null) {
                    entry.composite.moveBelow((Control)this.composite);
                } else {
                    entry.composite.moveBelow((Control)previous.composite);
                }
                previous = entry;
                ++i;
            }
        }

        void createContents(int indent) {
            this.composite = new Composite(PreferencesPageContainer.this.control, 0);
            GridData gridData = new GridData(768);
            gridData.horizontalIndent = 7 * indent;
            this.composite.setLayoutData((Object)gridData);
            FormLayout layout = new FormLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            Font titleFont = JFaceResources.getBannerFont();
            this.expandImage = new Label(this.composite, 131072);
            this.expandImage.setText("+");
            this.expandImage.setFont(titleFont);
            FormData imageData = new FormData();
            imageData.top = new FormAttachment(0);
            imageData.left = new FormAttachment(0, 4);
            this.expandImage.setLayoutData((Object)imageData);
            this.titleLabel = new Label(this.composite, 16384);
            this.titleLabel.setText(this.title);
            this.titleLabel.setFont(titleFont);
            FormData titleData = new FormData();
            titleData.right = new FormAttachment(100);
            titleData.top = new FormAttachment(0);
            titleData.left = new FormAttachment((Control)this.expandImage, 4);
            this.titleLabel.setLayoutData((Object)titleData);
            this.titleLabel.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent e) {
                    if (PreferenceEntry.this.pageContainer == null) {
                        boolean adjustScrollbars = false;
                        PreferenceEntry.this.pageContainer = new Composite(PreferenceEntry.this.composite, 2048);
                        FormData containerData = new FormData();
                        containerData.top = new FormAttachment((Control)PreferenceEntry.this.titleLabel, 0);
                        containerData.left = new FormAttachment(0);
                        containerData.right = new FormAttachment(100);
                        PreferenceEntry.this.pageContainer.setLayoutData((Object)containerData);
                        PreferenceEntry.this.pageContainer.setLayout((Layout)new GridLayout());
                        PreferenceEntry.this.node.createPage();
                        PreferenceEntry.this.node.getPage().createControl(PreferenceEntry.this.pageContainer);
                        PreferenceEntry.this.node.getPage().setContainer((IPreferencePageContainer)PreferencesPageContainer.this);
                        PreferenceEntry.this.node.getPage().getControl().setLayoutData((Object)new GridData(1808));
                        adjustScrollbars = true;
                        Point contentSize = PreferenceEntry.this.node.getPage().computeSize();
                        Rectangle totalArea = PreferenceEntry.this.composite.getClientArea();
                        if (contentSize.x < totalArea.width) {
                            contentSize.x = totalArea.width;
                        }
                        PreferenceEntry.this.node.getPage().setSize(contentSize);
                        if (adjustScrollbars) {
                            PreferencesPageContainer.this.adjustScrollbars(contentSize);
                        }
                        PreferenceEntry.this.expandImage.setText("-");
                        PreferenceEntry.this.addSubNodes();
                        PreferenceEntry.this.setSelectionColors(PreferenceEntry.this.composite.getDisplay().getSystemColor(29));
                    } else {
                        PreferenceEntry.this.setSelectionColors(null);
                        PreferenceEntry.this.pageContainer.dispose();
                        PreferenceEntry.this.pageContainer = null;
                        PreferenceEntry.this.expandImage.setText("+");
                    }
                    ((PreferenceEntry)PreferenceEntry.this).PreferencesPageContainer.this.control.layout(true);
                }
            });
            this.offset = indent;
        }

        private void setSelectionColors(Color highlight) {
            this.composite.setBackground(highlight);
            this.titleLabel.setBackground(highlight);
            this.expandImage.setBackground(highlight);
        }
    }
}

