/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.browser.browserkit;

import org.eclipse.rap.json.JsonArray;
import org.eclipse.rap.json.JsonObject;
import org.eclipse.rap.json.JsonValue;
import org.eclipse.rap.rwt.internal.lifecycle.ProcessActionRunner;
import org.eclipse.rap.rwt.internal.lifecycle.WidgetUtil;
import org.eclipse.rap.rwt.internal.protocol.ControlOperationHandler;
import org.eclipse.rap.rwt.internal.service.ContextProvider;
import org.eclipse.rap.rwt.internal.service.ServiceStore;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.BrowserFunction;
import org.eclipse.swt.internal.browser.browserkit.BrowserLCA;
import org.eclipse.swt.internal.widgets.IBrowserAdapter;
import org.eclipse.swt.widgets.Event;

public class BrowserOperationHandler
extends ControlOperationHandler<Browser> {
    private static final String METHOD_EXECUTE_FUNCTION = "executeFunction";
    private static final String PARAM_NAME = "name";
    private static final String PARAM_ARGUMENTS = "arguments";
    private static final String METHOD_EVALUATION_SUCCEEDED = "evaluationSucceeded";
    private static final String METHOD_EVALUATION_FAILED = "evaluationFailed";
    private static final String PARAM_RESULT = "result";
    private static final String EVENT_PROGRESS = "Progress";

    public BrowserOperationHandler(Browser browser) {
        super(browser);
    }

    @Override
    public void handleCall(Browser browser, String method, JsonObject properties) {
        if (METHOD_EXECUTE_FUNCTION.equals(method)) {
            this.handleCallExecuteFunction(browser, properties);
        } else if (METHOD_EVALUATION_SUCCEEDED.equals(method)) {
            this.handleCallEvaluationSucceeded(browser, properties);
        } else if (METHOD_EVALUATION_FAILED.equals(method)) {
            this.handleCallEvaluationFailed(browser);
        }
    }

    @Override
    public void handleNotify(Browser browser, String eventName, JsonObject properties) {
        if (EVENT_PROGRESS.equals(eventName)) {
            this.handleNotifyProgress(browser);
        } else {
            super.handleNotify(browser, eventName, properties);
        }
    }

    public void handleCallExecuteFunction(final Browser browser, JsonObject properties) {
        String name = properties.get(PARAM_NAME).asString();
        final BrowserFunction function = BrowserOperationHandler.findBrowserFunction(browser, name);
        if (function != null) {
            final Object[] arguments = BrowserOperationHandler.jsonToJava(properties.get(PARAM_ARGUMENTS).asArray());
            ProcessActionRunner.add(new Runnable(){

                @Override
                public void run() {
                    BrowserOperationHandler.executeFunction(browser, function, arguments);
                }
            });
        }
    }

    public void handleCallEvaluationSucceeded(Browser browser, JsonObject properties) {
        JsonValue value = properties.get(PARAM_RESULT);
        Object result = null;
        if (value != null && !value.isNull()) {
            result = BrowserOperationHandler.jsonToJava(value.asArray())[0];
        }
        BrowserOperationHandler.getAdapter(browser).setExecuteResult(true, result);
    }

    public void handleCallEvaluationFailed(Browser browser) {
        BrowserOperationHandler.getAdapter(browser).setExecuteResult(false, null);
    }

    public void handleNotifyProgress(Browser browser) {
        browser.notifyListeners(5021, new Event());
        browser.notifyListeners(5022, new Event());
    }

    private static BrowserFunction findBrowserFunction(Browser browser, String name) {
        BrowserFunction[] functions;
        BrowserFunction[] browserFunctionArray = functions = BrowserOperationHandler.getAdapter(browser).getBrowserFunctions();
        int n = functions.length;
        int n2 = 0;
        while (n2 < n) {
            BrowserFunction function = browserFunctionArray[n2];
            if (function.getName().equals(name)) {
                return function;
            }
            ++n2;
        }
        return null;
    }

    private static void executeFunction(Browser browser, BrowserFunction function, Object[] arguments) {
        try {
            JsonValue result = BrowserOperationHandler.javaToJson(function.function(arguments));
            BrowserOperationHandler.setExecutedFunctionResult(browser, result);
        }
        catch (Exception exception) {
            BrowserOperationHandler.setExecutedFunctionError(browser, exception.getMessage());
        }
        BrowserOperationHandler.setExecutedFunctionName(browser, function.getName());
    }

    private static void setExecutedFunctionResult(Browser browser, Object result) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_RESULT) + WidgetUtil.getId(browser), result);
    }

    private static void setExecutedFunctionError(Browser browser, String error) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_ERROR) + WidgetUtil.getId(browser), error);
    }

    private static void setExecutedFunctionName(Browser browser, String name) {
        ServiceStore serviceStore = ContextProvider.getServiceStore();
        serviceStore.setAttribute(String.valueOf(BrowserLCA.EXECUTED_FUNCTION_NAME) + WidgetUtil.getId(browser), name);
    }

    static Object jsonToJava(JsonValue value) {
        Object[] result;
        if (value.isNull()) {
            result = null;
        } else if (value.isBoolean()) {
            result = value.asBoolean();
        } else if (value.isNumber()) {
            result = value.asDouble();
        } else if (value.isString()) {
            result = value.asString();
        } else if (value.isArray()) {
            result = BrowserOperationHandler.jsonToJava(value.asArray());
        } else {
            throw new RuntimeException("Unable to convert JsonValue to Java: " + value);
        }
        return result;
    }

    private static Object[] jsonToJava(JsonArray value) {
        Object[] result = new Object[value.size()];
        int i = 0;
        while (i < result.length) {
            result[i] = BrowserOperationHandler.jsonToJava(value.get(i));
            ++i;
        }
        return result;
    }

    static JsonValue javaToJson(Object value) {
        if (value == null) {
            return JsonValue.NULL;
        }
        if (value instanceof String) {
            return JsonValue.valueOf((String)value);
        }
        if (value instanceof Number) {
            return JsonValue.valueOf(((Number)value).doubleValue());
        }
        if (value instanceof Boolean) {
            return JsonValue.valueOf((Boolean)value);
        }
        if (value instanceof Object[]) {
            return BrowserOperationHandler.javaToJson((Object[])value);
        }
        SWT.error(51);
        return null;
    }

    private static JsonValue javaToJson(Object[] array) {
        JsonArray jsonArray = new JsonArray();
        int i = 0;
        while (i < array.length) {
            jsonArray.add(BrowserOperationHandler.javaToJson(array[i]));
            ++i;
        }
        return jsonArray;
    }

    private static IBrowserAdapter getAdapter(Browser browser) {
        return browser.getAdapter(IBrowserAdapter.class);
    }
}

