/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.registry.osgi;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.SAXParserFactory;
import org.eclipse.core.internal.registry.ExtensionRegistry;
import org.eclipse.core.internal.registry.ReferenceMap;
import org.eclipse.core.internal.registry.RegistryMessages;
import org.eclipse.core.internal.registry.RegistryProperties;
import org.eclipse.core.internal.registry.RegistryTimestamp;
import org.eclipse.core.internal.registry.osgi.Activator;
import org.eclipse.core.internal.registry.osgi.EclipseBundleListener;
import org.eclipse.core.internal.registry.osgi.OSGIUtils;
import org.eclipse.core.internal.runtime.ResourceTranslator;
import org.eclipse.core.runtime.ContributorFactoryOSGi;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IContributor;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.spi.RegistryContributor;
import org.eclipse.core.runtime.spi.RegistryStrategy;
import org.eclipse.osgi.service.localization.LocaleProvider;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleListener;
import org.osgi.util.tracker.ServiceTracker;

public class RegistryStrategyOSGI
extends RegistryStrategy {
    private final Object token;
    protected boolean DEBUG;
    protected boolean DEBUG_REGISTRY_EVENTS;
    private ServiceTracker<?, ?> xmlTracker = null;
    private ServiceTracker<?, ?> localeTracker = null;
    private boolean trackTimestamp;
    private static float DEFAULT_BUNDLECACHE_LOADFACTOR = 0.75f;
    private static int DEFAULT_BUNDLECACHE_SIZE = 200;
    private final ReferenceMap bundleMap = new ReferenceMap(1, DEFAULT_BUNDLECACHE_SIZE, DEFAULT_BUNDLECACHE_LOADFACTOR);
    private final ReadWriteLock bundleMapLock = new ReentrantReadWriteLock();
    private EclipseBundleListener pluginBundleListener = null;

    public RegistryStrategyOSGI(File[] theStorageDir, boolean[] cacheReadOnly, Object key) {
        super(theStorageDir, cacheReadOnly);
        this.token = key;
        BundleContext context = Activator.getContext();
        this.trackTimestamp = context != null ? "true".equalsIgnoreCase(context.getProperty("osgi.checkConfiguration")) : false;
    }

    @Override
    public final String translate(String key, ResourceBundle resources) {
        return ResourceTranslator.getResourceString(null, (String)key, (ResourceBundle)resources);
    }

    @Override
    public String[] translate(String[] nonTranslated, IContributor contributor, String locale) {
        return ResourceTranslator.getResourceString((Bundle)ContributorFactoryOSGi.resolve(contributor), (String[])nonTranslated, (String)locale);
    }

    private Bundle getBundle(String id) {
        Bundle bundle;
        long OSGiId;
        if (id == null) {
            return null;
        }
        try {
            OSGiId = Long.parseLong(id);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        this.bundleMapLock.readLock().lock();
        try {
            bundle = (Bundle)this.bundleMap.get((int)OSGiId);
        }
        finally {
            this.bundleMapLock.readLock().unlock();
        }
        if (bundle != null) {
            return bundle;
        }
        bundle = Activator.getContext().getBundle(OSGiId);
        this.bundleMapLock.writeLock().lock();
        try {
            this.bundleMap.put((int)OSGiId, bundle);
        }
        finally {
            this.bundleMapLock.writeLock().unlock();
        }
        return bundle;
    }

    @Override
    public Object createExecutableExtension(RegistryContributor contributor, String className, String overridenContributorName) throws CoreException {
        Bundle contributingBundle = overridenContributorName != null && !overridenContributorName.equals("") ? OSGIUtils.getDefault().getBundle(overridenContributorName) : this.getBundle(contributor.getId());
        if (contributingBundle == null) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)"UNKNOWN BUNDLE", (Object)className), new InvalidRegistryObjectException());
        }
        Class classInstance = null;
        try {
            classInstance = contributingBundle.loadClass(className);
        }
        catch (Exception e1) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e1);
        }
        catch (LinkageError e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_loadClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e);
        }
        Object result = null;
        try {
            result = classInstance.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e);
        }
        catch (LinkageError e1) {
            this.throwException(NLS.bind((String)RegistryMessages.plugin_instantiateClassError, (Object)contributingBundle.getSymbolicName(), (Object)className), e1);
        }
        return result;
    }

    private void throwException(String message, Throwable exception) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "org.eclipse.equinox.registry", 1, message, exception));
    }

    @Override
    public void onStart(IExtensionRegistry registry, boolean loadedFromCache) {
        super.onStart(registry, loadedFromCache);
        if (!(registry instanceof ExtensionRegistry)) {
            return;
        }
        this.pluginBundleListener = new EclipseBundleListener((ExtensionRegistry)registry, this.token, this);
        Activator.getContext().addBundleListener((BundleListener)this.pluginBundleListener);
        if (!loadedFromCache) {
            this.pluginBundleListener.processBundles(Activator.getContext().getBundles());
        }
    }

    @Override
    public void onStop(IExtensionRegistry registry) {
        if (this.pluginBundleListener != null) {
            Activator.getContext().removeBundleListener((BundleListener)this.pluginBundleListener);
        }
        if (this.xmlTracker != null) {
            this.xmlTracker.close();
            this.xmlTracker = null;
        }
        if (this.localeTracker != null) {
            this.localeTracker.close();
            this.localeTracker = null;
        }
        super.onStop(registry);
    }

    @Override
    public boolean cacheUse() {
        return !"true".equals(RegistryProperties.getProperty("eclipse.noRegistryCache"));
    }

    @Override
    public boolean cacheLazyLoading() {
        return !"true".equalsIgnoreCase(RegistryProperties.getProperty("eclipse.noLazyRegistryCacheLoading"));
    }

    @Override
    public long getContributionsTimestamp() {
        if (!this.checkContributionsTimestamp()) {
            return 0L;
        }
        RegistryTimestamp expectedTimestamp = new RegistryTimestamp();
        BundleContext context = Activator.getContext();
        Bundle[] allBundles = context.getBundles();
        int i = 0;
        while (i < allBundles.length) {
            URL pluginManifest = EclipseBundleListener.getExtensionURL(allBundles[i], false);
            if (pluginManifest != null) {
                long timestamp = this.getExtendedTimestamp(allBundles[i], pluginManifest);
                expectedTimestamp.add(timestamp);
            }
            ++i;
        }
        return expectedTimestamp.getContentsTimestamp();
    }

    public boolean checkContributionsTimestamp() {
        return this.trackTimestamp;
    }

    public long getExtendedTimestamp(Bundle bundle, URL pluginManifest) {
        if (pluginManifest == null) {
            return 0L;
        }
        try {
            return pluginManifest.openConnection().getLastModified() + bundle.getBundleId();
        }
        catch (IOException e) {
            if (this.debug()) {
                System.out.println("Unable to obtain timestamp for the bundle " + bundle.getSymbolicName());
                e.printStackTrace();
            }
            return 0L;
        }
    }

    @Override
    public SAXParserFactory getXMLParser() {
        if (this.xmlTracker == null) {
            this.xmlTracker = new ServiceTracker(Activator.getContext(), SAXParserFactory.class.getName(), null);
            this.xmlTracker.open();
        }
        return (SAXParserFactory)this.xmlTracker.getService();
    }

    @Override
    public String getLocale() {
        Locale currentLocale;
        LocaleProvider localeProvider;
        if (this.localeTracker == null) {
            this.localeTracker = new ServiceTracker(Activator.getContext(), LocaleProvider.class.getName(), null);
            this.localeTracker.open();
        }
        if ((localeProvider = (LocaleProvider)this.localeTracker.getService()) != null && (currentLocale = localeProvider.getLocale()) != null) {
            return currentLocale.toString();
        }
        return super.getLocale();
    }
}

