/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpSessionIdListener;
import org.eclipse.equinox.http.jetty.JettyCustomizer;
import org.eclipse.equinox.http.jetty.internal.Details;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.session.SessionHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.eclipse.jetty.util.thread.QueuedThreadPool;
import org.eclipse.jetty.util.thread.ThreadPool;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class HttpServerManager
implements ManagedServiceFactory {
    private static final int DEFAULT_IDLE_TIMEOUT = 30000;
    private static final String CONTEXT_TEMPDIR = "javax.servlet.context.tempdir";
    private static final String DIR_PREFIX = "pid_";
    private static final String INTERNAL_CONTEXT_CLASSLOADER = "org.eclipse.equinox.http.jetty.internal.ContextClassLoader";
    private Map<String, Server> servers = new HashMap<String, Server>();
    private File workDir;

    public HttpServerManager(File workDir) {
        this.workDir = workDir;
    }

    public synchronized void deleted(String pid) {
        Server server = this.servers.remove(pid);
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File contextWorkDir = new File(this.workDir, DIR_PREFIX + pid.hashCode());
            HttpServerManager.deleteDirectory(contextWorkDir);
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public synchronized void updated(String pid, Dictionary<String, ?> dictionary) throws ConfigurationException {
        String otherInfo;
        String host;
        int port;
        this.deleted(pid);
        Server server = new Server((ThreadPool)new QueuedThreadPool(Details.getInt(dictionary, "http.maxThreads", 200), Details.getInt(dictionary, "http.minThreads", 8)));
        JettyCustomizer customizer = this.createJettyCustomizer(dictionary);
        HttpConfiguration http_config = new HttpConfiguration();
        ServerConnector httpConnector = this.createHttpConnector(dictionary, server, http_config);
        ServerConnector httpsConnector = this.createHttpsConnector(dictionary, server, http_config);
        if (customizer != null) {
            httpConnector = (ServerConnector)customizer.customizeHttpConnector(httpConnector, dictionary);
        }
        if (httpConnector != null) {
            try {
                httpConnector.open();
            }
            catch (IOException e) {
                throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
            }
            server.addConnector((Connector)httpConnector);
        }
        if (customizer != null) {
            httpsConnector = (ServerConnector)customizer.customizeHttpsConnector(httpsConnector, dictionary);
        }
        if (httpsConnector != null) {
            try {
                httpsConnector.open();
            }
            catch (IOException e) {
                throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
            }
            server.addConnector((Connector)httpsConnector);
        }
        ServletHolder holder = new ServletHolder((Servlet)new InternalHttpServiceServlet());
        holder.setInitOrder(0);
        holder.setInitParameter("service.vendor", "Eclipse.org");
        holder.setInitParameter("service.description", "Equinox Jetty-based Http Service");
        String multipartServletName = "Equinox Jetty-based Http Service - Multipart Servlet";
        holder.setInitParameter("multipart.servlet.name", multipartServletName);
        if (httpConnector != null) {
            port = httpConnector.getLocalPort();
            if (port == -1) {
                port = httpConnector.getPort();
            }
            holder.setInitParameter("http.port", Integer.toString(port));
            host = httpConnector.getHost();
            if (host != null) {
                holder.setInitParameter("http.host", host);
            }
        }
        if (httpsConnector != null) {
            port = httpsConnector.getLocalPort();
            if (port == -1) {
                port = httpsConnector.getPort();
            }
            holder.setInitParameter("https.port", Integer.toString(port));
            host = httpConnector.getHost();
            if (host != null) {
                holder.setInitParameter("https.host", host);
            }
        }
        if ((otherInfo = Details.getString(dictionary, "other.info", null)) != null) {
            holder.setInitParameter("other.info", otherInfo);
        }
        ServletContextHandler httpContext = this.createHttpContext(dictionary);
        holder.setInitParameter("context.path", httpContext.getContextPath());
        httpContext.addServlet(holder, "/*");
        server.setHandler((Handler)httpContext);
        if (customizer != null) {
            httpContext = (ServletContextHandler)customizer.customizeContext(httpContext, dictionary);
        }
        SessionHandler sessionManager = httpContext.getSessionHandler();
        try {
            sessionManager.addEventListener((EventListener)((HttpSessionIdListener)holder.getServlet()));
        }
        catch (ServletException e) {
            throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
        }
        try {
            server.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
        }
        this.servers.put(pid, server);
    }

    private ServerConnector createHttpsConnector(Dictionary dictionary, Server server, HttpConfiguration http_config) {
        ServerConnector httpsConnector = null;
        if (Details.getBoolean(dictionary, "https.enabled", false)) {
            SslContextFactory sslContextFactory = new SslContextFactory();
            sslContextFactory.setKeyStorePath(Details.getString(dictionary, "ssl.keystore", null));
            sslContextFactory.setKeyStorePassword(Details.getString(dictionary, "ssl.password", null));
            sslContextFactory.setKeyManagerPassword(Details.getString(dictionary, "ssl.keypassword", null));
            sslContextFactory.setKeyStoreType(Details.getString(dictionary, "ssl.keystoretype", "JKS"));
            sslContextFactory.setProtocol(Details.getString(dictionary, "ssl.protocol", "TLS"));
            sslContextFactory.setWantClientAuth(Details.getBoolean(dictionary, "ssl.wantclientauth", false));
            sslContextFactory.setNeedClientAuth(Details.getBoolean(dictionary, "ssl.needclientauth", false));
            HttpConfiguration https_config = new HttpConfiguration(http_config);
            https_config.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
            httpsConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory(sslContextFactory, "http/1.1"), new HttpConnectionFactory(https_config)});
            httpsConnector.setPort(Details.getInt(dictionary, "https.port", 443));
        }
        return httpsConnector;
    }

    private ServerConnector createHttpConnector(Dictionary dictionary, Server server, HttpConfiguration http_config) {
        ServerConnector httpConnector = null;
        if (Details.getBoolean(dictionary, "http.enabled", true)) {
            if (Details.getBoolean(dictionary, "https.enabled", false)) {
                http_config.setSecureScheme("https");
                http_config.setSecurePort(Details.getInt(dictionary, "https.port", 443));
            }
            httpConnector = new ServerConnector(server, new ConnectionFactory[]{new HttpConnectionFactory(http_config)});
            httpConnector.setPort(Details.getInt(dictionary, "http.port", 80));
            httpConnector.setHost(Details.getString(dictionary, "http.host", null));
            httpConnector.setIdleTimeout(30000L);
        }
        return httpConnector;
    }

    public synchronized void shutdown() throws Exception {
        for (Server server : this.servers.values()) {
            server.stop();
        }
        this.servers.clear();
    }

    private ServletContextHandler createHttpContext(Dictionary dictionary) {
        ServletContextHandler httpContext = new ServletContextHandler();
        httpContext.getMimeTypes().addMimeMapping("xsd", "application/xml");
        httpContext.setAttribute(INTERNAL_CONTEXT_CLASSLOADER, (Object)Thread.currentThread().getContextClassLoader());
        httpContext.setClassLoader(this.getClass().getClassLoader());
        httpContext.setContextPath(Details.getString(dictionary, "context.path", "/"));
        File contextWorkDir = new File(this.workDir, DIR_PREFIX + dictionary.get("service.pid").hashCode());
        contextWorkDir.mkdir();
        httpContext.setAttribute(CONTEXT_TEMPDIR, (Object)contextWorkDir);
        SessionHandler handler = new SessionHandler();
        handler.setMaxInactiveInterval(Details.getInt(dictionary, "context.sessioninactiveinterval", -1));
        httpContext.setSessionHandler(handler);
        return httpContext;
    }

    private JettyCustomizer createJettyCustomizer(Dictionary dictionary) {
        String customizerClass = (String)dictionary.get("customizer.class");
        if (customizerClass == null) {
            return null;
        }
        try {
            return (JettyCustomizer)Class.forName(customizerClass).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    HttpServerManager.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public static class InternalHttpServiceServlet
    implements HttpSessionIdListener,
    Servlet {
        private Servlet httpServiceServlet = new HttpServiceServlet();
        private ClassLoader contextLoader;
        private Method method;

        public void init(ServletConfig config) throws ServletException {
            ServletContext context = config.getServletContext();
            this.contextLoader = (ClassLoader)context.getAttribute(HttpServerManager.INTERNAL_CONTEXT_CLASSLOADER);
            Class<?> clazz = this.httpServiceServlet.getClass();
            try {
                this.method = clazz.getMethod("sessionIdChanged", String.class);
            }
            catch (Exception e) {
                throw new ServletException((Throwable)e);
            }
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.init(config);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public void destroy() {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.destroy();
            }
            finally {
                thread.setContextClassLoader(current);
            }
            this.contextLoader = null;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.service(req, res);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public ServletConfig getServletConfig() {
            return this.httpServiceServlet.getServletConfig();
        }

        public String getServletInfo() {
            return this.httpServiceServlet.getServletInfo();
        }

        /*
         * Loose catch block
         */
        public void sessionIdChanged(HttpSessionEvent event, String oldSessionId) {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                try {
                    this.method.invoke((Object)this.httpServiceServlet, oldSessionId);
                }
                catch (IllegalAccessException illegalAccessException) {
                    thread.setContextClassLoader(current);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    thread.setContextClassLoader(current);
                }
                catch (InvocationTargetException e) {
                    throw new RuntimeException(e.getCause());
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }
    }
}

