/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.servlet.internal.servlet;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.equinox.http.servlet.RangeAwareServletContextHelper;
import org.eclipse.equinox.http.servlet.internal.servlet.HttpServletRequestWrapperImpl;
import org.osgi.service.http.context.ServletContextHelper;

public class ResourceServlet
extends HttpServlet {
    private static final long serialVersionUID = 3586876493076122102L;
    private static final String LAST_MODIFIED = "Last-Modified";
    private static final String IF_MODIFIED_SINCE = "If-Modified-Since";
    private static final String IF_NONE_MATCH = "If-None-Match";
    private static final String ETAG = "ETag";
    private static final String RANGE = "Range";
    private static final String ACCEPT_RANGES = "Accept-Ranges";
    private static final String RANGE_UNIT_BYTES = "bytes";
    private static final String CONTENT_RANGE = "Content-Range";
    private final String internalName;
    final ServletContextHelper servletContextHelper;
    private final AccessControlContext acc;

    public ResourceServlet(String internalName, ServletContextHelper servletContextHelper, AccessControlContext acc) {
        if (internalName.equals("/")) {
            internalName = "";
        }
        this.internalName = internalName;
        this.servletContextHelper = servletContextHelper;
        this.acc = acc;
    }

    public void service(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String method = req.getMethod();
        if (method.equals("GET") || method.equals("POST") || method.equals("HEAD")) {
            String resourcePath;
            URL resourceURL;
            String pathInfo = HttpServletRequestWrapperImpl.getDispatchPathInfo(req);
            if (pathInfo == null) {
                pathInfo = "";
            }
            if ((resourceURL = this.servletContextHelper.getResource(resourcePath = String.valueOf(this.internalName) + pathInfo)) != null) {
                this.writeResource(req, resp, resourcePath, resourceURL);
            } else {
                resp.sendError(404, "ProxyServlet: " + req.getRequestURI());
            }
        } else {
            resp.setStatus(405);
        }
    }

    private void writeResource(final HttpServletRequest req, final HttpServletResponse resp, final String resourcePath, final URL resourceURL) throws IOException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Boolean>(){

                @Override
                public Boolean run() throws Exception {
                    String filename;
                    String contentType;
                    String ifNoneMatch;
                    URLConnection connection = resourceURL.openConnection();
                    long lastModified = connection.getLastModified();
                    int contentLength = connection.getContentLength();
                    String etag = null;
                    if (lastModified != -1L && contentLength != -1) {
                        etag = "W/\"" + contentLength + "-" + lastModified + "\"";
                    }
                    if ((ifNoneMatch = req.getHeader(ResourceServlet.IF_NONE_MATCH)) != null && etag != null && ifNoneMatch.indexOf(etag) != -1) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    long ifModifiedSince = req.getDateHeader(ResourceServlet.IF_MODIFIED_SINCE);
                    if (ifModifiedSince > -1L && lastModified > 0L && lastModified <= ifModifiedSince + 999L) {
                        resp.setStatus(304);
                        return Boolean.TRUE;
                    }
                    String rangeHeader = req.getHeader(ResourceServlet.RANGE);
                    Range range = null;
                    if (rangeHeader != null) {
                        range = Range.createFromRangeHeader(rangeHeader);
                        range.completeLength = contentLength;
                        range.updateBytePos();
                        if (!range.isValid()) {
                            resp.setHeader(ResourceServlet.ACCEPT_RANGES, ResourceServlet.RANGE_UNIT_BYTES);
                            resp.setStatus(416);
                            return Boolean.TRUE;
                        }
                    }
                    if (contentLength != -1) {
                        resp.setContentLength(contentLength);
                    }
                    if ((contentType = ResourceServlet.this.servletContextHelper.getMimeType(filename = new File(resourcePath).getName())) == null) {
                        contentType = ResourceServlet.this.getServletConfig().getServletContext().getMimeType(filename);
                    }
                    if (contentType != null) {
                        resp.setContentType(contentType);
                    }
                    if (lastModified > 0L) {
                        resp.setDateHeader(ResourceServlet.LAST_MODIFIED, lastModified);
                    }
                    if (etag != null) {
                        resp.setHeader(ResourceServlet.ETAG, etag);
                    }
                    if (range == null && ResourceServlet.this.servletContextHelper instanceof RangeAwareServletContextHelper && ((RangeAwareServletContextHelper)ResourceServlet.this.servletContextHelper).rangeableContentType(contentType, req.getHeader("User-Agent"))) {
                        range = new Range();
                        range.firstBytePos = 0;
                        range.completeLength = contentLength;
                        range.updateBytePos();
                    }
                    if (range != null) {
                        resp.setStatus(206);
                        resp.setHeader(ResourceServlet.ACCEPT_RANGES, ResourceServlet.RANGE_UNIT_BYTES);
                        resp.setContentLength(range.contentLength());
                        resp.setHeader(ResourceServlet.CONTENT_RANGE, "bytes " + range.firstBytePos + "-" + range.lastBytePos + "/" + range.completeLength);
                    }
                    if (contentLength != 0) {
                        try {
                            Throwable throwable = null;
                            Object var14_13 = null;
                            try (InputStream is = connection.getInputStream();){
                                try {
                                    ServletOutputStream os = resp.getOutputStream();
                                    int writtenContentLength = ResourceServlet.this.writeResourceToOutputStream(is, (OutputStream)os, range);
                                    if (contentLength == -1 || contentLength != writtenContentLength) {
                                        resp.setContentLength(writtenContentLength);
                                    }
                                }
                                catch (IllegalStateException illegalStateException) {
                                    PrintWriter writer = resp.getWriter();
                                    ResourceServlet.this.writeResourceToWriter(is, writer, range);
                                }
                            }
                            catch (Throwable throwable2) {
                                if (throwable == null) {
                                    throwable = throwable2;
                                } else if (throwable != throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                        }
                        catch (FileNotFoundException | SecurityException exception) {
                            ResourceServlet.this.sendError(resp, 403);
                        }
                    }
                    return Boolean.TRUE;
                }
            }, this.acc);
        }
        catch (PrivilegedActionException e) {
            throw (IOException)e.getException();
        }
    }

    void sendError(HttpServletResponse resp, int sc) throws IOException {
        try {
            resp.reset();
            resp.sendError(sc);
        }
        catch (IllegalStateException illegalStateException) {}
    }

    int writeResourceToOutputStream(InputStream is, OutputStream os, Range range) throws IOException {
        if (range != null) {
            if (range.firstBytePos != -1) {
                is.skip(range.firstBytePos);
            } else {
                is.skip(range.completeLength - range.lastBytePos);
            }
        }
        byte[] buffer = new byte[8192];
        int bytesRead = is.read(buffer);
        int writtenContentLength = 0;
        while (bytesRead != -1 && (range == null || range.lastBytePos == -1 || writtenContentLength < range.lastBytePos)) {
            if (range != null && range.lastBytePos != -1 && bytesRead + writtenContentLength > range.lastBytePos) {
                bytesRead = range.contentLength() - writtenContentLength;
            }
            os.write(buffer, 0, bytesRead);
            writtenContentLength += bytesRead;
            bytesRead = is.read(buffer);
        }
        return writtenContentLength;
    }

    void writeResourceToWriter(InputStream is, Writer writer, Range range) throws IOException {
        if (range != null) {
            if (range.firstBytePos != -1) {
                is.skip(range.firstBytePos);
            } else {
                is.skip(range.completeLength - range.lastBytePos);
            }
        }
        Throwable throwable = null;
        Object var5_6 = null;
        try (InputStreamReader reader = new InputStreamReader(is);){
            char[] buffer = new char[8192];
            int charsRead = reader.read(buffer);
            int writtenContentLength = 0;
            while (charsRead != -1 && (range == null || range.lastBytePos == -1 || writtenContentLength < range.lastBytePos)) {
                if (range != null && range.lastBytePos != -1 && charsRead + writtenContentLength > range.lastBytePos) {
                    charsRead = range.contentLength() - writtenContentLength;
                }
                writer.write(buffer, 0, charsRead);
                writtenContentLength += charsRead;
                charsRead = reader.read(buffer);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    static class Range {
        private static final Pattern RANGE_PATTERN = Pattern.compile("^(.+)=(\\d+)?-(\\d+)?$");
        static final int NOT_SET = -1;
        String rangeUnit = "bytes";
        int firstBytePos = -1;
        int lastBytePos = -1;
        int completeLength = -1;

        Range() {
        }

        static Range createFromRangeHeader(String header) {
            Range range = new Range();
            Matcher matcher = RANGE_PATTERN.matcher(header);
            if (!matcher.matches()) {
                return range;
            }
            range.rangeUnit = matcher.group(1);
            if (matcher.group(2) != null) {
                try {
                    range.firstBytePos = Integer.parseInt(matcher.group(2));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            if (matcher.group(3) != null) {
                try {
                    range.lastBytePos = Integer.parseInt(matcher.group(3));
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return range;
        }

        void updateBytePos() {
            if (this.lastBytePos == -1 || this.lastBytePos >= this.completeLength) {
                this.lastBytePos = this.completeLength - 1;
            }
            if (this.firstBytePos == -1) {
                this.firstBytePos = this.completeLength - this.lastBytePos - 1;
                this.lastBytePos = this.completeLength - 1;
            }
        }

        boolean isValid() {
            if (!ResourceServlet.RANGE_UNIT_BYTES.equals(this.rangeUnit)) {
                return false;
            }
            if (this.firstBytePos == -1 && this.lastBytePos == -1) {
                return false;
            }
            if (this.firstBytePos >= this.completeLength) {
                return false;
            }
            return this.lastBytePos < this.completeLength;
        }

        int contentLength() {
            return this.lastBytePos - this.firstBytePos + 1;
        }
    }
}

