/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.axes;

import org.apache.commons.jxpath.Pointer;
import org.apache.commons.jxpath.ri.EvalContext;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;

public class ChildContext
extends EvalContext {
    private NodeTest nodeTest;
    private boolean startFromParentLocation;
    private boolean reverse;
    private NodeIterator iterator;

    public ChildContext(EvalContext parentContext, NodeTest nodeTest, boolean startFromParentLocation, boolean reverse) {
        super(parentContext);
        this.nodeTest = nodeTest;
        this.startFromParentLocation = startFromParentLocation;
        this.reverse = reverse;
    }

    public NodePointer getCurrentNodePointer() {
        if (this.position == 0 && !this.setPosition(1)) {
            return null;
        }
        return this.iterator == null ? null : this.iterator.getNodePointer();
    }

    public Pointer getSingleNodePointer() {
        if (this.position == 0) {
            while (this.nextSet()) {
                this.prepare();
                if (this.iterator == null) {
                    return null;
                }
                NodePointer pointer = this.iterator.getNodePointer();
                if (pointer == null) continue;
                return pointer;
            }
            return null;
        }
        return this.getCurrentNodePointer();
    }

    public boolean nextNode() {
        return this.setPosition(this.getCurrentPosition() + 1);
    }

    public void reset() {
        super.reset();
        this.iterator = null;
    }

    public boolean setPosition(int position) {
        int oldPosition = this.getCurrentPosition();
        super.setPosition(position);
        if (oldPosition == 0) {
            this.prepare();
        }
        return this.iterator == null ? false : this.iterator.setPosition(position);
    }

    private void prepare() {
        NodePointer parent = this.parentContext.getCurrentNodePointer();
        if (parent == null) {
            return;
        }
        NodePointer useParent = this.startFromParentLocation ? parent.getParent() : parent;
        this.iterator = useParent.childIterator(this.nodeTest, this.reverse, this.startFromParentLocation ? parent : null);
    }
}

