/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.contexts;

import java.util.Set;
import org.eclipse.ui.contexts.IContextManager;
import org.eclipse.ui.internal.util.Util;

public final class ContextManagerEvent {
    private final IContextManager contextManager;
    private final boolean definedContextIdsChanged;
    private final boolean enabledContextIdsChanged;
    private final Set previouslyDefinedContextIds;
    private final Set previouslyEnabledContextIds;

    public ContextManagerEvent(IContextManager contextManager, boolean definedContextIdsChanged, boolean enabledContextIdsChanged, Set previouslyDefinedContextIds, Set previouslyEnabledContextIds) {
        if (contextManager == null) {
            throw new NullPointerException();
        }
        if (!definedContextIdsChanged && previouslyDefinedContextIds != null) {
            throw new IllegalArgumentException();
        }
        if (!enabledContextIdsChanged && previouslyEnabledContextIds != null) {
            throw new IllegalArgumentException();
        }
        this.previouslyDefinedContextIds = definedContextIdsChanged ? Util.safeCopy(previouslyDefinedContextIds, String.class) : null;
        this.previouslyEnabledContextIds = enabledContextIdsChanged ? Util.safeCopy(previouslyEnabledContextIds, String.class) : null;
        this.contextManager = contextManager;
        this.definedContextIdsChanged = definedContextIdsChanged;
        this.enabledContextIdsChanged = enabledContextIdsChanged;
    }

    public IContextManager getContextManager() {
        return this.contextManager;
    }

    public Set getPreviouslyDefinedContextIds() {
        return this.previouslyDefinedContextIds;
    }

    public Set getPreviouslyEnabledContextIds() {
        return this.previouslyEnabledContextIds;
    }

    public boolean haveDefinedContextIdsChanged() {
        return this.definedContextIdsChanged;
    }

    public boolean haveEnabledContextIdsChanged() {
        return this.enabledContextIdsChanged;
    }
}

