/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.demo.controls;

import org.eclipse.rap.demo.controls.ExampleTab;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public final class CompositeTab
extends ExampleTab {
    private Composite composite;
    private boolean addMouseListener;
    private int backgroundMode;

    public CompositeTab() {
        super("Composite");
    }

    @Override
    protected void createStyleControls(Composite parent) {
        this.createStyleButton("BORDER", 2048);
        this.createOrientationButton();
        this.cteateRoundedBorderGroup();
        this.createVisibilityButton();
        this.createEnablementButton();
        this.createBgColorButton();
        this.createBgGradientButton();
        this.createBgImageButton();
        this.createBackgroundModeControls(parent);
        this.createCursorCombo();
        Button cbAddMouseListener = new Button(parent, 32);
        cbAddMouseListener.setText("Attach MouseListener");
        cbAddMouseListener.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CompositeTab.this.addMouseListener = !CompositeTab.this.addMouseListener;
                CompositeTab.this.createNew();
            }
        });
        cbAddMouseListener.setSelection(this.addMouseListener);
    }

    @Override
    protected void createExampleControls(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        parent.setBackgroundMode(this.backgroundMode);
        this.composite = new Composite(parent, this.getStyle());
        if (this.addMouseListener) {
            MouseListener listener = new MouseListener(){

                public void mouseDoubleClick(MouseEvent e) {
                    CompositeTab.this.log("mouseDoubleClick: " + e);
                }

                public void mouseDown(MouseEvent e) {
                    CompositeTab.this.log("mouseDown: " + e);
                }

                public void mouseUp(MouseEvent e) {
                    CompositeTab.this.log("mouseUp: " + e);
                }
            };
            this.composite.addMouseListener(listener);
        }
        this.composite.setLayout((Layout)new RowLayout(256));
        this.registerControl((Control)this.composite);
        Label label = new Label(this.composite, 0);
        label.setText("Label");
        Button pushButton = new Button(this.composite, 8);
        pushButton.setText("Push Button");
        Button radioButton = new Button(this.composite, 16);
        radioButton.setText("Radio Button");
        Button checkButton = new Button(this.composite, 32);
        checkButton.setText("Check Box");
        Text text = new Text(this.composite, 2052);
        text.setText("text");
        Text multiText = new Text(this.composite, 2050);
        multiText.setText("Multiline Text");
        multiText.setLayoutData((Object)new RowData(80, 60));
        Combo combo = new Combo(this.composite, 0);
        combo.add("Item 1");
        combo.add("Item 2");
        combo.add("Item 3");
        List list = new List(this.composite, 2048);
        list.add("Item 1");
        list.add("Item 2");
        list.add("Item 3");
        Composite composite2 = new Composite(this.composite, 0);
        composite2.setBackground(this.bgColors[1]);
        Group group = new Group(this.composite, 0);
        group.setText("Group");
        new DateTime(this.composite, 2176);
        new Spinner(this.composite, 2048);
    }

    protected void createBackgroundModeControls(Composite parent) {
        Group group = new Group(parent, 0);
        group.setText("Background Mode");
        group.setLayout((Layout)new GridLayout());
        Button noneButton = new Button((Composite)group, 16);
        noneButton.setText("SWT.INHERIT_NONE");
        final Button defaultButton = new Button((Composite)group, 16);
        defaultButton.setText("SWT.INHERIT_DEFAULT");
        final Button forceButton = new Button((Composite)group, 16);
        forceButton.setText("SWT.INHERIT_FORCE");
        SelectionAdapter selectionAdapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (defaultButton.getSelection()) {
                    CompositeTab.this.backgroundMode = 1;
                } else if (forceButton.getSelection()) {
                    CompositeTab.this.backgroundMode = 2;
                } else {
                    CompositeTab.this.backgroundMode = 0;
                }
                CompositeTab.this.composite.setBackgroundMode(CompositeTab.this.backgroundMode);
            }
        };
        noneButton.addSelectionListener((SelectionListener)selectionAdapter);
        defaultButton.addSelectionListener((SelectionListener)selectionAdapter);
        forceButton.addSelectionListener((SelectionListener)selectionAdapter);
        noneButton.setSelection(true);
    }
}

